/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.ArrayTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.SdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProvider;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.TypeDefinitionUtil;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.valueprovider.SdkValueProviderDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.valueprovider.SdkValueProviderInline;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.valueprovider.SdkValueProviderReference;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.OAuthParameter;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;

public class SdkParameter
extends JavaTemplateEntity {
    private final Parameter parameter;
    private final SdkConnector connector;
    private final JavaTemplateEntity parentElement;
    private final String parentJavaName;
    private AbstractSdkResolverProvider sdkValueProvider;

    public SdkParameter(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, String parentJavaName, Parameter parameter, JavaTemplateEntity parentElement, RestSdkRunConfiguration runConfiguration) {
        super(outputDir, connectorModel, runConfiguration);
        this.parameter = parameter;
        this.connector = sdkConnector;
        this.parentJavaName = parentJavaName;
        this.parentElement = parentElement;
    }

    public String getDescription() {
        return this.parameter.getDescription();
    }

    public String getDisplayName() {
        return this.parameter.getDisplayName();
    }

    protected String getInternalName() {
        return this.parameter.getInternalName();
    }

    public String getExternalName() {
        return this.parameter.getExternalName();
    }

    protected TypeDefinition getTypeDefinition() {
        return this.parameter.getTypeDefinition();
    }

    protected String getDefaultValue() {
        return this.parameter.getDefaultValue();
    }

    protected boolean getRequired() {
        return this.parameter.isRequired();
    }

    public ParameterType getParameterType() {
        return this.parameter.getParameterType();
    }

    protected String getEnumClassName() {
        return this.isEnum() || this.isInnerTypeEnum() ? SdkParameter.buildEnumName(this.connector.getEnumValuesName(), this.parentJavaName, this) : null;
    }

    protected String getEnumClassPackage() {
        return this.connectorModel.getBasePackage() + ".api.metadata";
    }

    protected AbstractSdkResolverProvider getSdkValueProvider() {
        if (this.sdkValueProvider != null) {
            return this.sdkValueProvider;
        }
        if (this.parentElement instanceof SdkOperation && this.parameter.getValueProvider() != null) {
            if (this.parameter.getValueProvider() instanceof ResolverDefinition) {
                this.sdkValueProvider = new SdkValueProviderInline(this.outputDir, this.connectorModel, (SdkOperation)this.parentElement, this.parameter, new SdkValueProviderDefinition((ResolverExpression<ValueProviderDefinition>)this.parameter.getValueProvider()), this.runConfiguration);
                return this.sdkValueProvider;
            }
            if (this.parameter.getValueProvider() instanceof ResolverReference) {
                this.sdkValueProvider = new SdkValueProviderReference(this.outputDir, this.connectorModel, this.connector, (SdkOperation)this.parentElement, this.parameter, (ResolverReference<ValueProviderDefinition>)((ResolverReference)this.parameter.getValueProvider()), new SdkValueProviderDefinition((ResolverExpression<ValueProviderDefinition>)this.parameter.getValueProvider()), this.runConfiguration);
                return this.sdkValueProvider;
            }
            throw new IllegalArgumentException("Value Provider generation not supported: " + this.parameter.getValueProvider());
        }
        return null;
    }

    public String getJavaName() {
        return JavaUtils.getParameterJavaName((String)this.getInternalName(), (boolean)this.isArrayType());
    }

    public boolean isArrayType() {
        return this.getTypeDefinition() instanceof ArrayTypeDefinition;
    }

    public TypeName getTypeName() {
        return this.getParameterTypeName(this.getTypeDefinition(), false);
    }

    private TypeName getParameterTypeName(TypeDefinition typeDefinition, boolean isInnerType) {
        if (typeDefinition instanceof ArrayTypeDefinition) {
            TypeDefinition innerType = ((ArrayTypeDefinition)typeDefinition).getInnerType();
            return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.getParameterTypeName(innerType, true)});
        }
        if (typeDefinition.isEnum()) {
            return ClassName.get((String)this.getEnumClassPackage(), (String)this.getEnumClassName(), (String[])new String[0]);
        }
        Type parameterPrimitiveJavaType = SdkParameter.getParameterPrimitiveJavaType(typeDefinition);
        if (isInnerType && parameterPrimitiveJavaType.equals(Boolean.TYPE)) {
            return TypeName.get(Boolean.class);
        }
        return TypeName.get((Type)parameterPrimitiveJavaType);
    }

    private static Type getParameterPrimitiveJavaType(TypeDefinition typeDefinition) {
        if (typeDefinition instanceof ArrayTypeDefinition) {
            throw new IllegalArgumentException("Type is not primitive. Should handle arrays in templating.");
        }
        Type javaType = TypeDefinitionUtil.getJavaType(typeDefinition);
        if (javaType.equals(InputStream.class)) {
            return String.class;
        }
        if (javaType.equals(Date.class)) {
            return String.class;
        }
        return javaType;
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        if (this.isEnum() || this.isInnerTypeEnum()) {
            this.generateEnumClass();
        }
        if (this.getSdkValueProvider() != null) {
            this.getSdkValueProvider().applyTemplates();
        }
    }

    private void generateEnumClass() throws TemplatingException {
        MethodSpec enumConstructor = MethodSpec.constructorBuilder().addParameter(String.class, "value", new Modifier[0]).addCode(CodeBlock.builder().addStatement("this.value = value", new Object[0]).build()).build();
        MethodSpec valueGetterMethod = MethodSpec.methodBuilder((String)"getValue").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addCode(CodeBlock.builder().addStatement("return value", new Object[0]).build()).build();
        TypeSpec.Builder enumClassBuilder = TypeSpec.enumBuilder((String)this.getEnumClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(String.class, "value", new Modifier[]{Modifier.PRIVATE}).addMethod(enumConstructor).addMethod(valueGetterMethod);
        for (String enumConstant : this.getEnumValues()) {
            enumClassBuilder.addEnumConstant(JavaUtils.getJavaConstantNameFromXml((String)XmlUtils.getXmlName((String)enumConstant)), TypeSpec.anonymousClassBuilder((String)"$S", (Object[])new Object[]{enumConstant}).build());
        }
        JavaFile.Builder javaFileBuilder = JavaFile.builder((String)this.getEnumClassPackage(), (TypeSpec)enumClassBuilder.build()).skipJavaLangImports(true);
        this.writeJavaFile(javaFileBuilder.build());
    }

    private static String buildEnumName(Map<List<String>, String> enumValuesName, String parentJavaName, SdkParameter sdkParameter) {
        List enumValuesKey = enumValuesName.keySet().stream().filter(x -> x.equals(sdkParameter.getEnumValues())).findFirst().orElse(null);
        if (enumValuesKey != null) {
            return enumValuesName.get(enumValuesKey);
        }
        String parameterNameBasedEnumName = StringUtils.capitalize((String)sdkParameter.getJavaName()) + "Enum";
        if (!enumValuesName.containsValue(parameterNameBasedEnumName)) {
            enumValuesName.put(sdkParameter.getEnumValues(), parameterNameBasedEnumName);
            return parameterNameBasedEnumName;
        }
        String operationNameBasedEnumName = parentJavaName + parameterNameBasedEnumName;
        enumValuesName.put(sdkParameter.getEnumValues(), operationNameBasedEnumName);
        return operationNameBasedEnumName;
    }

    public ParameterSpec.Builder generateParameterParameter() {
        return this.generateParameterParameter(null);
    }

    public ParameterSpec.Builder generateParameterParameter(TypeName forcedTypeName) {
        AnnotationSpec nullSafeAnnotation;
        ParameterSpec.Builder paramSpecBuilder = forcedTypeName == null ? ParameterSpec.builder((TypeName)this.getTypeName(), (String)this.getJavaName(), (Modifier[])new Modifier[0]) : ParameterSpec.builder((TypeName)forcedTypeName, (String)this.getJavaName(), (Modifier[])new Modifier[0]);
        AnnotationSpec optionalAnnotation = this.getOptionalAnnotation();
        if (optionalAnnotation != null) {
            paramSpecBuilder.addAnnotation(optionalAnnotation);
        }
        if ((nullSafeAnnotation = this.getNullSafeAnnotation()) != null) {
            paramSpecBuilder.addAnnotation(nullSafeAnnotation);
        }
        paramSpecBuilder.addAnnotation(this.getDisplayNameAnnotation());
        AnnotationSpec summaryAnnotation = this.getSummaryAnnotation();
        if (summaryAnnotation != null) {
            paramSpecBuilder.addAnnotation(summaryAnnotation);
        }
        if (this.getSdkValueProvider() != null) {
            paramSpecBuilder.addAnnotation(this.getValueProviderAnnotation());
        }
        return paramSpecBuilder;
    }

    private AnnotationSpec getValueProviderAnnotation() {
        return AnnotationSpec.builder(OfValues.class).addMember("value", "$T.class", new Object[]{ClassName.get((String)this.getSdkValueProvider().getPackage(), (String)this.getSdkValueProvider().getJavaClassName(), (String[])new String[0])}).build();
    }

    public FieldSpec.Builder generateParameterField() {
        AnnotationSpec parameterAnnotation = AnnotationSpec.builder(org.mule.runtime.extension.api.annotation.param.Parameter.class).build();
        return this.generateParameterField(parameterAnnotation);
    }

    public FieldSpec.Builder generateOAuthParameterField() {
        AnnotationSpec parameterAnnotation = AnnotationSpec.builder(OAuthParameter.class).addMember("requestAlias", "$S", new Object[]{this.getExternalName()}).build();
        return this.generateParameterField(parameterAnnotation);
    }

    private FieldSpec.Builder generateParameterField(AnnotationSpec parameterAnnotation) {
        AnnotationSpec summaryAnnotation;
        FieldSpec.Builder fieldSpecBuilder = FieldSpec.builder((TypeName)this.getTypeName(), (String)this.getJavaName(), (Modifier[])new Modifier[0]).addAnnotation(parameterAnnotation).addAnnotation(this.getDisplayNameAnnotation());
        AnnotationSpec optionalAnnotation = this.getOptionalAnnotation();
        if (optionalAnnotation != null) {
            fieldSpecBuilder.addAnnotation(optionalAnnotation);
        }
        if ((summaryAnnotation = this.getSummaryAnnotation()) != null) {
            fieldSpecBuilder.addAnnotation(summaryAnnotation);
        }
        return fieldSpecBuilder;
    }

    private AnnotationSpec getNullSafeAnnotation() {
        if (!this.getRequired() && this.isArrayType()) {
            return AnnotationSpec.builder(NullSafe.class).build();
        }
        return null;
    }

    private AnnotationSpec getOptionalAnnotation() {
        if (!this.getRequired() || StringUtils.isNotBlank((CharSequence)this.getDefaultValue())) {
            AnnotationSpec.Builder optionalBuilder = AnnotationSpec.builder(Optional.class);
            if (StringUtils.isNotBlank((CharSequence)this.getDefaultValue())) {
                if (this.isEnum()) {
                    optionalBuilder.addMember("defaultValue", "$S", new Object[]{JavaUtils.getJavaConstantNameFromXml((String)XmlUtils.getXmlName((String)this.getDefaultValue()))});
                } else {
                    optionalBuilder.addMember("defaultValue", "$S", new Object[]{this.getDefaultValue()});
                }
            }
            return optionalBuilder.build();
        }
        return null;
    }

    private AnnotationSpec getDisplayNameAnnotation() {
        return AnnotationSpec.builder(DisplayName.class).addMember("value", "$S", new Object[]{this.getDisplayName()}).build();
    }

    private AnnotationSpec getSummaryAnnotation() {
        if (StringUtils.isNotBlank((CharSequence)this.getDescription())) {
            return AnnotationSpec.builder(Summary.class).addMember("value", "$S", new Object[]{JavaUtils.abbreviateText((String)this.getDescription())}).build();
        }
        return null;
    }

    public String getStringValueGetter() {
        return SdkParameter.getStringValueGetter(this.getTypeDefinition(), this.getJavaName(), this.getRequired());
    }

    public String getStringValueGetter(String varName) {
        return SdkParameter.getStringValueGetter(this.getTypeDefinition(), varName, this.getRequired());
    }

    public String getInnerTypeStringValueGetter(String varName) {
        return SdkParameter.getStringValueGetter(((ArrayTypeDefinition)this.getTypeDefinition()).getInnerType(), varName, true);
    }

    private static String getStringValueGetter(TypeDefinition typeDefinition, String varName, boolean required) {
        StringBuilder stringBuilder = new StringBuilder();
        Type javaType = TypeDefinitionUtil.getJavaType(typeDefinition);
        if (SdkParameter.requiresNullCheck(required, typeDefinition.isEnum(), javaType)) {
            stringBuilder.append(varName).append(" != null ? ");
        }
        if (typeDefinition.isEnum()) {
            stringBuilder.append(varName).append(".getValue()");
        } else if (javaType.equals(String.class)) {
            stringBuilder.append(varName);
        } else {
            stringBuilder.append("String.valueOf(").append(varName).append(")");
        }
        if (SdkParameter.requiresNullCheck(required, typeDefinition.isEnum(), javaType)) {
            stringBuilder.append(" : null");
        }
        return stringBuilder.toString();
    }

    private static boolean requiresNullCheck(boolean required, boolean isEnum, Type javaType) {
        return !required && (isEnum || !javaType.equals(Boolean.TYPE) && !javaType.equals(String.class));
    }

    private boolean isEnum() {
        return this.getTypeDefinition().isEnum();
    }

    private boolean isInnerTypeEnum() {
        return this.getTypeDefinition() instanceof ArrayTypeDefinition && ((ArrayTypeDefinition)this.getTypeDefinition()).getInnerType().isEnum();
    }

    private List<String> getEnumValues() {
        if (this.isEnum()) {
            return this.getTypeDefinition().getEnumValues();
        }
        if (this.isInnerTypeEnum()) {
            return ((ArrayTypeDefinition)this.getTypeDefinition()).getInnerType().getEnumValues();
        }
        return null;
    }
}

