/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.munit;

import com.mulesoft.connectivity.rest.sdk.templating.VelocityTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;

import java.nio.file.Path;

public class SdkTestLog4j extends VelocityTemplateEntity {

  private final static String LOG_4_J_TEST_VM = "templates/sdk/log4j-test.vm";

  public SdkTestLog4j(Path outputDir) {
    super(outputDir);
  }

  @Override
  public void applyTemplates() throws TemplatingException {
    applyTemplate(LOG_4_J_TEST_VM, outputDir.resolve("src/test/resources/log4j-test.xml"));
  }
}
