/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.valueprovider;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils.getJavaUpperCamelNameFromXml;
import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.getXmlName;

import com.mulesoft.connectivity.rest.commons.api.datasense.valueprovider.RestValueProvider;
import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.BindingField;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.AbstractSdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProviderReferenceParent;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverDefinition;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;

import com.squareup.javapoet.TypeName;

public class SdkValueProviderReferenceParent extends AbstractSdkResolverProviderReferenceParent {

  private final ResolverReference<ValueProviderDefinition> resolverReference;
  private final AbstractSdkOperation sdkOperation;

  public SdkValueProviderReferenceParent(Path outputDir,
                                         ConnectorModel connectorModel,
                                         AbstractSdkOperation sdkOperation,
                                         ResolverReference<ValueProviderDefinition> resolverReference,
                                         SdkResolverDefinition<ValueProviderDefinition> sdkResolverDefinition,
                                         RestSdkRunConfiguration runConfiguration) {
    super(outputDir, connectorModel, resolverReference, sdkResolverDefinition, runConfiguration);
    this.resolverReference = resolverReference;
    this.sdkOperation = sdkOperation;
  }

  @Override
  public String getPackage() {
    return connectorModel.getBasePackage() + ".internal.metadata.values";
  }

  public String getJavaClassName() {
    return getJavaUpperCamelNameFromXml(getXmlName(resolverReference.getDeclaration().getName())) + "RestValueProvider";
  }

  @Override
  protected TypeName getSuperClass() {
    return TypeName.get(RestValueProvider.class);
  }

  @Override
  protected boolean isBoundParameter(SdkParameter sdkParameter) {
    return false;
  }

  @Override
  protected List<SdkParameter> getAllParameters() {
    return sdkOperation.getAllParameters();
  }

  @Override
  protected List<BindingField> getBindingFields() {
    return Collections.emptyList();
  }

  @Override
  protected String getEvaluationContextKind() {
    return null;
  }
}
