/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata.SdkInputMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.FileGenerationUtil;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.file.Path;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Content;

public class SdkAuxiliarParameter
extends SdkParameter {
    private SdkInputMetadataResolver inputMetadataResolver = null;

    public SdkAuxiliarParameter(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, String parentJavaName, Parameter parameter, JavaTemplateEntity parentElement, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, sdkConnector, parentJavaName, parameter, parentElement, runConfiguration);
        TypeDefinition typeDefinition = parameter.getTypeDefinition();
        if (typeDefinition.getTypeSchema() != null) {
            this.inputMetadataResolver = new SdkInputMetadataResolver(outputDir, connectorModel, sdkConnector, operation, typeDefinition, FileGenerationUtil.SchemaNameType.INPUT, parameter.getInternalName(), runConfiguration);
        }
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        super.applyTemplates();
        if (this.inputMetadataResolver != null) {
            this.inputMetadataResolver.applyTemplates();
        }
    }

    @Override
    protected void configureParameterSpecBuilder(ParameterSpec.Builder paramSpecBuilder) {
        super.configureParameterSpecBuilder(paramSpecBuilder);
        if (this.inputMetadataResolver != null && this.inputMetadataResolver.getRequiresMetadataResolver()) {
            paramSpecBuilder.addAnnotation(this.generateMetadataResolverAnnotation()).addAnnotation(this.generateContentAnnotation());
        }
    }

    private AnnotationSpec generateMetadataResolverAnnotation() {
        return AnnotationSpec.builder(TypeResolver.class).addMember("value", "$T.class", new Object[]{ClassName.get((String)this.inputMetadataResolver.getPackage(), (String)this.inputMetadataResolver.getClassName(), (String[])new String[0])}).build();
    }

    private AnnotationSpec generateContentAnnotation() {
        return AnnotationSpec.builder(Content.class).build();
    }

    @Override
    public TypeName getTypeName() {
        return this.inputMetadataResolver != null ? ParameterizedTypeName.get(TypedValue.class, (Type[])new Type[]{InputStream.class}) : super.getTypeName();
    }
}

