/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.util;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata.SdkInputMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkContent;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.mule.runtime.extension.api.util.NameUtils;

public class ContentNameGenerator {
    private static final String CONTENT_DEFAULT_NAME = "body";

    public static String getContentName(ConnectorOperation operation, SdkInputMetadataResolver metadataResolver, SdkContent.SdkContentKind contentType, String partName) {
        StringBuilder xmlTypeName = new StringBuilder(operation.getInternalName());
        switch (contentType) {
            case INPUT_METADATA: {
                break;
            }
            case PART: {
                xmlTypeName.append("-").append(XmlUtils.getXmlName((String)partName));
            }
        }
        xmlTypeName.append("-").append(CONTENT_DEFAULT_NAME);
        String javaContentName = JavaUtils.getJavaLowerCamelNameFromXml((String)xmlTypeName.toString());
        return ContentNameGenerator.pluralizeBySchema(javaContentName, metadataResolver);
    }

    private static String pluralizeBySchema(String javaContentName, SdkInputMetadataResolver metadataResolver) {
        JsonTypeLoader jsonTypeLoader;
        Optional metadataType;
        String result = javaContentName;
        String schemaName = metadataResolver.getSchemaName();
        if (StringUtils.isNotBlank((CharSequence)schemaName) && schemaName.endsWith(".json") && (metadataType = (jsonTypeLoader = new JsonTypeLoader(metadataResolver.getTypeDefinition().getTypeSchema().getRawSchema())).load(null)).isPresent() && metadataType.get() instanceof ArrayType) {
            result = NameUtils.pluralize((String)javaContentName);
        }
        return result;
    }
}

