/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating;

import com.google.common.base.CaseFormat;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.templating.TemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;

public abstract class JavaTemplateEntity
extends TemplateEntity {
    protected static final String VALUE_MEMBER = "value";
    protected static final String NAME_MEMBER = "name";
    private static final String NULL = "null";
    protected final Path outputDir;
    protected final ConnectorModel connectorModel;
    protected final RestSdkRunConfiguration runConfiguration;

    public JavaTemplateEntity(Path outputDir, ConnectorModel connectorModel, RestSdkRunConfiguration runConfiguration) {
        this.outputDir = outputDir;
        this.connectorModel = connectorModel;
        this.runConfiguration = runConfiguration;
    }

    protected void writeClassToFile(TypeSpec clazz, String targetPackage) throws TemplatingException {
        this.writeJavaFile(this.getJavaFileBuilderForClass(clazz, targetPackage).build());
    }

    protected JavaFile.Builder getJavaFileBuilderForClass(TypeSpec clazz, String targetPackage) {
        return JavaFile.builder((String)targetPackage, (TypeSpec)clazz).skipJavaLangImports(true);
    }

    protected void writeJavaFile(JavaFile javaFile) throws TemplatingException {
        try {
            if (this.shouldGenerate(javaFile)) {
                javaFile.writeTo(this.outputDir.resolve(this.runConfiguration.generatedSourceDir()));
            } else {
                String packageDirectory = javaFile.packageName.replace('.', File.separatorChar);
                this.runConfiguration.messageCollector().addInfo("Ignoring: '" + packageDirectory + File.separatorChar + javaFile.typeSpec.name + ".java' as it was overwritten.");
                Path ignoredDir = this.outputDir.resolve(this.runConfiguration.ignoredDir());
                javaFile.writeTo(ignoredDir);
                Path generatedIgnoredFile = this.resolveJavaFile(javaFile, this.runConfiguration.ignoredDir());
                if (generatedIgnoredFile.toFile().exists()) {
                    this.compareToOverrideOne(javaFile, generatedIgnoredFile, this.runConfiguration.overrideDir());
                    this.compareToOverrideOne(javaFile, generatedIgnoredFile, this.runConfiguration.sourceDir());
                }
            }
        }
        catch (Exception e) {
            throw new TemplatingException("There was an error when writing " + this.getClass().getName() + " class", e);
        }
    }

    private void compareToOverrideOne(JavaFile javaFile, Path ignoredFile, String overrideDir) throws IOException {
        Path overwrittenFile = this.resolveJavaFile(javaFile, overrideDir);
        if (overwrittenFile.toFile().exists()) {
            String currentContent = new String(Files.readAllBytes(overwrittenFile), StandardCharsets.UTF_8);
            String newContent = new String(Files.readAllBytes(ignoredFile), StandardCharsets.UTF_8);
            boolean isIdentical = this.toCanonicalWay(currentContent).equals(this.toCanonicalWay(newContent));
            if (isIdentical) {
                this.runConfiguration.messageCollector().addWarning("Overwritten file `" + overwrittenFile + "` can be removed as is the same as the generated one.");
            }
        }
    }

    private String toCanonicalWay(String currentContent) {
        return currentContent.replaceAll("\\s+", " ");
    }

    private boolean shouldGenerate(JavaFile javaFile) {
        boolean isOldWay;
        boolean bl = isOldWay = !this.runConfiguration.regenerateMode();
        if (isOldWay) {
            return true;
        }
        Path inOverride = this.resolveJavaFile(javaFile, this.runConfiguration.overrideDir());
        Path inSourceDir = this.resolveJavaFile(javaFile, this.runConfiguration.sourceDir());
        return !inOverride.toFile().exists() && !inSourceDir.toFile().exists();
    }

    private Path resolveJavaFile(JavaFile javaFile, String targetRelativeFolderPath) {
        String javaFileName = javaFile.typeSpec.name + ".java";
        String packageDirectory = javaFile.packageName.replace('.', File.separatorChar);
        Path resolve = this.outputDir.resolve(targetRelativeFolderPath).resolve(packageDirectory).resolve(javaFileName);
        return resolve;
    }

    public Path getResourcesPath() {
        return this.outputDir.resolve(this.runConfiguration.generatedResourcesDir());
    }

    public Path getSourcesPath() {
        return this.outputDir.resolve("src");
    }

    protected MethodSpec.Builder generateGetter(FieldSpec fieldSpec, CaseFormat fieldNameCaseFormat) {
        String name = "get" + fieldNameCaseFormat.to(CaseFormat.UPPER_CAMEL, fieldSpec.name);
        return MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(fieldSpec.type).addCode(CodeBlock.builder().addStatement("return this.$N", new Object[]{fieldSpec}).build());
    }

    protected MethodSpec.Builder generateOptionalGetter(FieldSpec fieldSpec, Class<?> type, CaseFormat fieldNameCaseFormat) {
        String name = "get" + fieldNameCaseFormat.to(CaseFormat.UPPER_CAMEL, fieldSpec.name);
        return MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get(Optional.class, (Type[])new Type[]{type})).addCode(CodeBlock.builder().addStatement("return $T.ofNullable(this.$N)", new Object[]{Optional.class, fieldSpec}).build());
    }

    public static FieldSpec getConstantStringField(String fieldName, String value) {
        FieldSpec.Builder fieldSpecBuilder = FieldSpec.builder(String.class, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL});
        if (StringUtils.isNotBlank((CharSequence)value)) {
            fieldSpecBuilder.initializer("$S", new Object[]{value});
        } else {
            fieldSpecBuilder.initializer("$L", new Object[]{NULL});
        }
        return fieldSpecBuilder.build();
    }

    protected Class<?> getJavaType(ParameterDataType parameterDataType) {
        if (parameterDataType.equals((Object)ParameterDataType.LOCAL_DATE_TIME)) {
            return LocalDateTime.class;
        }
        if (parameterDataType.equals((Object)ParameterDataType.ZONED_DATE_TIME)) {
            return ZonedDateTime.class;
        }
        if (parameterDataType.equals((Object)ParameterDataType.STRING)) {
            return String.class;
        }
        if (parameterDataType.equals((Object)ParameterDataType.INTEGER)) {
            return Integer.class;
        }
        if (parameterDataType.equals((Object)ParameterDataType.NUMBER)) {
            return Double.class;
        }
        if (parameterDataType.equals((Object)ParameterDataType.BOOLEAN)) {
            return Boolean.TYPE;
        }
        throw new IllegalArgumentException(parameterDataType.getName() + " is not supported");
    }
}

