/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.valueprovider;

import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.BindingField;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.AbstractSdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProviderReference;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProviderReferenceParent;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.valueprovider.SdkValueProviderReferenceParent;
import com.squareup.javapoet.TypeName;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SdkValueProviderReference
extends AbstractSdkResolverProviderReference {
    private final String parameterName;
    private final SdkConnector sdkConnector;
    private final AbstractSdkOperation sdkOperation;
    private final ResolverReference<ValueProviderDefinition> reference;
    private final SdkResolverDefinition<ValueProviderDefinition> sdkResolverDefinition;

    public SdkValueProviderReference(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, AbstractSdkOperation sdkOperation, String parameterName, ResolverReference<ValueProviderDefinition> reference, SdkResolverDefinition<ValueProviderDefinition> sdkResolverDefinition, RestSdkRunConfiguration runConfiguration) {
        super(outputDir, connectorModel, reference, sdkResolverDefinition, runConfiguration);
        this.parameterName = parameterName;
        this.sdkConnector = sdkConnector;
        this.sdkOperation = sdkOperation;
        this.reference = reference;
        this.sdkResolverDefinition = sdkResolverDefinition;
    }

    @Override
    public String getPackage() {
        return this.connectorModel.getBasePackage() + ".internal.metadata.values";
    }

    @Override
    public String getJavaClassName() {
        return this.sdkOperation.getJavaClassName() + JavaUtils.getJavaUpperCamelNameFromXml((String)this.parameterName) + "ValueProvider";
    }

    @Override
    protected List<SdkParameter> getAllParameters() {
        return this.sdkOperation.getAllParameters();
    }

    @Override
    protected List<BindingField> getBindingFields() {
        String searchParam = ParameterType.BODY.getAccessorName() + ".";
        return this.reference.getArguments().stream().filter(x -> x.getValue().getValue().contains(searchParam)).map(argument -> new BindingField(argument.getName(), argument.getValue().getValue().replace(searchParam, ""))).collect(Collectors.toList());
    }

    @Override
    protected String getEvaluationContextKind() {
        return this.sdkResolverDefinition.getEvaluationContextKind();
    }

    @Override
    protected Map<String, TypeName> getAllParents() {
        return this.sdkConnector.getParentValueProviders();
    }

    @Override
    protected AbstractSdkResolverProviderReferenceParent getNewParent() {
        return new SdkValueProviderReferenceParent(this.outputDir, this.connectorModel, this.sdkOperation, this.reference, this.sdkResolverDefinition, this.runConfiguration);
    }
}

