/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeSpec;

import java.nio.file.Path;

public abstract class AbstractSdkResolverProviderInline extends AbstractSdkResolverProvider {

  private final SdkResolverDefinition<?> sdkResolverDefinition;

  public AbstractSdkResolverProviderInline(Path outputDir,
                                           ConnectorModel connectorModel,
                                           SdkResolverDefinition<?> sdkResolverDefinition,
                                           RestSdkRunConfiguration runConfiguration) {
    super(outputDir, connectorModel, runConfiguration);
    this.sdkResolverDefinition = sdkResolverDefinition;
  }

  /**
   * Generates the 'build' method of the resolver.
   */
  private void addBuildMethod(TypeSpec.Builder classBuilder) {
    sdkResolverDefinition.addBuildMethod(classBuilder, getBuildMethodBody());
  }

  private CodeBlock getBuildMethodBody() {
    return sdkResolverDefinition.getResolverExpressionBuilder().build();
  }

  @Override
  protected void buildClass(TypeSpec.Builder classBuilder) {
    sdkResolverDefinition.addClassConstants(classBuilder);
    addParameterFieldsIfNeeded(classBuilder);
    addConfigureEvaluationContextMethod(classBuilder);
    addBuildMethod(classBuilder);
  }
}
