/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.valueprovider;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils.getJavaUpperCamelNameFromXml;

import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.BindingField;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.AbstractSdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProviderReference;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProviderReferenceParent;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverDefinition;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.squareup.javapoet.TypeName;

public class SdkValueProviderReference extends AbstractSdkResolverProviderReference {

  private final String parameterName;
  private final SdkConnector sdkConnector;

  private final AbstractSdkOperation sdkOperation;
  private final ResolverReference<ValueProviderDefinition> reference;
  private final SdkResolverDefinition<ValueProviderDefinition> sdkResolverDefinition;


  public SdkValueProviderReference(Path outputDir,
                                   ConnectorModel connectorModel,
                                   SdkConnector sdkConnector,
                                   AbstractSdkOperation sdkOperation,
                                   String parameterName,
                                   ResolverReference<ValueProviderDefinition> reference,
                                   SdkResolverDefinition<ValueProviderDefinition> sdkResolverDefinition,
                                   RestSdkRunConfiguration runConfiguration) {
    super(outputDir, connectorModel, reference, sdkResolverDefinition, runConfiguration);
    this.parameterName = parameterName;
    this.sdkConnector = sdkConnector;
    this.sdkOperation = sdkOperation;
    this.reference = reference;
    this.sdkResolverDefinition = sdkResolverDefinition;
  }

  public String getPackage() {
    return connectorModel.getBasePackage() + ".internal.metadata.values";
  }

  public String getJavaClassName() {
    return sdkOperation.getJavaClassName() + getJavaUpperCamelNameFromXml(parameterName) + "ValueProvider";
  }

  @Override
  protected List<SdkParameter> getAllParameters() {
    return sdkOperation.getAllParameters();
  }

  @Override
  protected List<BindingField> getBindingFields() {
    final String searchParam = ParameterType.BODY.getAccessorName() + ".";

    return reference.getArguments().stream()
        .filter(x -> x.getValue().getValue().contains(searchParam))
        .map(argument -> new BindingField(argument.getName(), argument.getValue().getValue().replace(searchParam, "")))
        .collect(Collectors.toList());
  }

  @Override
  protected String getEvaluationContextKind() {
    return sdkResolverDefinition.getEvaluationContextKind();
  }

  @Override
  protected Map<String, TypeName> getAllParents() {
    return sdkConnector.getParentValueProviders();
  }

  @Override
  protected AbstractSdkResolverProviderReferenceParent getNewParent() {
    return new SdkValueProviderReferenceParent(outputDir,
                                               connectorModel,
                                               sdkOperation,
                                               reference,
                                               sdkResolverDefinition,
                                               runConfiguration);
  }
}
