/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter;

import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Field;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata.SdkInputMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkField;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProvider;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.ContentNameGenerator;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.FileGenerationUtil;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.binding.Binding;
import org.mule.sdk.api.annotation.values.FieldValues;

public class SdkContent
extends JavaTemplateEntity {
    public static final String BODY_DISPLAY_NAME = "Body";
    private final SdkInputMetadataResolver inputMetadataResolver;
    private final String contentParameterJavaName;
    private final boolean primary;
    private final TypeDefinition typeDefinition;
    private final String displayName;
    private final List<SdkField> sdkFields;
    private final SdkConnector sdkConnector;
    private final JavaTemplateEntity parentElement;

    public SdkContent(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, JavaTemplateEntity parentElement, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        this(outputDir, connectorModel, sdkConnector, operation, operation.getInputMetadata(), SdkContentKind.INPUT_METADATA, "", true, parentElement, runConfiguration);
    }

    public SdkContent(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, TypeDefinition typeDefinition, SdkContentKind contentType, String partName, boolean primary, JavaTemplateEntity parentElement, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, runConfiguration);
        this.typeDefinition = typeDefinition;
        FileGenerationUtil.SchemaNameType schemaNameType = contentType.equals((Object)SdkContentKind.INPUT_METADATA) ? FileGenerationUtil.SchemaNameType.INPUT : FileGenerationUtil.SchemaNameType.PART;
        this.inputMetadataResolver = new SdkInputMetadataResolver(outputDir, connectorModel, sdkConnector, operation, typeDefinition, schemaNameType, partName, runConfiguration);
        this.contentParameterJavaName = ContentNameGenerator.getContentName(operation, this.inputMetadataResolver, contentType, partName);
        this.primary = primary;
        this.displayName = this.buildDisplayName(schemaNameType, partName);
        this.sdkConnector = sdkConnector;
        this.parentElement = parentElement;
        this.sdkFields = operation.getBody() != null ? operation.getBody().getFields().stream().map(field -> new SdkField(outputDir, connectorModel, sdkConnector, (Field)field, parentElement, runConfiguration)).collect(Collectors.toList()) : new ArrayList<SdkField>();
    }

    private String buildDisplayName(FileGenerationUtil.SchemaNameType schemaNameType, String partName) {
        String result;
        if (FileGenerationUtil.SchemaNameType.INPUT.equals((Object)schemaNameType)) {
            result = BODY_DISPLAY_NAME;
        } else {
            String partDisplayName = RestSdkUtils.isNotBlank((String)this.typeDefinition.getDisplayName()) ? this.typeDefinition.getDisplayName() : StringUtils.capitalize((String)StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)partName), (String)" "));
            result = String.format("%s - %s", partDisplayName, BODY_DISPLAY_NAME);
        }
        return result;
    }

    private TypeName getTypeName() {
        return ParameterizedTypeName.get(TypedValue.class, (Type[])new Type[]{InputStream.class});
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.inputMetadataResolver.applyTemplates();
        for (SdkField sdkField : this.sdkFields) {
            sdkField.applyTemplates();
        }
    }

    public ParameterSpec generateContentParameter() {
        AnnotationSpec summaryAnnotation;
        ParameterSpec.Builder paramSpecBuilder = ParameterSpec.builder((TypeName)this.getTypeName(), (String)this.contentParameterJavaName, (Modifier[])new Modifier[0]).addAnnotation(this.generateContentAnnotation());
        AnnotationSpec displayNameAnnotation = this.generateDisplayNameAnnotation();
        if (displayNameAnnotation != null) {
            paramSpecBuilder.addAnnotation(displayNameAnnotation);
        }
        if ((summaryAnnotation = this.generateSummaryAnnotation()) != null) {
            paramSpecBuilder.addAnnotation(summaryAnnotation);
        }
        if (this.inputMetadataResolver != null && this.inputMetadataResolver.getRequiresMetadataResolver()) {
            paramSpecBuilder.addAnnotation(this.generateMetadataResolverAnnotation());
        }
        this.sdkFields.forEach(sdkField -> paramSpecBuilder.addAnnotation(this.getValueProviderAnnotation((SdkField)sdkField)));
        return paramSpecBuilder.build();
    }

    private AnnotationSpec getValueProviderAnnotation(SdkField sdkField) {
        AbstractSdkResolverProvider valueProvider = sdkField.getSdkValueProvider();
        AnnotationSpec.Builder annotationBuilder = AnnotationSpec.builder(FieldValues.class).addMember("value", "$T.class", new Object[]{ClassName.get((String)valueProvider.getPackage(), (String)valueProvider.getJavaClassName(), (String[])new String[0])}).addMember("targetSelectors", "$S", new Object[]{sdkField.getExternalName()});
        List<Argument> arguments = this.getArgumentsFromValueProvider((ResolverExpression<ValueProviderDefinition>)sdkField.getField().getValueProvider());
        for (Argument argument : arguments) {
            annotationBuilder.addMember("bindings", "$L", new Object[]{AnnotationSpec.builder(Binding.class).addMember("actingParameter", "$S", new Object[]{argument.getName()}).addMember("extractionExpression", "$S", new Object[]{this.transformBodyPrefix(argument.getValue().getValue())}).build()});
        }
        return annotationBuilder.build();
    }

    private String transformBodyPrefix(String expression) {
        if (expression.startsWith("body")) {
            expression = expression.replace("body", this.contentParameterJavaName);
        }
        return expression;
    }

    private List<Argument> getArgumentsFromValueProvider(ResolverExpression<ValueProviderDefinition> valueProviderExpression) {
        if (valueProviderExpression instanceof ValueProviderDefinition) {
            ValueProviderDefinition valueProviderDefinition = (ValueProviderDefinition)valueProviderExpression;
            return this.getArgumentsFromValueProviderDefinition(valueProviderDefinition);
        }
        if (valueProviderExpression instanceof ResolverReference) {
            ResolverReference valueProviderReference = (ResolverReference)valueProviderExpression;
            return valueProviderReference.getArguments();
        }
        throw new IllegalArgumentException("Invalid valueProviderExpression. This is a bug.");
    }

    private List<Argument> getArgumentsFromValueProviderDefinition(ValueProviderDefinition valueProviderDefinition) {
        HttpRequestBinding httpRequestBinding = valueProviderDefinition.getRequest().getHttpRequestBinding();
        ArrayList arguments = new ArrayList();
        if (httpRequestBinding != null) {
            arguments.addAll(httpRequestBinding.getQueryParameter());
            arguments.addAll(httpRequestBinding.getUriParameter());
            arguments.addAll(httpRequestBinding.getHeader());
        }
        return arguments.stream().filter(argument -> argument.getValue().getValue().contains("body.")).collect(Collectors.toList());
    }

    private AnnotationSpec generateDisplayNameAnnotation() {
        if (RestSdkUtils.isBlank((CharSequence)this.displayName)) {
            return null;
        }
        return AnnotationSpec.builder(DisplayName.class).addMember("value", "$S", new Object[]{this.displayName}).build();
    }

    private AnnotationSpec generateSummaryAnnotation() {
        String summary = this.typeDefinition.getDescription();
        if (RestSdkUtils.isBlank((CharSequence)summary)) {
            return null;
        }
        return AnnotationSpec.builder(Summary.class).addMember("value", "$S", new Object[]{summary}).build();
    }

    private AnnotationSpec generateMetadataResolverAnnotation() {
        return AnnotationSpec.builder(TypeResolver.class).addMember("value", "$T.class", new Object[]{ClassName.get((String)this.inputMetadataResolver.getPackage(), (String)this.inputMetadataResolver.getClassName(), (String[])new String[0])}).build();
    }

    private AnnotationSpec generateContentAnnotation() {
        return AnnotationSpec.builder(Content.class).addMember("primary", "$L", new Object[]{this.primary}).build();
    }

    public String getContentParameterJavaName() {
        return this.contentParameterJavaName;
    }

    public static enum SdkContentKind {
        INPUT_METADATA,
        PART;

    }
}

