/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils.getParameterJavaName;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.NamingUtil.buildParameterInternalName;
import static java.util.Collections.emptyList;

import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.BindingField;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class SdkResolverUtil {

  public static String getBindingMethod(ParameterType parameterType) {
    switch (parameterType) {
      case URI:
        return "uriParameter";
      case QUERY:
        return "queryParameter";
      case HEADER:
        return "header";
      default:
        throw new IllegalArgumentException();
    }
  }

  public static boolean isBoundParameterForHttpBinding(SdkParameter sdkParameter,
                                                       HttpRequestBinding httpBinding) {
    if (httpBinding == null) {
      return false;
    }

    List<Argument> parameterBindings;

    switch (sdkParameter.getParameterType()) {
      case URI:
        parameterBindings = httpBinding.getUriParameter();
        break;
      case QUERY:
        parameterBindings = httpBinding.getQueryParameter();
        break;
      case HEADER:
        parameterBindings = httpBinding.getHeader();
        break;
      default:
        throw new IllegalArgumentException("Parameter type not supported. This is a bug.");
    }

    return parameterBindings.stream().anyMatch(x -> x.getValue().getValue()
        .contains(getBindingMethod(sdkParameter.getParameterType()) + "." + sdkParameter.getExternalName()));
  }

  public static List<BindingField> getBodyFieldsFromHttpBinding(HttpRequestBinding httpBinding) {
    if (httpBinding == null) {
      return Collections.emptyList();
    }

    final String searchParam = ParameterType.BODY.getAccessorName() + ".";

    List<Argument> parameterBindings = new ArrayList<>();
    parameterBindings.addAll(httpBinding.getUriParameter());
    parameterBindings.addAll(httpBinding.getQueryParameter());
    parameterBindings.addAll(httpBinding.getHeader());

    return parameterBindings.stream()
        .filter(x -> x.getValue().getValue().contains(searchParam))
        .map(argument -> new BindingField(argument.getName(), argument.getValue().getValue().replace(searchParam, "")))
        .collect(Collectors.toList());
  }

  public static String getActingParameterJavaName(Argument argument) {
    return getParameterJavaName(
                                buildParameterInternalName(
                                                           argument.getName(),
                                                           emptyList(),
                                                           ParameterType.BODY),
                                false);
  }

}
