/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver;

import com.mulesoft.connectivity.rest.commons.internal.model.builder.common.EvaluationContextBuilderFactory;
import com.mulesoft.connectivity.rest.commons.internal.model.common.EvaluationContext;
import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.BindingField;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.NamingUtil;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.mule.runtime.extension.api.annotation.param.Parameter;

public abstract class AbstractSdkResolverProvider
extends JavaTemplateEntity {
    public AbstractSdkResolverProvider(Path outputDir, ConnectorModel connectorModel, RestSdkRunConfiguration runConfiguration) {
        super(outputDir, connectorModel, runConfiguration);
    }

    public abstract String getPackage();

    public abstract String getJavaClassName();

    @Override
    public void applyTemplates() throws TemplatingException {
        this.generateClass();
    }

    protected void generateClass() throws TemplatingException {
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(this.getSuperClass());
        this.buildClass(classBuilder);
        JavaFile.Builder javaFileBuilder = this.getJavaFileBuilderForClass(classBuilder.build(), this.getPackage());
        this.writeJavaFile(javaFileBuilder.build());
    }

    protected abstract TypeName getSuperClass();

    protected abstract void buildClass(TypeSpec.Builder var1);

    protected abstract boolean isBoundParameter(SdkParameter var1);

    protected abstract List<SdkParameter> getAllParameters();

    protected abstract List<BindingField> getBindingFields();

    protected abstract String getEvaluationContextKind();

    protected void addParameterFieldsIfNeeded(TypeSpec.Builder classBuilder) {
        for (SdkParameter sdkParameter : this.getAllParameters()) {
            if (!this.isBoundParameter(sdkParameter)) continue;
            classBuilder.addField(this.getParameterFieldSpec(sdkParameter));
        }
        for (BindingField field : this.getBindingFields()) {
            classBuilder.addField(this.getParameterFieldSpec(field));
        }
    }

    private FieldSpec getParameterFieldSpec(SdkParameter sdkParameter) {
        FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)sdkParameter.getTypeName(), (String)sdkParameter.getJavaName(), (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Parameter.class);
        return fieldBuilder.build();
    }

    private FieldSpec getParameterFieldSpec(BindingField field) {
        FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)TypeName.get(String.class), (String)JavaUtils.getParameterJavaName((String)NamingUtil.buildParameterInternalName((String)field.getName(), Collections.emptyList(), (ParameterType)ParameterType.BODY), (boolean)false), (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Parameter.class);
        return fieldBuilder.build();
    }

    protected void addConfigureEvaluationContextMethod(TypeSpec.Builder classBuilder) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"buildEvaluationContext").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(EvaluationContext.class).addParameter(TypeName.get(EvaluationContextBuilderFactory.class), "builderFactory", new Modifier[0]).addAnnotation(Override.class);
        this.addParameterBindings(methodBuilder, this.getAllParameters(), this.getBindingFields());
        classBuilder.addMethod(methodBuilder.build());
    }

    private void addParameterBindings(MethodSpec.Builder methodBuilder, List<SdkParameter> parameters, List<BindingField> fields) {
        int count = 0;
        CodeBlock.Builder contextBindingBuilder = CodeBlock.builder();
        contextBindingBuilder.add("return builderFactory.", new Object[0]);
        for (SdkParameter sdkParameter : parameters) {
            if (!this.isBoundParameter(sdkParameter)) continue;
            if (count == 0) {
                ++count;
                contextBindingBuilder.add("$LContextBuilder()", new Object[]{this.getEvaluationContextKind()});
            }
            contextBindingBuilder.add(".$1L($2S, $3L)", new Object[]{sdkParameter.getParameterType().getAccessorName(), sdkParameter.getExternalName(), sdkParameter.getJavaName()});
        }
        for (BindingField field : fields) {
            if (count == 0) {
                ++count;
                contextBindingBuilder.add("$LContextBuilder()", new Object[]{this.getEvaluationContextKind()});
            }
            contextBindingBuilder.add(".$1L($2S, $3L)", new Object[]{ParameterType.BODY.getAccessorName(), field.getValue(), JavaUtils.getParameterJavaName((String)NamingUtil.buildParameterInternalName((String)field.getName(), Collections.emptyList(), (ParameterType)ParameterType.BODY), (boolean)false)});
        }
        if (count == 0) {
            contextBindingBuilder.add("emptyContextBuilder()", new Object[]{this.getEvaluationContextKind()});
        }
        contextBindingBuilder.add(".build()", new Object[0]);
        methodBuilder.addStatement(contextBindingBuilder.build());
    }
}

