/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.connection;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.CustomAuthenticationScheme;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;

import java.nio.file.Path;

public class SdkCustomConnectionProvider extends AbstractSdkConnectionProvider {

  private final CustomAuthenticationScheme securityScheme;

  public SdkCustomConnectionProvider(Path outputDir,
                                     ConnectorModel connectorModel,
                                     CustomAuthenticationScheme securityScheme,
                                     RestSdkRunConfiguration runConfiguration) {
    super(outputDir, connectorModel, runConfiguration);

    this.securityScheme = securityScheme;
  }

  @Override
  public void applyTemplates() throws TemplatingException {}

  @Override
  public TypeName getTypeNameForConfig() {
    return ClassName.bestGuess(securityScheme.getFqn().get().trim());
  }
}
