/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication;

import org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode;

import com.mulesoft.connectivity.rest.commons.api.connection.oauth.BaseAuthorizationCodeConnectionProvider;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.OAuth2AuthorizationCodeScheme;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.TypeSpec;

public class SdkAuthorizationCodeAuthenticationStrategy extends SdkOAuthAuthenticationStrategy {

  public static final String ACCESS_TOKEN_URL = "accessTokenUrl";
  public static final String AUTHORIZATION_URL = "authorizationUrl";

  protected final OAuth2AuthorizationCodeScheme authorizationCode;

  protected SdkAuthorizationCodeAuthenticationStrategy(ConnectorSecurityScheme securityScheme) {
    super(securityScheme);

    authorizationCode = (OAuth2AuthorizationCodeScheme) securityScheme;
  }

  @Override
  public Class<?> getCommonsBaseClass() {
    return BaseAuthorizationCodeConnectionProvider.class;
  }

  @Override
  public void addClassAnnotations(TypeSpec.Builder connectionProviderClassBuilder) {
    AnnotationSpec oAuthAnnotation = AnnotationSpec
        .builder(AuthorizationCode.class)
        .addMember(ACCESS_TOKEN_URL, "$S", authorizationCode.getAccessTokenUri())
        .addMember(AUTHORIZATION_URL, "$S", authorizationCode.getAuthorizationUri())
        .addMember(DEFAULT_SCOPES, "$S", authorizationCode.getScopes())
        .build();

    connectionProviderClassBuilder.addAnnotation(oAuthAnnotation);
  }

  @Override
  public boolean shouldTestConnectivity() {
    return false;
  }
}
