/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.operation;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;

import java.nio.file.Path;
import java.util.List;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;

public class SdkNativeOperation extends AbstractSdkOperation {

  public SdkNativeOperation(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector,
                            ConnectorOperation operation, RestSdkRunConfiguration runConfiguration)
      throws TemplatingException {
    super(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
  }

  @Override
  public void applyTemplates() throws TemplatingException {
    // doNothing
  }

  @Override
  public String getJavaClassName() {
    return getClassName().simpleName();
  }

  private ClassName getClassName() {
    return ClassName.bestGuess(operation.getFqn().trim());
  }

  @Override
  public String getPackage() {
    return getClassName().packageName();
  }

  @Override
  public TypeName generateMethodReturn() {
    return null;
  }

  @Override
  public CodeBlock generateOperationMethodBody() throws TemplatingException {
    return null;
  }
}
