/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.operation;

import com.mulesoft.connectivity.rest.commons.api.error.RestError;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import org.mule.runtime.extension.api.exception.ModuleException;

public class SdkOperation extends AbstractSdkOperation {

  public SdkOperation(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation,
                      RestSdkRunConfiguration runConfiguration)
      throws TemplatingException {
    super(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
  }

  public TypeName generateMethodReturn() {
    return null;
  }

  public CodeBlock generateOperationMethodBody() {
    return generateOperationMethodBody("callback");
  }

  protected CodeBlock generateOperationMethodBody(String callbackParameterName) {
    CodeBlock.Builder methodBody = super.generateCommonOperationMethodBody();

    String parameterBindingsValue = "new $1T<$2T, $3T>()";
    if (operation.isAdapter()) {
      parameterBindingsValue = "parameterBindings";
    }

    if (!isVoidOperation() && (outputMetadataResolver != null || operationMethodRequiresBody())) {
      methodBody
          .addStatement("doRequest(config, connection, builder, overrides.getResponseTimeoutAsMillis(), streamingHelper,"
              + parameterBindingsValue + ","
              + " callbackObjectAttributesAdapter(" + callbackParameterName + "))", HashMap.class, String.class, Object.class);
    } else {
      methodBody
          .addStatement("doVoidRequest(connection, builder, overrides.getResponseTimeoutAsMillis(), streamingHelper,"
              + parameterBindingsValue + ","
              + " callbackObjectAttributesAdapter(" + callbackParameterName + "))", HashMap.class, String.class, Object.class);
    }

    if (!operation.hasPagination() && operation.isAdapter()) {
      super.generateTryStatement(methodBody, false);
      super.generateCatchStatement(ModuleException.class, "callback.error(e);", methodBody);
      super.generateCatchStatement(Throwable.class,
                                   "callback.error(new ModuleException(\"Unknown error\", $1T.CONNECTIVITY, e));",
                                   methodBody, RestError.CONNECTIVITY.getClass());
    }

    return methodBody.build();
  }

}
