/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.sampledata;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils.getJavaUpperCamelNameFromXml;
import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.getXmlName;
import static com.mulesoft.connectivity.rest.sdk.templating.sdk.sampledata.SdkSampleDataDefinition.SAMPLE_DATA_SUFFIX;

import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.BindingField;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata.SampleDataDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProviderReferenceParent;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;

public class SdkSampleDataReferenceParent extends AbstractSdkResolverProviderReferenceParent {

  private final SdkSampleDataDefinition sdkResolverDefinition;
  private final ResolverReference<SampleDataDefinition> resolverReference;
  private final List<SdkParameter> sdkParameters;

  public SdkSampleDataReferenceParent(Path outputDir,
                                      ConnectorModel connectorModel,
                                      ResolverReference<SampleDataDefinition> resolverReference,
                                      SdkSampleDataDefinition sdkResolverDefinition,
                                      List<SdkParameter> sdkParameters,
                                      RestSdkRunConfiguration runConfiguration) {
    super(outputDir, connectorModel, resolverReference, sdkResolverDefinition, runConfiguration);
    this.sdkResolverDefinition = sdkResolverDefinition;
    this.resolverReference = resolverReference;
    this.sdkParameters = sdkParameters;
  }

  @Override
  public String getPackage() {
    return connectorModel.getBasePackage() + ".internal.metadata.sample";
  }

  public String getJavaClassName() {
    return getJavaUpperCamelNameFromXml(getXmlName(resolverReference.getDeclaration().getName())) + SAMPLE_DATA_SUFFIX;
  }

  @Override
  protected List<SdkParameter> getAllParameters() {
    return sdkParameters;
  }

  @Override
  protected List<BindingField> getBindingFields() {
    return Collections.emptyList();
  }

  @Override
  protected String getEvaluationContextKind() {
    return null;
  }

  @Override
  protected TypeName getSuperClass() {
    return ClassName.get(sdkResolverDefinition.getSuperclass());
  }

  @Override
  protected boolean isBoundParameter(SdkParameter sdkParameter) {
    return false;
  }

}
