/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.util;

import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;

public class MuleAnnotationsUtils {

  public static AnnotationSpec generateTypeResolverAnnotation(String fqn) {
    ClassName clsName = getClassName(fqn);
    return getTypeResolverAnnotation(clsName);
  }

  public static AnnotationSpec generateMetadataKeyIdAnnotation(String fqn) {
    ClassName clsName = getClassName(fqn);
    return AnnotationSpec
        .builder(MetadataKeyId.class)
        .addMember("value", "$T.class", clsName)
        .build();
  }

  public static AnnotationSpec getTypeResolverAnnotation(ClassName className) {
    return AnnotationSpec
        .builder(TypeResolver.class)
        .addMember("value", "$T.class", className)
        .build();
  }

  public static ClassName getClassName(String fqn) {
    ClassName clsName;
    if (fqn.contains(".")) {
      int lasDot = fqn.lastIndexOf(".");
      String packageName = fqn.substring(0, lasDot);
      String className = fqn.substring(lasDot + 1);
      clsName = ClassName.get(packageName, className);
    } else {
      throw new IllegalArgumentException(
                                         String
                                             .format("The class [%s] is in the default package, it is a compile time error to import a type from the unnamed package for the class, please create a package for it",
                                                     fqn));
    }
    return clsName;
  }
}
