/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.util;

import static com.google.common.base.CaseFormat.UPPER_CAMEL;
import static javax.lang.model.element.Modifier.PUBLIC;

import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

import javax.lang.model.element.Modifier;

import com.google.common.base.CaseFormat;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;

public class SdkTemplatingUtils {

  public static final String VALUE_MEMBER = "value";

  public static AnnotationSpec getDisplayNameAnnotation(String displayName) {
    return AnnotationSpec
        .builder(DisplayName.class)
        .addMember(VALUE_MEMBER, "$S", displayName)
        .build();
  }

  public static AnnotationSpec getSummaryAnnotation(String summary) {
    return AnnotationSpec
        .builder(Summary.class)
        .addMember(VALUE_MEMBER, "$S", summary)
        .build();
  }

  public static MethodSpec.Builder generateGetter(FieldSpec fieldSpec, CaseFormat fieldNameCaseFormat) {
    return generateGetter(fieldSpec, fieldNameCaseFormat, PUBLIC);
  }

  public static MethodSpec.Builder generateGetter(FieldSpec fieldSpec, CaseFormat fieldNameCaseFormat, Modifier visibility) {
    String name = "get" + fieldNameCaseFormat.to(UPPER_CAMEL, fieldSpec.name);

    return MethodSpec
        .methodBuilder(name)
        .addModifiers(PUBLIC)
        .returns(fieldSpec.type)
        .addCode(CodeBlock.builder().addStatement("return this.$N", fieldSpec).build());
  }
}
