/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.configuration;

import com.mulesoft.connectivity.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.configuration.layers.SdkConfigBaseLayer;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.configuration.layers.SdkConfigImplementationLayer;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.configuration.layers.SdkConfigInterceptorLayer;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.nio.file.Path;

public class SdkConfig
extends JavaTemplateEntity {
    private final SdkConnector connector;
    private final String javaClassName;
    private final String packageName;
    private final SdkConfigBaseLayer baseLayer;
    private final SdkConfigInterceptorLayer interceptorLayer;
    private final SdkConfigImplementationLayer implementationLayer;

    public SdkConfig(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, runConfiguration);
        this.connector = sdkConnector;
        this.javaClassName = this.getJavaClassName();
        this.packageName = this.getPackage();
        this.baseLayer = new SdkConfigBaseLayer(outputDir, connectorModel, sdkConnector, this.javaClassName, this.packageName, (TypeName)ClassName.get(RestConfiguration.class), runConfiguration);
        this.interceptorLayer = new SdkConfigInterceptorLayer(outputDir, connectorModel, sdkConnector, this.javaClassName, this.packageName, this.baseLayer.getTypeName(), runConfiguration);
        this.implementationLayer = new SdkConfigImplementationLayer(outputDir, connectorModel, sdkConnector, this.javaClassName, this.packageName, this.interceptorLayer.getTypeName(), runConfiguration);
    }

    public String getJavaClassName() {
        String baseName = this.connector.getJavaName().endsWith("Connector") ? this.connector.getJavaName().substring(0, this.connector.getJavaName().length() - 9) : this.connector.getJavaName();
        return baseName + "Configuration";
    }

    public String getPackage() {
        return this.connectorModel.getBasePackage() + ".internal.config";
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.baseLayer.applyTemplates();
        this.interceptorLayer.applyTemplates();
        this.implementationLayer.applyTemplates();
    }

    public TypeName getTypeName() {
        return this.implementationLayer.getTypeName();
    }
}

