/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.configuration.layers;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.configuration.layers.AbstractSdkConfigLayer;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import javax.lang.model.element.Modifier;

public class SdkConfigInterceptorLayer
extends AbstractSdkConfigLayer {
    public static final String INTERCEPTOR_LAYER_JAVADOC = "This interceptor is the middle layer of the configuration generation gap pattern. It can be overridden to add custom logic in the configuration.";
    private final TypeName baseClass;

    public SdkConfigInterceptorLayer(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, String javaClassName, String packageName, TypeName baseClass, RestSdkRunConfiguration runConfiguration) {
        super(outputDir, connectorModel, sdkConnector, javaClassName, packageName, runConfiguration);
        this.baseClass = baseClass;
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.generateClass();
    }

    private void generateClass() throws TemplatingException {
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.ABSTRACT}).superclass(this.baseClass).addJavadoc(INTERCEPTOR_LAYER_JAVADOC, new Object[0]);
        this.writeClassToFile(classBuilder.build(), this.getPackage(), true);
    }

    @Override
    public String getJavaClassName() {
        return super.getJavaClassName() + "Interceptor";
    }

    @Override
    public String getPackage() {
        return super.getPackage() + ".interceptor";
    }
}

