/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.OAuth2Scheme;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication.SdkAuthorizationCodeAuthenticationStrategy;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication.SdkBaseAuthenticationStrategy;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication.SdkBasicAuthenticationStrategy;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication.SdkBearerAuthenticationStrategy;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication.SdkClientCredentialsAuthenticationStrategy;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication.SdkDigestAuthenticationStrategy;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeSpec;

public abstract class SdkAuthenticationStrategy {
    protected final ConnectorSecurityScheme securityScheme;

    public static SdkAuthenticationStrategy getStrategy(ConnectorSecurityScheme securityScheme) throws TemplatingException {
        ConnectorSecurityScheme.SecuritySchemeType securitySchemeType = securityScheme.getSchemeType();
        if (securitySchemeType.equals((Object)ConnectorSecurityScheme.SecuritySchemeType.BASIC)) {
            return new SdkBasicAuthenticationStrategy(securityScheme);
        }
        if (securitySchemeType.equals((Object)ConnectorSecurityScheme.SecuritySchemeType.DIGEST_AUTHENTICATION)) {
            return new SdkDigestAuthenticationStrategy(securityScheme);
        }
        if (securitySchemeType.equals((Object)ConnectorSecurityScheme.SecuritySchemeType.PASS_THROUGH)) {
            return new SdkBaseAuthenticationStrategy(securityScheme);
        }
        if (securitySchemeType.equals((Object)ConnectorSecurityScheme.SecuritySchemeType.UNSECURED)) {
            return new SdkBaseAuthenticationStrategy(securityScheme);
        }
        if (securitySchemeType.equals((Object)ConnectorSecurityScheme.SecuritySchemeType.OAUTH2)) {
            if (((OAuth2Scheme)securityScheme).getGrantType().equals((Object)OAuth2Scheme.GrantType.AUTHORIZATION_CODE)) {
                return new SdkAuthorizationCodeAuthenticationStrategy(securityScheme);
            }
            if (((OAuth2Scheme)securityScheme).getGrantType().equals((Object)OAuth2Scheme.GrantType.CLIENT_CREDENTIALS)) {
                return new SdkClientCredentialsAuthenticationStrategy(securityScheme);
            }
        } else if (securitySchemeType.equals((Object)ConnectorSecurityScheme.SecuritySchemeType.BEARER)) {
            return new SdkBearerAuthenticationStrategy(securityScheme);
        }
        throw new TemplatingException("No Strategy available for '" + securitySchemeType + "'");
    }

    protected SdkAuthenticationStrategy(ConnectorSecurityScheme securityScheme) {
        this.securityScheme = securityScheme;
    }

    public abstract Class<?> getCommonsBaseClass();

    public abstract void addClassAnnotations(TypeSpec.Builder var1);

    public abstract void addDefaultClassMembers(TypeSpec.Builder var1);

    public boolean shouldTestConnectivity() {
        return this.securityScheme.getTestConnectionConfig() != null;
    }

    public FieldSpec.Builder getParameterField(SdkParameter parameter) {
        return parameter.generateParameterField();
    }

    public boolean canOverrideCreateConnectionMethod() {
        return true;
    }
}

