/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.operation;

import com.mulesoft.connectivity.rest.commons.api.binding.HttpRequestBinding;
import com.mulesoft.connectivity.rest.commons.api.binding.HttpResponseBinding;
import com.mulesoft.connectivity.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.datasense.metadata.output.SdkHttpResponseAttributesMetadataResolver;
import com.mulesoft.connectivity.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.rest.commons.api.operation.EntityRequestParameters;
import com.mulesoft.connectivity.rest.commons.api.operation.NonEntityRequestParameters;
import com.mulesoft.connectivity.rest.commons.internal.RestConstants;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Body;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Field;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.DataWeaveExpressionParser;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.Pagination;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.PaginationType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.AuxiliarParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata.SampleDataDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata.SdkOutputMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata.SdkPagingMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.munit.SdkMtfOperationTest;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkAuxiliarParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkContent;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkField;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkPaginationParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProvider;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverUtil;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.sampledata.SdkSampleDataFactory;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.MuleAnnotationsUtils;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.SdkBodyLevelUtils;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Ignore;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.sdk.api.annotation.binding.Binding;
import org.mule.sdk.api.annotation.data.sample.SampleData;

public abstract class AbstractSdkOperation
extends JavaTemplateEntity {
    public static final String PARAM_DOC_NAME_DESCRIPTION = "@param $L $L\n";
    public static final String CONTENT_TYPE_HEADER_NAME = "content-type";
    public static final String ACCEPT_HEADER_NAME = "accept";
    public static final String ADD_URI_PARAM_METHOD_NAME = "addUriParam";
    public static final String ADD_QUERY_PARAM_METHOD_NAME = "addQueryParam";
    public static final String ADD_HEADER_METHOD_NAME = "addHeader";
    public static final String ADD_MULTIPLE_URI_PARAM_METHOD_NAME = "addUriParams";
    public static final String ADD_MULTIPLE_QUERY_PARAM_METHOD_NAME = "addQueryParams";
    public static final String ADD_MULTIPLE_HEADER_METHOD_NAME = "addHeaders";
    private static final String REQUEST_PARAMETERS_GROUP_NAME = "REQUEST_PARAMETERS_GROUP_NAME";
    private static final String CONNECTOR_OVERRIDES = "CONNECTOR_OVERRIDES";
    private static final String GET_REQUEST_BODY_DATA_TYPE_METHOD = "getRequestBodyMediaType";
    private static final String GET_RESPONSE_BODY_DATA_TYPE_METHOD = "getResponseBodyMediaType";
    private static final String QUERY_PARAM_FORMAT_FIELD = "QUERY_PARAM_FORMAT";
    public static final String OPERATION_PATH_FIELD = "OPERATION_PATH";
    public static final String INTERCEPTOR_METHOD_NAME = "doBeforeRequest";
    private static final String PARAMETER_BINDINGS_NAME = "parameterBindings";
    protected final ConnectorOperation operation;
    private final SdkConnector sdkConnector;
    protected final List<SdkParameter> allUriParameters;
    protected final List<SdkParameter> allQueryParameters;
    protected final List<SdkParameter> allHeaders;
    protected final List<SdkParameter> auxParameters;
    protected final List<SdkField> allBodyFields;
    protected final SdkContent content;
    private final Optional<String> muleOutputResolver;
    protected final SdkOutputMetadataResolver outputMetadataResolver;
    protected final AbstractSdkResolverProvider sampleDataProvider;
    private final SdkMtfOperationTest sdkMtfOperationTest;
    private static final String GET_REQUEST_BINDINGS_METHOD = "getRequestBindings";
    private static final String GET_RESPONSE_BINDINGS_METHOD = "getResponseBindings";
    private static final String PARAMETER_BINDING_LOCAL_VARIABLE = "bindings";
    private static final String ADD_URI_BINDING_METHOD = "addUriParamBinding";
    private static final String ADD_QUERY_BINDING_METHOD = "addQueryParamBinding";
    private static final String ADD_HEADER_BINDING_METHOD = "addHeaderBinding";
    private static final String ADD_BODY_BINDING_METHOD = "setBody";
    private static final String GET_REQUEST_BUILDER_WITH_BINDINGS_METHOD = "getRequestBuilderWithBindings";

    public abstract TypeName generateMethodReturn();

    public abstract CodeBlock generateOperationMethodBody() throws TemplatingException;

    public AbstractSdkOperation(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, runConfiguration);
        this.operation = operation;
        this.sdkConnector = sdkConnector;
        this.allUriParameters = this.buildSdkParameters(outputDir, connectorModel, sdkConnector, operation.getUriParameters(), false);
        this.allQueryParameters = this.buildSdkParameters(outputDir, connectorModel, sdkConnector, operation.getQueryParameters(), true);
        this.allHeaders = this.buildSdkParameters(outputDir, connectorModel, sdkConnector, operation.getHeaders(), false);
        this.auxParameters = new ArrayList<SdkParameter>();
        List parameters = operation.getParameters().orElse(null);
        if (parameters != null) {
            this.auxParameters.addAll(this.buildAuxSdkParameters(operation, parameters));
        }
        this.allBodyFields = this.buildSdkFields(outputDir, connectorModel, sdkConnector, operation.getBody());
        this.content = this.buildContent(outputDir, connectorModel, sdkConnector, operation);
        this.muleOutputResolver = Optional.ofNullable(StringUtils.trim((String)operation.getMuleOutputResolver()));
        this.outputMetadataResolver = this.muleOutputResolver.isPresent() ? null : this.buildOutputMetadataResolver(sdkConnector);
        this.sdkMtfOperationTest = new SdkMtfOperationTest(operation, outputDir);
        this.sampleDataProvider = this.buildSdkSampleDataProvider(operation);
    }

    private AbstractSdkResolverProvider buildSdkSampleDataProvider(ConnectorOperation operation) {
        return SdkSampleDataFactory.getSdkSampleDataResolver(operation, this.connectorModel, this.sdkConnector, this.getJavaClassName(), this.getAllParameters(), this.outputDir, this.runConfiguration);
    }

    private List<SdkField> buildSdkFields(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, Body body) {
        ArrayList<SdkField> list = new ArrayList<SdkField>();
        if (body == null) {
            return list;
        }
        for (Field field : body.getFields()) {
            list.add(new SdkField(outputDir, connectorModel, sdkConnector, field, this, this.runConfiguration));
        }
        return list;
    }

    private List<SdkParameter> buildSdkParameters(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, List<Parameter> connectorParameters, boolean checkPaginationParameters) {
        ArrayList<SdkParameter> list = new ArrayList<SdkParameter>();
        for (Parameter parameter : connectorParameters) {
            if (checkPaginationParameters && this.isQueryParamDefinedInPagination(parameter.getExternalName())) {
                Pagination pagination = this.getPagination();
                list.add(new SdkPaginationParameter(outputDir, connectorModel, sdkConnector, this.getJavaClassName(), parameter, this, this.runConfiguration, pagination));
                continue;
            }
            list.add(new SdkParameter(outputDir, connectorModel, sdkConnector, this.getJavaClassName(), parameter, this, this.runConfiguration));
        }
        return list;
    }

    private List<SdkParameter> buildAuxSdkParameters(ConnectorOperation operation, List<AuxiliarParameter> connectorAuxParameters) throws TemplatingException {
        ArrayList<SdkParameter> list = new ArrayList<SdkParameter>();
        if (connectorAuxParameters != null) {
            for (AuxiliarParameter parameter : connectorAuxParameters) {
                list.add(this.buildSdkParameter(parameter, operation));
            }
        }
        return list;
    }

    private SdkParameter buildSdkParameter(AuxiliarParameter auxiliarParameter, ConnectorOperation operation) throws TemplatingException {
        TypeDefinition typeDefinition = auxiliarParameter.getTypeDefinition();
        if (typeDefinition == null) {
            typeDefinition = this.getTypeDefinition(auxiliarParameter.getType());
        }
        Parameter parameter = new Parameter(auxiliarParameter.getDisplayName(), auxiliarParameter.getExternalName(), auxiliarParameter.getExternalName(), ParameterType.AUXILIAR, typeDefinition, auxiliarParameter.getMuleAlias(), auxiliarParameter.getDescription(), auxiliarParameter.isRequired() == null || auxiliarParameter.isRequired() != false, null, false, auxiliarParameter.getValueProvider(), auxiliarParameter.getMuleMetadataKeyId(), auxiliarParameter.getMuleTypeResolver(), auxiliarParameter.getFields());
        return new SdkAuxiliarParameter(this.outputDir, this.connectorModel, this.sdkConnector, operation, this.getJavaClassName(), parameter, this, this.runConfiguration);
    }

    private TypeDefinition getTypeDefinition(ParameterDataType parameterDataType) {
        PrimitiveTypeDefinition.PrimitiveType primitiveType;
        switch (parameterDataType) {
            case NUMBER: {
                primitiveType = PrimitiveTypeDefinition.PrimitiveType.NUMBER;
                break;
            }
            case INTEGER: {
                primitiveType = PrimitiveTypeDefinition.PrimitiveType.INTEGER;
                break;
            }
            case LONG: {
                primitiveType = PrimitiveTypeDefinition.PrimitiveType.LONG;
                break;
            }
            case STRING: {
                primitiveType = PrimitiveTypeDefinition.PrimitiveType.STRING;
                break;
            }
            case BOOLEAN: {
                primitiveType = PrimitiveTypeDefinition.PrimitiveType.BOOLEAN;
                break;
            }
            case LOCAL_DATE_TIME: {
                primitiveType = PrimitiveTypeDefinition.PrimitiveType.LOCAL_DATE_TIME;
                break;
            }
            case ZONED_DATE_TIME: {
                primitiveType = PrimitiveTypeDefinition.PrimitiveType.ZONED_DATE_TIME;
                break;
            }
            case BINARY: {
                primitiveType = PrimitiveTypeDefinition.PrimitiveType.BINARY;
                break;
            }
            default: {
                throw new IllegalArgumentException("Parameter type not suppoerted. This is a bug.");
            }
        }
        return TypeDefinition.simplePrimitiveType((PrimitiveTypeDefinition.PrimitiveType)primitiveType);
    }

    public ConnectorOperation getOperation() {
        return this.operation;
    }

    private SdkOutputMetadataResolver buildOutputMetadataResolver(SdkConnector sdkConnector) throws TemplatingException {
        if (this.operation.getOutputMetadata() == null) {
            return null;
        }
        if (this.operation.hasPagination()) {
            return new SdkPagingMetadataResolver(this.outputDir, this.connectorModel, sdkConnector, this.operation.getInternalName(), this.operation.getOutputMetadata(), this.runConfiguration);
        }
        return new SdkOutputMetadataResolver(this.outputDir, this.connectorModel, sdkConnector, this.operation.getInternalName(), this.operation.getOutputMetadata(), "", this.runConfiguration);
    }

    protected SdkContent buildContent(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation) throws TemplatingException {
        if (operation.isRequestBodyBound()) {
            return null;
        }
        return operation.getInputMetadata() != null ? new SdkContent(outputDir, connectorModel, sdkConnector, operation, this, this.runConfiguration) : null;
    }

    public String getJavaClassName() {
        return JavaUtils.getJavaUpperCamelNameFromXml((String)this.operation.getInternalName()) + "Operation";
    }

    public String getJavaBaseClassName() {
        return this.getJavaClassName() + "Base";
    }

    public String getJavaInterceptorClassName() {
        return this.getJavaClassName() + "Interceptor";
    }

    private String getJavaMethodName() {
        return JavaUtils.getJavaLowerCamelNameFromXml((String)this.operation.getInternalName());
    }

    public String getPackage() {
        return this.connectorModel.getBasePackage() + ".internal.operation";
    }

    public String getInterceptorPackage() {
        return this.getPackage() + ".interceptor";
    }

    public String getBasePackage() {
        return this.getPackage() + ".base";
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        if (this.content != null) {
            this.content.applyTemplates();
        }
        if (this.outputMetadataResolver != null) {
            this.outputMetadataResolver.applyTemplates();
        }
        for (SdkParameter sdkParameter : this.allUriParameters) {
            sdkParameter.applyTemplates();
        }
        for (SdkParameter sdkParameter : this.allQueryParameters) {
            sdkParameter.applyTemplates();
        }
        for (SdkParameter sdkParameter : this.allHeaders) {
            sdkParameter.applyTemplates();
        }
        for (SdkParameter sdkParameter : this.auxParameters) {
            sdkParameter.applyTemplates();
        }
        if (!this.runConfiguration.regenerateMode()) {
            this.sdkMtfOperationTest.applyTemplates();
        }
        if (this.sampleDataProvider != null) {
            this.sampleDataProvider.applyTemplates();
        }
        if (this.operation.isAdapter()) {
            this.generateOperationImplementationLayer();
            this.generateOperationInterceptorLayer();
            this.generateOperationBaseLayer();
        } else {
            this.generateOperationClass();
        }
    }

    private MethodSpec generateGetRequestBodyDataTypeMethod() {
        return this.generateGetBodyDataTypeMethod(GET_REQUEST_BODY_DATA_TYPE_METHOD, this.getRequestBodyMediaType());
    }

    private String getRequestBodyMediaType() {
        return this.getBodyMediaType(this.getOperation().getInputMetadata());
    }

    private MethodSpec generateGetResponseBodyDataTypeMethod() {
        return this.generateGetBodyDataTypeMethod(GET_RESPONSE_BODY_DATA_TYPE_METHOD, this.getResponseBodyMediaType());
    }

    private String getResponseBodyMediaType() {
        return this.getBodyMediaType(this.getOperation().getOutputMetadata());
    }

    private String getBodyMediaType(TypeDefinition typeDefinition) {
        String result = typeDefinition != null && typeDefinition.getMediaType() != null ? typeDefinition.getMediaType().toString() : "application/json".toString();
        return result;
    }

    private MethodSpec generateGetBodyDataTypeMethod(String name, String bodyMediaType) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(String.class).addAnnotation(Override.class);
        methodBuilder.addStatement("return \"$L\"", new Object[]{bodyMediaType});
        return methodBuilder.build();
    }

    protected void generateOperationClass() throws TemplatingException {
        TypeSpec.Builder operationClassBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(this.getSuperclass()).addMethod(this.generateOperationMethod());
        this.defineConstructors(operationClassBuilder);
        operationClassBuilder.addField(this.generateOperationPathField());
        operationClassBuilder.addField(this.generateQueryParamFormatField());
        this.configureClassBuilder(operationClassBuilder);
        JavaFile.Builder javaFileBuilder = JavaFile.builder((String)this.getPackage(), (TypeSpec)operationClassBuilder.build()).skipJavaLangImports(true).addStaticImport(RestConstants.class, new String[]{REQUEST_PARAMETERS_GROUP_NAME, CONNECTOR_OVERRIDES});
        this.configureJavaFileBuilder(javaFileBuilder);
        this.writeJavaFile(javaFileBuilder.build());
    }

    protected void generateOperationImplementationLayer() throws TemplatingException {
        TypeSpec.Builder operationClassBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ClassName.get((String)this.getInterceptorPackage(), (String)this.getJavaInterceptorClassName(), (String[])new String[0])).addJavadoc("Lower part of the Operation. It has the operation declaration with its annotations.", new Object[0]).addMethod(this.generateOperationImplementationMethod());
        this.defineConstructors(operationClassBuilder);
        this.configureClassBuilder(operationClassBuilder);
        JavaFile.Builder javaFileBuilder = JavaFile.builder((String)this.getPackage(), (TypeSpec)operationClassBuilder.build()).skipJavaLangImports(true).addStaticImport(RestConstants.class, new String[]{REQUEST_PARAMETERS_GROUP_NAME, CONNECTOR_OVERRIDES});
        this.configureJavaFileBuilder(javaFileBuilder);
        this.writeJavaFile(javaFileBuilder.build());
    }

    protected void generateOperationInterceptorLayer() throws TemplatingException {
        TypeSpec.Builder operationClassBuilder = TypeSpec.classBuilder((String)this.getJavaInterceptorClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ClassName.get((String)this.getBasePackage(), (String)this.getJavaBaseClassName(), (String[])new String[0])).addJavadoc("Middle part of the Operation. Can be used by the user to add custom code into the operation.", new Object[0]).addMethod(this.generateOperationInterceptorMethod());
        this.defineConstructors(operationClassBuilder);
        this.configureClassBuilder(operationClassBuilder);
        JavaFile.Builder javaFileBuilder = JavaFile.builder((String)this.getInterceptorPackage(), (TypeSpec)operationClassBuilder.build()).skipJavaLangImports(true);
        this.configureJavaFileBuilder(javaFileBuilder);
        this.writeJavaFile(javaFileBuilder.build(), true);
    }

    protected void generateOperationBaseLayer() throws TemplatingException {
        MethodSpec operationMethod = this.generateOperationBaseMethod();
        TypeSpec.Builder operationClassBuilder = TypeSpec.classBuilder((String)this.getJavaBaseClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.ABSTRACT}).superclass(this.getSuperclass()).addJavadoc("Higher part of the Operation. It has the implementation of the operation.", new Object[0]).addMethod(operationMethod);
        this.defineConstructors(operationClassBuilder);
        operationClassBuilder.addField(this.generateOperationPathField());
        operationClassBuilder.addField(this.generateQueryParamFormatField());
        operationClassBuilder.addMethod(this.generateDoBeforeRequestMethod());
        operationClassBuilder.addMethod(this.generateGetRequestBodyDataTypeMethod());
        operationClassBuilder.addMethod(this.generateGetResponseBodyDataTypeMethod());
        operationClassBuilder.addMethod(this.generateRequestBindingsMethod());
        operationClassBuilder.addMethod(this.generateResponseBindingsMethod());
        this.configureClassBuilder(operationClassBuilder);
        JavaFile.Builder javaFileBuilder = JavaFile.builder((String)this.getBasePackage(), (TypeSpec)operationClassBuilder.build()).skipJavaLangImports(true);
        this.configureJavaFileBuilder(javaFileBuilder);
        this.writeJavaFile(javaFileBuilder.build());
    }

    private void defineConstructors(TypeSpec.Builder operationClassBuilder) {
        Arrays.stream(this.getSuperclass().getDeclaredConstructors()).forEach(constructor -> {
            MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
            StringBuilder methodStatement = new StringBuilder("super(");
            for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
                Class<?> parameterType = constructor.getParameterTypes()[i];
                String name = "arg" + i;
                constructorBuilder.addParameter(parameterType, name, new Modifier[0]);
                if (i > 0) {
                    methodStatement.append(", ");
                }
                methodStatement.append(name);
            }
            methodStatement.append(")");
            constructorBuilder.addStatement(methodStatement.toString(), new Object[0]);
            operationClassBuilder.addMethod(constructorBuilder.build());
        });
    }

    protected void configureJavaFileBuilder(JavaFile.Builder javaFileBuilder) {
    }

    protected void configureClassBuilder(TypeSpec.Builder operationClassBuilder) {
    }

    protected Class<? extends BaseRestOperation> getSuperclass() {
        return BaseRestOperation.class;
    }

    private FieldSpec generateQueryParamFormatField() {
        return FieldSpec.builder(RestRequestBuilder.QueryParamFormat.class, (String)QUERY_PARAM_FORMAT_FIELD, (Modifier[])new Modifier[]{this.operation.isAdapter() ? Modifier.PROTECTED : Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("$T.$L", new Object[]{RestRequestBuilder.QueryParamFormat.class, this.operation.getQueryParamArrayFormat().name()}).build();
    }

    private FieldSpec generateOperationPathField() {
        return FieldSpec.builder(String.class, (String)OPERATION_PATH_FIELD, (Modifier[])new Modifier[]{this.operation.isAdapter() ? Modifier.PROTECTED : Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{this.operation.getPath()}).build();
    }

    private AnnotationSpec generateDescriptionAnnotation() {
        return AnnotationSpec.builder(Summary.class).addMember("value", "$S", new Object[]{JavaUtils.abbreviateText((String)this.operation.getDescription())}).build();
    }

    public MethodSpec generateOperationMethod() throws TemplatingException {
        CodeBlock.Builder javaDoc = this.generateJavadoc();
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)this.getJavaMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.addParameters(methodBuilder, javaDoc, true, true, true);
        this.addAnnotations(methodBuilder);
        methodBuilder.addCode(this.generateOperationMethodBody());
        methodBuilder.addJavadoc(javaDoc.build());
        TypeName returnType = this.generateMethodReturn();
        if (returnType != null) {
            methodBuilder.returns(returnType);
        }
        return methodBuilder.build();
    }

    private CodeBlock.Builder generateJavadoc() {
        return CodeBlock.builder().add("\n$L\n", new Object[]{StringUtils.defaultIfEmpty((CharSequence)this.operation.getDescription(), (CharSequence)this.operation.getDisplayName())}).add("\nThis operation makes an HTTP $L request to the $L endpoint", new Object[]{this.operation.getHttpMethod().name().toUpperCase(), this.operation.getPath()}).add("\n", new Object[0]);
    }

    private void addAnnotations(MethodSpec.Builder methodBuilder) {
        methodBuilder.addAnnotation(this.generateThrowsAnnotation());
        methodBuilder.addAnnotation(this.generateDisplayNameAnnotation());
        if (this.operation.isSidecar()) {
            methodBuilder.addAnnotation(this.generateSidecarAnnotation());
        }
        if (StringUtils.isNotBlank((CharSequence)this.operation.getDescription())) {
            methodBuilder.addAnnotation(this.generateDescriptionAnnotation());
        }
        if (StringUtils.isNotBlank((CharSequence)this.operation.getAlias())) {
            methodBuilder.addAnnotation(this.generateAliasAnnotation());
        }
        if (this.sampleDataProvider != null) {
            methodBuilder.addAnnotation(this.generateSampleDataAnnotation());
        }
        if (this.requiresMediaTypeAnnotation()) {
            if (this.operation.getOutputMetadata() != null) {
                methodBuilder.addAnnotation(this.generateMediaTypeAnnotation());
            } else {
                methodBuilder.addAnnotation(this.generateDefaultMediaTypeAnnotation());
            }
        }
        methodBuilder.addAnnotation(this.getOutputResolverAnnotation());
    }

    public MethodSpec generateOperationImplementationMethod() throws TemplatingException {
        CodeBlock.Builder javaDoc = this.generateJavadoc();
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)this.getJavaMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.addParameters(methodBuilder, javaDoc, true, true, true);
        this.addAnnotations(methodBuilder);
        TypeName returnType = this.generateMethodReturn();
        methodBuilder.addCode(this.generateOperationImplementationMethodBody(methodBuilder.parameters, returnType));
        methodBuilder.addJavadoc(javaDoc.build());
        if (returnType != null) {
            methodBuilder.returns(returnType);
        }
        return methodBuilder.build();
    }

    public MethodSpec generateOperationBaseMethod() throws TemplatingException {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)this.getJavaMethodName()).addModifiers(new Modifier[]{Modifier.PROTECTED});
        this.addParameters(methodBuilder, CodeBlock.builder(), false, true, true);
        methodBuilder.addCode(this.generateOperationMethodBody());
        TypeName returnType = this.generateMethodReturn();
        if (returnType != null) {
            methodBuilder.returns(returnType);
        }
        return methodBuilder.build();
    }

    public MethodSpec generateOperationInterceptorMethod() throws TemplatingException {
        CodeBlock.Builder javaDoc = CodeBlock.builder().add("Method given to add custom code to be run before the HTTP request", new Object[0]).add("\n", new Object[0]);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)INTERCEPTOR_METHOD_NAME).addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class);
        this.addParameters(methodBuilder, javaDoc, false, false, false);
        methodBuilder.addException(ModuleException.class);
        methodBuilder.addCode(this.generateOperationInterceptorMethodBody());
        methodBuilder.addJavadoc(javaDoc.build());
        return methodBuilder.build();
    }

    protected void addContentParameters(CodeBlock.Builder javaDoc, boolean withAnnotations, List<ParameterSpec> parameterSpecs) {
        if (this.content != null) {
            ParameterSpec parameterSpec = this.content.generateContentParameter(withAnnotations);
            javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameterSpec.name, "the content to use"});
            parameterSpecs.add(parameterSpec);
        }
    }

    private void addConfigurationParameters(List<ParameterSpec> parameterSpecs, CodeBlock.Builder javaDoc, boolean withAnnotations) {
        ParameterSpec configParameter = this.generateConfigParameter(withAnnotations);
        javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{configParameter.name, "the configuration to use"});
        parameterSpecs.add(configParameter);
    }

    private void addConnectionParameters(List<ParameterSpec> parameterSpecs, CodeBlock.Builder javaDoc, boolean withAnnotations) {
        if (this.requiresConnectionParameter()) {
            ParameterSpec connectionParameter = this.generateConnectionParameter(withAnnotations);
            javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{connectionParameter.name, "the connection to use"});
            parameterSpecs.add(connectionParameter);
        }
    }

    private void addHttpParameters(List<ParameterSpec> parameterSpecs, CodeBlock.Builder javaDoc, boolean withAnnotations) {
        ParameterSpec parameterSpec;
        for (SdkParameter sdkParam : this.allUriParameters) {
            ParameterSpec parameterSpec2 = sdkParam.generateParameterParameter(withAnnotations).build();
            javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameterSpec2.name, StringUtils.defaultIfEmpty((CharSequence)sdkParam.getDescription(), (CharSequence)sdkParam.getDisplayName())});
            parameterSpecs.add(parameterSpec2);
        }
        List<SdkParameter> filteredQueryParameters = this.allQueryParameters;
        if (this.isEndpointMarkerPagination()) {
            filteredQueryParameters = this.allQueryParameters.stream().filter(param -> !this.isQueryParamDefinedInMarkerPagination(param.getExternalName())).collect(Collectors.toList());
        }
        for (SdkParameter sdkParam : filteredQueryParameters) {
            parameterSpec = sdkParam.generateParameterParameter(withAnnotations).build();
            javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameterSpec.name, StringUtils.defaultIfEmpty((CharSequence)sdkParam.getDescription(), (CharSequence)sdkParam.getDisplayName())});
            parameterSpecs.add(parameterSpec);
        }
        for (SdkParameter sdkParam : this.allHeaders) {
            parameterSpec = sdkParam.generateParameterParameter(withAnnotations).build();
            javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameterSpec.name, StringUtils.defaultIfEmpty((CharSequence)sdkParam.getDescription(), (CharSequence)sdkParam.getDisplayName())});
            parameterSpecs.add(parameterSpec);
        }
    }

    private void addAuxiliaryParameters(List<ParameterSpec> parameterSpecs, CodeBlock.Builder javaDoc, boolean withAnnotations) {
        for (SdkParameter sdkParam : this.auxParameters) {
            ParameterSpec parameterSpec = sdkParam.generateParameterParameter(withAnnotations).build();
            javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameterSpec.name, StringUtils.defaultIfEmpty((CharSequence)sdkParam.getDescription(), (CharSequence)sdkParam.getDisplayName())});
            parameterSpecs.add(parameterSpec);
        }
    }

    private void addParameterBindings(List<ParameterSpec> parameterSpecs, CodeBlock.Builder javaDoc, boolean withAnnotations) {
        ParameterSpec.Builder parameterBindingsSpec = ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{TypeName.get(String.class), TypeName.get(Object.class)}), (String)PARAMETER_BINDINGS_NAME, (Modifier[])new Modifier[0]);
        ParameterSpec parameterSpec = parameterBindingsSpec.build();
        javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameterSpec.name, "Map that contains auxiliary parameters defined in operation"});
        parameterSpecs.add(parameterSpec);
    }

    private void addRequestParameters(List<ParameterSpec> parameterSpecs, CodeBlock.Builder javaDoc, boolean withAnnotations) {
        ParameterSpec parameterSpec = this.generateRequestParametersParameter(withAnnotations);
        javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameterSpec.name, "the {@link " + ((ClassName)parameterSpec.type).simpleName() + "}"});
        parameterSpecs.add(parameterSpec);
    }

    private void addConfigurationOverridesParameters(List<ParameterSpec> parameterSpecs, CodeBlock.Builder javaDoc, boolean withAnnotations) {
        ParameterSpec configurationOverridesParameter = this.generateConfigurationOverridesParameter(withAnnotations);
        javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{configurationOverridesParameter.name, "the {@link ConfigurationOverrides}"});
        parameterSpecs.add(configurationOverridesParameter);
    }

    private void addStreamingHelperParameters(List<ParameterSpec> parameterSpecs, CodeBlock.Builder javaDoc, boolean withAnnotations) {
        ParameterSpec streamingHelperParameter = this.generateStreamingHelperParameter();
        javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{streamingHelperParameter.name, "the {@link StreamingHelper}"});
        parameterSpecs.add(streamingHelperParameter);
    }

    private void addCallbackParameters(List<ParameterSpec> parameterSpecs, CodeBlock.Builder javaDoc, boolean withAnnotations) {
        if (this.requiresCallbackParameter()) {
            ParameterSpec completionCallbackParameter = this.generateCompletionCallbackParameter();
            javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{completionCallbackParameter.name, "the operation's {@link CompletionCallback}"});
            parameterSpecs.add(completionCallbackParameter);
        }
    }

    private void addParameters(MethodSpec.Builder methodBuilder, CodeBlock.Builder javaDoc, boolean withAnnotations, boolean withAuxiliary, boolean withCallback) {
        Pair<List<ParameterSpec>, CodeBlock.Builder> params = this.getParametersSpecAndJavaDoc(withAnnotations, withAuxiliary, withCallback);
        javaDoc.add(((CodeBlock.Builder)params.getRight()).build());
        ((List)params.getLeft()).forEach(arg_0 -> ((MethodSpec.Builder)methodBuilder).addParameter(arg_0));
    }

    private Pair<List<ParameterSpec>, CodeBlock.Builder> getParametersSpecAndJavaDoc(boolean withAnnotations, boolean withAuxiliary, boolean withCallback) {
        CodeBlock.Builder javaDoc = CodeBlock.builder();
        ArrayList<ParameterSpec> parameterSpecs = new ArrayList<ParameterSpec>();
        this.addConfigurationParameters(parameterSpecs, javaDoc, withAnnotations);
        this.addConnectionParameters(parameterSpecs, javaDoc, withAnnotations);
        this.addHttpParameters(parameterSpecs, javaDoc, withAnnotations);
        if (withAuxiliary) {
            this.addAuxiliaryParameters(parameterSpecs, javaDoc, withAnnotations);
        } else {
            this.addParameterBindings(parameterSpecs, javaDoc, withAnnotations);
        }
        this.addContentParameters(javaDoc, withAnnotations, parameterSpecs);
        this.addRequestParameters(parameterSpecs, javaDoc, withAnnotations);
        this.addConfigurationOverridesParameters(parameterSpecs, javaDoc, withAnnotations);
        this.addStreamingHelperParameters(parameterSpecs, javaDoc, withAnnotations);
        if (withCallback) {
            this.addCallbackParameters(parameterSpecs, javaDoc, withAnnotations);
        }
        ImmutablePair returned = new ImmutablePair(parameterSpecs, (Object)javaDoc);
        return returned;
    }

    private AnnotationSpec getOutputResolverAnnotation() {
        AnnotationSpec.Builder builder = AnnotationSpec.builder(OutputResolver.class);
        if (this.outputMetadataResolver != null && this.outputMetadataResolver.getRequiresMetadataResolver()) {
            builder.addMember("output", "$T.class", new Object[]{ClassName.get((String)this.outputMetadataResolver.getPackage(), (String)this.outputMetadataResolver.getClassName(), (String[])new String[0])});
        } else if (this.muleOutputResolver.isPresent()) {
            ClassName className = MuleAnnotationsUtils.getClassName(this.muleOutputResolver.get());
            builder.addMember("output", "$T.class", new Object[]{className});
        }
        return builder.addMember("attributes", "$T.class", new Object[]{ClassName.get(SdkHttpResponseAttributesMetadataResolver.class)}).build();
    }

    private Pagination getPagination() {
        return this.operation.getPagination();
    }

    private boolean isQueryParamDefinedInPagination(String paramName) {
        Pagination pagination = this.getPagination();
        if (pagination != null && pagination.getPaginationParameter() != null) {
            return pagination.getPaginationParameter().equalsIgnoreCase(paramName);
        }
        return false;
    }

    private boolean isQueryParamDefinedInMarkerPagination(String paramName) {
        return this.getPagination().getPaginationParameter().equals(paramName);
    }

    private boolean isEndpointMarkerPagination() {
        Pagination pagination = this.getPagination();
        return pagination != null && pagination.getType().equals((Object)PaginationType.MARKER);
    }

    private AnnotationSpec generateDisplayNameAnnotation() {
        return AnnotationSpec.builder(DisplayName.class).addMember("value", "$S", new Object[]{this.operation.getDisplayName()}).build();
    }

    private AnnotationSpec generateAliasAnnotation() {
        return AnnotationSpec.builder(Alias.class).addMember("value", "$S", new Object[]{this.operation.getAlias()}).build();
    }

    private AnnotationSpec generateSidecarAnnotation() {
        return AnnotationSpec.builder(Ignore.class).build();
    }

    public CodeBlock.Builder generateCommonOperationMethodBody() {
        CodeBlock.Builder builder = CodeBlock.builder();
        this.generateCommonOperationMethodBody(builder);
        return builder;
    }

    public CodeBlock generateOperationImplementationMethodBody(List<ParameterSpec> parameters, TypeName typeName) throws TemplatingException {
        CodeBlock.Builder builder = CodeBlock.builder();
        String returnSentence = "";
        if (typeName != null) {
            returnSentence = "return";
        }
        builder.addStatement("$L super.$L($L)", new Object[]{returnSentence, this.getJavaMethodName(), parameters.stream().map(param -> param.name).collect(Collectors.joining(", "))});
        return builder.build();
    }

    public CodeBlock generateOperationInterceptorMethodBody() throws TemplatingException {
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.add("// Add custom code", new Object[0]);
        return builder.build();
    }

    protected void generateTryStatement(CodeBlock.Builder methodBody, boolean start) {
        if (start) {
            methodBody.add("try {", new Object[0]);
        } else {
            methodBody.add("}", new Object[0]);
        }
    }

    protected void generateCatchStatement(Class exception, String codeBlock, CodeBlock.Builder methodBody, Object ... args) {
        methodBody.add("$1L ($2T e) {", new Object[]{"catch", exception});
        methodBody.add(codeBlock, args);
        methodBody.add("}", new Object[0]);
    }

    public void generateCommonOperationMethodBody(CodeBlock.Builder methodBody) {
        String baseUriString = "connection.getBaseUri()";
        if (StringUtils.isNotBlank((CharSequence)this.operation.getAlternativeBaseUri()) && this.connectorModel.getBaseUri().isMultipleBaseUri()) {
            String multipleBaseUri = this.connectorModel.getBaseUri().getMultipleBaseUriOrDefault(this.operation.getAlternativeBaseUri());
            baseUriString = "\"" + multipleBaseUri + "\"";
        }
        if (this.operation.isAdapter()) {
            methodBody.add(this.generateAuxParameterBindings());
            if (!this.operation.hasPagination()) {
                this.generateTryStatement(methodBody, true);
            }
            methodBody.add(this.generateInterceptorCall());
        }
        this.generateRestRequestBuilderInitialization(methodBody, baseUriString);
        methodBody.add(".setQueryParamFormat($L)", new Object[]{QUERY_PARAM_FORMAT_FIELD});
        if (this.connectorModel.getInterceptors() != null && this.connectorModel.getInterceptors().size() > 0) {
            methodBody.add(".$L($L($L))", new Object[]{"responseInterceptor", "getResponseInterceptors", "config"});
        }
        if (this.operation.getInputMetadata() != null && this.operation.getInputMetadata().getMediaType() != null) {
            String mediaType = this.operation.getInputMetadata().getMediaType().toString();
            if (this.operation.getInputMetadata().getMediaType().equals((Object)javax.ws.rs.core.MediaType.MULTIPART_FORM_DATA_TYPE)) {
                mediaType = mediaType + "; boundary=__rc2_34b212";
            }
            methodBody.add(".$L($S, $S)", new Object[]{ADD_HEADER_METHOD_NAME, CONTENT_TYPE_HEADER_NAME, mediaType});
        }
        if (this.operation.getOutputMetadata() != null && this.operation.getOutputMetadata().getMediaType() != null) {
            methodBody.add(".$L($S, $S)", new Object[]{ADD_HEADER_METHOD_NAME, ACCEPT_HEADER_NAME, this.operation.getOutputMetadata().getMediaType().toString()});
        }
        for (SdkParameter uriParameter : this.allUriParameters) {
            methodBody.add(this.generateRequestBuilderParameterCodeBlock(uriParameter, ADD_URI_PARAM_METHOD_NAME, ADD_MULTIPLE_URI_PARAM_METHOD_NAME));
        }
        for (SdkParameter queryParam : this.allQueryParameters) {
            if (this.isQueryParamDefinedInPagination(queryParam.getExternalName())) continue;
            methodBody.add(this.generateRequestBuilderParameterCodeBlock(queryParam, ADD_QUERY_PARAM_METHOD_NAME, ADD_MULTIPLE_QUERY_PARAM_METHOD_NAME));
        }
        for (SdkParameter header : this.allHeaders) {
            methodBody.add(this.generateRequestBuilderParameterCodeBlock(header, ADD_HEADER_METHOD_NAME, ADD_MULTIPLE_HEADER_METHOD_NAME));
        }
        this.addSetBodyMethod(methodBody);
        methodBody.add(";", new Object[0]);
    }

    public CodeBlock generateInterceptorCall() {
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.addStatement("$L($L)", new Object[]{INTERCEPTOR_METHOD_NAME, ((List)this.getParametersSpecAndJavaDoc(false, false, false).getLeft()).stream().map(param -> param.name).collect(Collectors.joining(", "))});
        return builder.build();
    }

    protected void generateRestRequestBuilderInitialization(CodeBlock.Builder methodBody, String baseUriString) {
        if (this.operation.isAdapter()) {
            methodBody.add("$T builder = $L($L, $L, $T.$L, parameters, overrides, connection, config, parameterBindings)", new Object[]{RestRequestBuilder.class, GET_REQUEST_BUILDER_WITH_BINDINGS_METHOD, baseUriString, OPERATION_PATH_FIELD, HttpConstants.Method.class, this.operation.getHttpMethod().name().toUpperCase()});
        } else {
            methodBody.add("$1T builder = new $1T($2L, $3L, $4T.$5L, parameters)", new Object[]{RestRequestBuilder.class, baseUriString, OPERATION_PATH_FIELD, HttpConstants.Method.class, this.operation.getHttpMethod().name().toUpperCase()});
        }
    }

    protected void addSetBodyMethod(CodeBlock.Builder methodBody) {
        if (this.content != null) {
            methodBody.add(".setBody($L, overrides.getStreamingType())", new Object[]{this.content.getContentParameterJavaName()});
        }
    }

    private CodeBlock generateRequestBuilderParameterCodeBlock(SdkParameter parameter, String addSingleValueMethodName, String addMultipleValueMethodName) {
        CodeBlock.Builder builder = CodeBlock.builder();
        String methodName = parameter.isArrayType() ? addMultipleValueMethodName : addSingleValueMethodName;
        builder.add(".$L($S, $L)", new Object[]{methodName, parameter.getExternalName(), this.getParameterValueStatement(parameter)});
        return builder.build();
    }

    private CodeBlock getParameterValueStatement(SdkParameter parameter) {
        CodeBlock.Builder builder = CodeBlock.builder();
        if (parameter.isArrayType()) {
            CodeBlock getter = parameter.getInnerTypeStringValueGetter("v");
            if (getter.toString().equalsIgnoreCase("v")) {
                builder.add("$L.stream().filter($T::nonNull).collect($T.toList())", new Object[]{parameter.getJavaName(), Objects.class, Collectors.class});
            } else {
                builder.add("$L.stream().filter($T::nonNull).map(v -> $L).collect($T.toList())", new Object[]{parameter.getJavaName(), Objects.class, getter, Collectors.class});
            }
        } else {
            builder.add("$L", new Object[]{parameter.getStringValueGetter()});
        }
        return builder.build();
    }

    private AnnotationSpec generateThrowsAnnotation() {
        return AnnotationSpec.builder(Throws.class).addMember("value", "$T.class", new Object[]{RequestErrorTypeProvider.class}).build();
    }

    private AnnotationSpec generateMediaTypeAnnotation() {
        return AnnotationSpec.builder(MediaType.class).addMember("value", "$S", new Object[]{this.operation.getOutputMetadata().getMediaType()}).build();
    }

    private AnnotationSpec generateSampleDataAnnotation() {
        SampleDataDefinition sampleDataDefinition;
        HttpRequestDataExpression result;
        AnnotationSpec.Builder annotationBuilder = AnnotationSpec.builder(SampleData.class).addMember("value", "$T.class", new Object[]{ClassName.get((String)this.sampleDataProvider.getPackage(), (String)this.sampleDataProvider.getJavaClassName(), (String[])new String[0])});
        if (this.operation.getSampleData() instanceof ResolverReference) {
            ResolverReference sampleDataDefinitionReferenceResolver = (ResolverReference)this.operation.getSampleData();
            this.addBindingAnnotation(annotationBuilder, sampleDataDefinitionReferenceResolver.getArguments());
        } else if (this.operation.getSampleData() instanceof SampleDataDefinition && (result = (sampleDataDefinition = (SampleDataDefinition)this.operation.getSampleData()).getResult()).getHttpRequestBinding() != null) {
            List<Argument> arguments = Stream.of(result.getHttpRequestBinding().getHeader(), result.getHttpRequestBinding().getQueryParameter(), result.getHttpRequestBinding().getUriParameter()).flatMap(argumentList -> argumentList.stream()).collect(Collectors.toList());
            this.addBindingAnnotation(annotationBuilder, arguments);
        }
        return annotationBuilder.build();
    }

    private void addBindingAnnotation(AnnotationSpec.Builder annotationBuilder, List<Argument> arguments) {
        for (Argument argument : arguments) {
            if (!DataWeaveExpressionParser.isBodyBindingUsed((Argument)argument)) continue;
            annotationBuilder.addMember(PARAMETER_BINDING_LOCAL_VARIABLE, "$L", new Object[]{AnnotationSpec.builder(Binding.class).addMember("actingParameter", "$S", new Object[]{SdkResolverUtil.getActingParameterJavaName(argument)}).addMember("extractionExpression", "$S", new Object[]{SdkBodyLevelUtils.transformBodyPrefix(argument.getValue().getValue(), this.content.getContentParameterJavaName())}).build()});
        }
    }

    private AnnotationSpec generateDefaultMediaTypeAnnotation() {
        return AnnotationSpec.builder(MediaType.class).addMember("value", "$S", new Object[]{this.operationMethodRequiresBody() ? "application/json" : "text/plain"}).build();
    }

    private ParameterSpec generateConfigParameter(boolean withAnnotations) {
        ParameterSpec.Builder parameterSpecBuilder = ParameterSpec.builder(RestConfiguration.class, (String)"config", (Modifier[])new Modifier[0]);
        if (withAnnotations) {
            parameterSpecBuilder.addAnnotation(Config.class);
        }
        return parameterSpecBuilder.build();
    }

    private ParameterSpec generateConnectionParameter(boolean withAnnotations) {
        ParameterSpec.Builder parameterSpecBuilder = ParameterSpec.builder(RestConnection.class, (String)"connection", (Modifier[])new Modifier[0]);
        if (withAnnotations) {
            parameterSpecBuilder.addAnnotation(Connection.class);
        }
        return parameterSpecBuilder.build();
    }

    private ParameterSpec generateRequestParametersParameter(boolean withAnnotations) {
        Class requestParameterClass = this.operation.isRequestBodyBound() && this.operation.getInputMetadata() != null ? NonEntityRequestParameters.class : (this.operation.getInputMetadata() != null ? EntityRequestParameters.class : NonEntityRequestParameters.class);
        ParameterSpec.Builder parameterSpecBuilder = ParameterSpec.builder(requestParameterClass, (String)"parameters", (Modifier[])new Modifier[0]);
        if (withAnnotations) {
            AnnotationSpec parameterGroupAnnotation = AnnotationSpec.builder(ParameterGroup.class).addMember("name", REQUEST_PARAMETERS_GROUP_NAME, new Object[0]).build();
            parameterSpecBuilder.addAnnotation(parameterGroupAnnotation);
        }
        return parameterSpecBuilder.build();
    }

    private ParameterSpec generateConfigurationOverridesParameter(boolean withAnnotations) {
        ParameterSpec.Builder parameterSpecBuilder = ParameterSpec.builder(ConfigurationOverrides.class, (String)"overrides", (Modifier[])new Modifier[0]);
        if (withAnnotations) {
            AnnotationSpec parameterGroupAnnotation = AnnotationSpec.builder(ParameterGroup.class).addMember("name", CONNECTOR_OVERRIDES, new Object[0]).build();
            parameterSpecBuilder.addAnnotation(parameterGroupAnnotation);
        }
        return parameterSpecBuilder.build();
    }

    private ParameterSpec generateStreamingHelperParameter() {
        return ParameterSpec.builder(StreamingHelper.class, (String)"streamingHelper", (Modifier[])new Modifier[0]).build();
    }

    private ParameterSpec generateCompletionCallbackParameter() {
        MessageOutputType messageOutputType = this.getMessageOutputType();
        return ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(CompletionCallback.class), (TypeName[])new TypeName[]{messageOutputType.getOutputType(), messageOutputType.getAttributeOutputType()}), (String)"callback", (Modifier[])new Modifier[0]).build();
    }

    protected MessageOutputType getMessageOutputType() {
        if (!this.isVoidOperation() && (this.outputMetadataResolver != null || this.operationMethodRequiresBody())) {
            return new MessageOutputType(InputStream.class, Object.class);
        }
        return new MessageOutputType(String.class, Object.class);
    }

    protected boolean operationMethodRequiresBody() {
        return this.operation.getHttpMethod().equals((Object)HTTPMethod.GET) || this.operation.getHttpMethod().equals((Object)HTTPMethod.POST) || this.operation.getHttpMethod().equals((Object)HTTPMethod.PATCH) || this.operation.getHttpMethod().equals((Object)HTTPMethod.OPTIONS);
    }

    protected boolean isVoidOperation() {
        return this.operation.getVoidOperation() != null && this.operation.getVoidOperation() != false;
    }

    protected boolean requiresConnectionParameter() {
        return true;
    }

    protected boolean requiresCallbackParameter() {
        return true;
    }

    protected boolean requiresMediaTypeAnnotation() {
        return true;
    }

    public List<SdkParameter> getAllParameters() {
        ArrayList<SdkParameter> allParameters = new ArrayList<SdkParameter>();
        allParameters.addAll(this.allUriParameters);
        allParameters.addAll(this.allQueryParameters);
        allParameters.addAll(this.allHeaders);
        allParameters.addAll(this.auxParameters);
        return allParameters;
    }

    public List<SdkField> getAllBodyFields() {
        return this.allBodyFields;
    }

    public ConnectorOperation getConnectorOperation() {
        return this.operation;
    }

    protected CodeBlock generateAuxParameterBindings() {
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.addStatement("$1T<$2T,$3T> parameterBindings = new $4T<>()", new Object[]{Map.class, String.class, Object.class, HashMap.class});
        for (SdkParameter parameter : this.auxParameters) {
            builder.addStatement("$L.$L($S, $L)", new Object[]{PARAMETER_BINDINGS_NAME, "put", parameter.getExternalName(), parameter.getJavaName()});
        }
        return builder.build();
    }

    private MethodSpec generateDoBeforeRequestMethod() {
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)INTERCEPTOR_METHOD_NAME).addModifiers(new Modifier[]{Modifier.PROTECTED}).addModifiers(new Modifier[]{Modifier.ABSTRACT});
        ((List)this.getParametersSpecAndJavaDoc(false, false, false).getLeft()).forEach(arg_0 -> ((MethodSpec.Builder)methodSpecBuilder).addParameter(arg_0));
        methodSpecBuilder.addException(ModuleException.class);
        return methodSpecBuilder.build();
    }

    private MethodSpec generateRequestBindingsMethod() {
        return this.generateRequestBindingMethod(GET_REQUEST_BINDINGS_METHOD, HttpRequestBinding.class, this.operation.getRequestBindings().orElse(null));
    }

    private MethodSpec generateResponseBindingsMethod() {
        return this.generateRequestBindingMethod(GET_RESPONSE_BINDINGS_METHOD, HttpResponseBinding.class, this.operation.getResponseBindings().orElse(null));
    }

    private MethodSpec generateRequestBindingMethod(String methodName, Class<?> builderClass, List<ParameterBinding> parameterBindings) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(builderClass).addAnnotation(Override.class);
        methodBuilder.addStatement("$1T $2L = new $1T()", new Object[]{builderClass, PARAMETER_BINDING_LOCAL_VARIABLE});
        if (parameterBindings != null) {
            for (ParameterBinding binding : parameterBindings) {
                if (binding.isIgnored()) continue;
                if (binding.getParameterType().equals((Object)ParameterType.BODY)) {
                    methodBuilder.addStatement("$L.$L($S)", new Object[]{PARAMETER_BINDING_LOCAL_VARIABLE, ADD_BODY_BINDING_METHOD, binding.getExpression()});
                    continue;
                }
                methodBuilder.addStatement("$L.$L($S, $S)", new Object[]{PARAMETER_BINDING_LOCAL_VARIABLE, this.getParameterBindingAddMethodName(binding), binding.getName(), binding.getExpression()});
            }
        }
        methodBuilder.addStatement("return $1L", new Object[]{PARAMETER_BINDING_LOCAL_VARIABLE});
        return methodBuilder.build();
    }

    private String getParameterBindingAddMethodName(ParameterBinding binding) {
        switch (binding.getParameterType()) {
            case QUERY: {
                return ADD_QUERY_BINDING_METHOD;
            }
            case HEADER: {
                return ADD_HEADER_BINDING_METHOD;
            }
            case URI: {
                return ADD_URI_BINDING_METHOD;
            }
        }
        throw new IllegalArgumentException("Parameter type not supported: " + binding.getParameterType());
    }

    public static class MessageOutputType {
        private final TypeName outputType;
        private final TypeName attributeOutputType;

        public MessageOutputType(TypeName outputType, TypeName attributeOutputType) {
            this.outputType = outputType;
            this.attributeOutputType = attributeOutputType;
        }

        public MessageOutputType(Class<?> outputType, Class<?> attributeOutputType) {
            this((TypeName)ClassName.get(outputType), (TypeName)ClassName.get(attributeOutputType));
        }

        public TypeName getOutputType() {
            return this.outputType;
        }

        public TypeName getAttributeOutputType() {
            return this.attributeOutputType;
        }
    }
}

