/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Field;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.SdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProvider;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.valueprovider.SdkValueProviderDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.valueprovider.SdkValueProviderInline;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.valueprovider.SdkValueProviderReference;
import java.nio.file.Path;

public class SdkField
extends JavaTemplateEntity {
    private final Field field;
    private final SdkConnector connector;
    private final JavaTemplateEntity parentElement;
    private final AbstractSdkResolverProvider sdkValueProvider;

    public SdkField(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, Field field, JavaTemplateEntity parentElement, RestSdkRunConfiguration runConfiguration) {
        super(outputDir, connectorModel, runConfiguration);
        this.field = field;
        this.connector = sdkConnector;
        this.parentElement = parentElement;
        this.sdkValueProvider = this.generateSdkValueProvider();
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.sdkValueProvider.applyTemplates();
    }

    protected AbstractSdkResolverProvider generateSdkValueProvider() {
        AbstractSdkResolverProvider valueProvider = null;
        if (this.field.getValueProvider() != null) {
            if (this.field.getValueProvider() instanceof ResolverDefinition) {
                valueProvider = new SdkValueProviderInline(this.outputDir, this.connectorModel, (SdkOperation)this.parentElement, this.field.getPath(), new SdkValueProviderDefinition((ResolverExpression<ValueProviderDefinition>)this.field.getValueProvider()), this.runConfiguration, false);
            } else if (this.field.getValueProvider() instanceof ResolverReference) {
                valueProvider = new SdkValueProviderReference(this.outputDir, this.connectorModel, this.connector, (SdkOperation)this.parentElement, this.field.getPath(), (ResolverReference<ValueProviderDefinition>)((ResolverReference)this.field.getValueProvider()), new SdkValueProviderDefinition((ResolverExpression<ValueProviderDefinition>)this.field.getValueProvider()), this.runConfiguration, false);
            } else {
                throw new IllegalArgumentException("Value Provider generation not supported: " + this.field.getValueProvider());
            }
        }
        return valueProvider;
    }

    public Field getField() {
        return this.field;
    }

    public String getExternalName() {
        return this.field.getPath();
    }

    public AbstractSdkResolverProvider getSdkValueProvider() {
        return this.sdkValueProvider;
    }
}

