/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.ArrayTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.SdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProvider;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.TypeDefinitionUtil;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.valueprovider.SdkValueProviderDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.valueprovider.SdkValueProviderInline;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.valueprovider.SdkValueProviderReference;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.OAuthParameter;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;

public class SdkParameter
extends JavaTemplateEntity {
    protected final Parameter parameter;
    protected final SdkConnector connector;
    protected final JavaTemplateEntity parentElement;
    private final String parentJavaName;
    private AbstractSdkResolverProvider sdkValueProvider;

    public SdkParameter(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, String parentJavaName, Parameter parameter, JavaTemplateEntity parentElement, RestSdkRunConfiguration runConfiguration) {
        super(outputDir, connectorModel, runConfiguration);
        this.parameter = parameter;
        this.connector = sdkConnector;
        this.parentJavaName = parentJavaName;
        this.parentElement = parentElement;
    }

    public String getDescription() {
        return this.parameter.getDescription();
    }

    public String getDisplayName() {
        return this.parameter.getDisplayName();
    }

    protected String getInternalName() {
        return this.parameter.getInternalName();
    }

    public String getMuleAlias() {
        return this.parameter.getMuleAlias();
    }

    public String getExternalName() {
        return this.parameter.getExternalName();
    }

    protected TypeDefinition getTypeDefinition() {
        return this.parameter.getTypeDefinition();
    }

    protected String getDefaultValue() {
        return this.parameter.getDefaultValue();
    }

    protected boolean getRequired() {
        return this.parameter.isRequired();
    }

    public ParameterType getParameterType() {
        return this.parameter.getParameterType();
    }

    protected String getEnumClassName() {
        return this.isEnum() || this.isInnerTypeEnum() ? SdkParameter.buildEnumName(this.parentJavaName, this) : null;
    }

    protected String getEnumClassPackage() {
        return this.connectorModel.getBasePackage() + ".api.metadata";
    }

    protected AbstractSdkResolverProvider getSdkValueProvider() {
        if (this.sdkValueProvider != null) {
            return this.sdkValueProvider;
        }
        if (this.parentElement instanceof SdkOperation && this.parameter.getValueProvider() != null) {
            if (this.parameter.getValueProvider() instanceof ResolverDefinition) {
                this.sdkValueProvider = new SdkValueProviderInline(this.outputDir, this.connectorModel, (SdkOperation)this.parentElement, this.parameter.getInternalName(), new SdkValueProviderDefinition((ResolverExpression<ValueProviderDefinition>)this.parameter.getValueProvider()), this.runConfiguration, true);
                return this.sdkValueProvider;
            }
            if (this.parameter.getValueProvider() instanceof ResolverReference) {
                this.sdkValueProvider = new SdkValueProviderReference(this.outputDir, this.connectorModel, this.connector, (SdkOperation)this.parentElement, this.parameter.getInternalName(), (ResolverReference<ValueProviderDefinition>)((ResolverReference)this.parameter.getValueProvider()), new SdkValueProviderDefinition((ResolverExpression<ValueProviderDefinition>)this.parameter.getValueProvider()), this.runConfiguration, true);
                return this.sdkValueProvider;
            }
            throw new IllegalArgumentException("Value Provider generation not supported: " + this.parameter.getValueProvider());
        }
        return null;
    }

    public String getJavaName() {
        return JavaUtils.getParameterJavaName((String)this.getInternalName(), (boolean)this.isArrayType());
    }

    public boolean isArrayType() {
        return this.getTypeDefinition() instanceof ArrayTypeDefinition;
    }

    public TypeName getTypeName() {
        return this.getParameterTypeName(this.getTypeDefinition(), false);
    }

    private TypeName getParameterTypeName(TypeDefinition typeDefinition, boolean isInnerType) {
        if (typeDefinition instanceof ArrayTypeDefinition) {
            TypeDefinition innerType = ((ArrayTypeDefinition)typeDefinition).getInnerType();
            return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.getParameterTypeName(innerType, true)});
        }
        if (typeDefinition.isEnum()) {
            return ClassName.get((String)this.getEnumClassPackage(), (String)this.getEnumClassName(), (String[])new String[0]);
        }
        Type parameterPrimitiveJavaType = SdkParameter.getParameterPrimitiveJavaType(typeDefinition);
        if (isInnerType && parameterPrimitiveJavaType.equals(Boolean.TYPE)) {
            return TypeName.get(Boolean.class);
        }
        return TypeName.get((Type)parameterPrimitiveJavaType);
    }

    private static Type getParameterPrimitiveJavaType(TypeDefinition typeDefinition) {
        if (typeDefinition instanceof ArrayTypeDefinition) {
            throw new IllegalArgumentException("Type is not primitive. Should handle arrays in templating.");
        }
        Type javaType = TypeDefinitionUtil.getJavaType(typeDefinition);
        if (javaType.equals(Date.class)) {
            return String.class;
        }
        return javaType;
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        if (this.isEnum() || this.isInnerTypeEnum()) {
            this.generateEnumClass();
        }
        if (this.getSdkValueProvider() != null) {
            this.getSdkValueProvider().applyTemplates();
        }
    }

    private void generateEnumClass() throws TemplatingException {
        MethodSpec enumConstructor = MethodSpec.constructorBuilder().addParameter(String.class, "value", new Modifier[0]).addCode(CodeBlock.builder().addStatement("this.value = value", new Object[0]).build()).build();
        MethodSpec valueGetterMethod = MethodSpec.methodBuilder((String)"getValue").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addCode(CodeBlock.builder().addStatement("return value", new Object[0]).build()).build();
        TypeSpec.Builder enumClassBuilder = TypeSpec.enumBuilder((String)this.getEnumClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(String.class, "value", new Modifier[]{Modifier.PRIVATE}).addMethod(enumConstructor).addMethod(valueGetterMethod);
        for (String enumConstant : this.getEnumValues()) {
            enumClassBuilder.addEnumConstant(JavaUtils.getJavaConstantNameFromXml((String)XmlUtils.getXmlName((String)enumConstant)), TypeSpec.anonymousClassBuilder((String)"$S", (Object[])new Object[]{enumConstant}).build());
        }
        JavaFile.Builder javaFileBuilder = JavaFile.builder((String)this.getEnumClassPackage(), (TypeSpec)enumClassBuilder.build()).skipJavaLangImports(true);
        this.writeJavaFile(javaFileBuilder.build());
    }

    private static String buildEnumName(String parentJavaName, SdkParameter sdkParameter) {
        String parameterNameBasedEnumName = StringUtils.capitalize((String)sdkParameter.getJavaName()) + "Enum";
        String operationNameBasedEnumName = parentJavaName + parameterNameBasedEnumName;
        return operationNameBasedEnumName;
    }

    public ParameterSpec.Builder generateParameterParameter(boolean withAnnotation) {
        return this.generateParameterParameter(null, withAnnotation);
    }

    public ParameterSpec.Builder generateParameterParameter(TypeName forcedTypeName, boolean withAnnotation) {
        ParameterSpec.Builder paramSpecBuilder = forcedTypeName == null ? ParameterSpec.builder((TypeName)this.getTypeName(), (String)this.getJavaName(), (Modifier[])new Modifier[0]) : ParameterSpec.builder((TypeName)forcedTypeName, (String)this.getJavaName(), (Modifier[])new Modifier[0]);
        if (withAnnotation) {
            AnnotationSpec optionalAnnotation = this.getOptionalAnnotation();
            if (optionalAnnotation != null) {
                paramSpecBuilder.addAnnotation(optionalAnnotation);
            }
            this.getNullSafeAnnotation().ifPresent(arg_0 -> ((ParameterSpec.Builder)paramSpecBuilder).addAnnotation(arg_0));
            paramSpecBuilder.addAnnotation(this.getDisplayNameAnnotation());
            this.getMuleAliasAnnotation().ifPresent(arg_0 -> ((ParameterSpec.Builder)paramSpecBuilder).addAnnotation(arg_0));
            this.getSummaryAnnotation().ifPresent(arg_0 -> ((ParameterSpec.Builder)paramSpecBuilder).addAnnotation(arg_0));
            if (this.getSdkValueProvider() != null) {
                paramSpecBuilder.addAnnotation(this.getValueProviderAnnotation());
            }
            this.configureParameterSpecBuilder(paramSpecBuilder);
        }
        return paramSpecBuilder;
    }

    protected void configureParameterSpecBuilder(ParameterSpec.Builder paramSpecBuilder) {
    }

    private AnnotationSpec getValueProviderAnnotation() {
        return AnnotationSpec.builder(OfValues.class).addMember("value", "$T.class", new Object[]{ClassName.get((String)this.getSdkValueProvider().getPackage(), (String)this.getSdkValueProvider().getJavaClassName(), (String[])new String[0])}).build();
    }

    public FieldSpec.Builder generateParameterField() {
        AnnotationSpec parameterAnnotation = AnnotationSpec.builder(org.mule.runtime.extension.api.annotation.param.Parameter.class).build();
        return this.generateParameterField(parameterAnnotation);
    }

    public FieldSpec.Builder generateOAuthParameterField() {
        AnnotationSpec parameterAnnotation = AnnotationSpec.builder(OAuthParameter.class).addMember("requestAlias", "$S", new Object[]{this.getExternalName()}).build();
        return this.generateParameterField(parameterAnnotation);
    }

    private FieldSpec.Builder generateParameterField(AnnotationSpec parameterAnnotation) {
        FieldSpec.Builder fieldSpecBuilder = FieldSpec.builder((TypeName)this.getTypeName(), (String)this.getJavaName(), (Modifier[])new Modifier[0]).addAnnotation(parameterAnnotation).addAnnotation(this.getDisplayNameAnnotation());
        AnnotationSpec optionalAnnotation = this.getOptionalAnnotation();
        if (optionalAnnotation != null) {
            fieldSpecBuilder.addAnnotation(optionalAnnotation);
        }
        this.getMuleAliasAnnotation().ifPresent(arg_0 -> ((FieldSpec.Builder)fieldSpecBuilder).addAnnotation(arg_0));
        this.getSummaryAnnotation().ifPresent(arg_0 -> ((FieldSpec.Builder)fieldSpecBuilder).addAnnotation(arg_0));
        return fieldSpecBuilder;
    }

    private Optional<AnnotationSpec> getNullSafeAnnotation() {
        return Optional.ofNullable(!this.getRequired() && this.isArrayType() ? AnnotationSpec.builder(NullSafe.class).build() : null);
    }

    private AnnotationSpec getOptionalAnnotation() {
        if (!this.getRequired() || StringUtils.isNotBlank((CharSequence)this.getDefaultValue())) {
            AnnotationSpec.Builder optionalBuilder = AnnotationSpec.builder(org.mule.runtime.extension.api.annotation.param.Optional.class);
            if (StringUtils.isNotBlank((CharSequence)this.getDefaultValue())) {
                if (this.isEnum()) {
                    optionalBuilder.addMember("defaultValue", "$S", new Object[]{JavaUtils.getJavaConstantNameFromXml((String)XmlUtils.getXmlName((String)this.getDefaultValue()))});
                } else {
                    optionalBuilder.addMember("defaultValue", "$S", new Object[]{this.getDefaultValue()});
                }
            }
            return optionalBuilder.build();
        }
        return null;
    }

    private AnnotationSpec getDisplayNameAnnotation() {
        return AnnotationSpec.builder(DisplayName.class).addMember("value", "$S", new Object[]{this.getDisplayName()}).build();
    }

    private Optional<AnnotationSpec> getMuleAliasAnnotation() {
        return Optional.ofNullable(StringUtils.isNotBlank((CharSequence)this.getMuleAlias()) ? AnnotationSpec.builder(Alias.class).addMember("value", "$S", new Object[]{this.getMuleAlias()}).build() : null);
    }

    private Optional<AnnotationSpec> getSummaryAnnotation() {
        return Optional.ofNullable(StringUtils.isNotBlank((CharSequence)this.getDescription()) ? AnnotationSpec.builder(Summary.class).addMember("value", "$S", new Object[]{JavaUtils.abbreviateText((String)this.getDescription())}).build() : null);
    }

    public CodeBlock getStringValueGetter() {
        return SdkParameter.getStringValueGetter(this.getTypeDefinition(), this.getJavaName(), this.getRequired());
    }

    public CodeBlock getInnerTypeStringValueGetter(String varName) {
        return SdkParameter.getStringValueGetter(((ArrayTypeDefinition)this.getTypeDefinition()).getInnerType(), varName, true);
    }

    private static CodeBlock getStringValueGetter(TypeDefinition typeDefinition, String varName, boolean required) {
        CodeBlock.Builder blockBuilder = CodeBlock.builder();
        Type javaType = TypeDefinitionUtil.getJavaType(typeDefinition);
        boolean requiresNullCheck = SdkParameter.requiresNullCheck(required, typeDefinition.isEnum(), javaType);
        if (requiresNullCheck) {
            blockBuilder.add("$L != null ? ", new Object[]{varName});
        }
        if (typeDefinition.isEnum()) {
            blockBuilder.add("$L.getValue()", new Object[]{varName});
        } else if (javaType.equals(String.class)) {
            blockBuilder.add(varName, new Object[0]);
        } else {
            blockBuilder.add("$L", new Object[]{varName});
        }
        if (requiresNullCheck) {
            blockBuilder.add(" : null", new Object[0]);
        }
        return blockBuilder.build();
    }

    private static boolean requiresNullCheck(boolean required, boolean isEnum, Type javaType) {
        return !required && (isEnum || !javaType.equals(Boolean.TYPE) && !javaType.equals(String.class));
    }

    private boolean isEnum() {
        return this.getTypeDefinition().isEnum();
    }

    private boolean isInnerTypeEnum() {
        return this.getTypeDefinition() instanceof ArrayTypeDefinition && ((ArrayTypeDefinition)this.getTypeDefinition()).getInnerType().isEnum();
    }

    private List<String> getEnumValues() {
        if (this.isEnum()) {
            return this.getTypeDefinition().getEnumValues();
        }
        if (this.isInnerTypeEnum()) {
            return ((ArrayTypeDefinition)this.getTypeDefinition()).getInnerType().getEnumValues();
        }
        return null;
    }
}

