/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.trigger;

import com.mulesoft.connectivity.rest.commons.api.source.RestPollingSource;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.TypeSchemaPool;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.TriggerParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.Trigger;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.trigger.SdkTriggerTemplate;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.trigger.layers.SdkTriggerBaseLayer;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.trigger.layers.SdkTriggerImplementationLayer;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.trigger.layers.SdkTriggerInterceptorLayer;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class SdkTrigger
extends JavaTemplateEntity
implements SdkTriggerTemplate {
    public static final String CLASSNAME_SUFFIX = "Trigger";
    private static final String PACKAGE_SUFFIX = ".internal.source";
    private final SdkTriggerBaseLayer baseLayer;
    private final SdkTriggerInterceptorLayer interceptorLayer;
    private final SdkTriggerImplementationLayer implementationLayer;
    private final SdkConnector sdkConnector;
    private final Trigger trigger;
    private final List<SdkParameter> sdkParameters;
    private final String javaClassName;
    private final String packageName;

    public SdkTrigger(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, Trigger trigger, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, runConfiguration);
        this.sdkConnector = sdkConnector;
        this.trigger = trigger;
        this.sdkParameters = this.buildSdkParameters();
        this.javaClassName = this.getJavaClassName();
        this.packageName = this.getPackage();
        this.baseLayer = new SdkTriggerBaseLayer(outputDir, connectorModel, sdkConnector, trigger, this.sdkParameters, this.javaClassName, this.packageName, (TypeName)ClassName.get(RestPollingSource.class), runConfiguration);
        this.interceptorLayer = new SdkTriggerInterceptorLayer(outputDir, connectorModel, sdkConnector, trigger, this.javaClassName, this.packageName, this.baseLayer.getTypeName(), runConfiguration);
        this.implementationLayer = new SdkTriggerImplementationLayer(outputDir, connectorModel, sdkConnector, trigger, this.javaClassName, this.packageName, this.interceptorLayer.getTypeName(), this.sdkParameters, runConfiguration);
    }

    public String getJavaClassName() {
        return JavaUtils.getJavaUpperCamelNameFromXml((String)this.trigger.getInternalName()) + CLASSNAME_SUFFIX;
    }

    public String getPackage() {
        return this.connectorModel.getBasePackage() + PACKAGE_SUFFIX;
    }

    private List<SdkParameter> buildSdkParameters() {
        return this.trigger.getParameters().stream().map(this::buildSdkParameter).collect(Collectors.toList());
    }

    private SdkParameter buildSdkParameter(TriggerParameter triggerParameter) {
        String parameterIdentifier = triggerParameter.getExternalName();
        ParameterBuilder paramBuilder = new ParameterBuilder(ParameterType.TRIGGER, triggerParameter.getExternalName(), parameterIdentifier).displayName(triggerParameter.getDisplayName()).description(triggerParameter.getDescription()).muleAlias(triggerParameter.getMuleAlias()).required(triggerParameter.isRequired());
        paramBuilder.getTypeDefinitionBuilder().primitive(this.getPrimitiveType(triggerParameter.getType()));
        return new SdkParameter(this.outputDir, this.connectorModel, this.sdkConnector, this.javaClassName, paramBuilder.buildParameter(new TypeSchemaPool(), Optional.empty()), this, this.runConfiguration);
    }

    private PrimitiveTypeDefinition.PrimitiveType getPrimitiveType(ParameterDataType parameterDataType) {
        switch (parameterDataType) {
            case NUMBER: {
                return PrimitiveTypeDefinition.PrimitiveType.NUMBER;
            }
            case INTEGER: {
                return PrimitiveTypeDefinition.PrimitiveType.INTEGER;
            }
            case LONG: {
                return PrimitiveTypeDefinition.PrimitiveType.LONG;
            }
            case STRING: {
                return PrimitiveTypeDefinition.PrimitiveType.STRING;
            }
            case BOOLEAN: {
                return PrimitiveTypeDefinition.PrimitiveType.BOOLEAN;
            }
            case LOCAL_DATE_TIME: {
                return PrimitiveTypeDefinition.PrimitiveType.LOCAL_DATE_TIME;
            }
            case ZONED_DATE_TIME: {
                return PrimitiveTypeDefinition.PrimitiveType.ZONED_DATE_TIME;
            }
        }
        throw new IllegalArgumentException("Parameter type not supported. This is a bug.");
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.baseLayer.applyTemplates();
        this.interceptorLayer.applyTemplates();
        this.implementationLayer.applyTemplates();
    }

    @Override
    public TypeName getTypeNameForConfig() {
        return this.implementationLayer.getTypeName();
    }
}

