/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.configuration.layers;

import com.mulesoft.connectivity.rest.commons.api.error.RestError;
import com.mulesoft.connectivity.rest.commons.api.interception.CompositeHttpResponseInterceptor;
import com.mulesoft.connectivity.rest.commons.api.interception.HttpResponseInterceptor;
import com.mulesoft.connectivity.rest.commons.api.interception.expression.ExpressionHttpResponseInterceptor;
import com.mulesoft.connectivity.rest.commons.api.interception.expression.PreconditionHttpResponseInterceptorDelegate;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorInterceptor;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.configuration.layers.AbstractSdkConfigLayer;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public class SdkConfigBaseLayer
extends AbstractSdkConfigLayer {
    private static final String GET_RESPONSE_INTERCEPTORS = "getResponseInterceptors";
    private final TypeName superclass;

    public SdkConfigBaseLayer(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, String javaClassName, String packageName, TypeName superclass, RestSdkRunConfiguration runConfiguration) {
        super(outputDir, connectorModel, sdkConnector, javaClassName, packageName, runConfiguration);
        this.superclass = superclass;
    }

    @Override
    public String getJavaClassName() {
        return super.getJavaClassName() + "Base";
    }

    @Override
    public String getPackage() {
        return super.getPackage() + ".base";
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.generateConfigClass();
    }

    private void generateConfigClass() throws TemplatingException {
        TypeSpec.Builder configClassBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.ABSTRACT}).superclass(this.superclass);
        if (this.connectorModel.getInterceptors() != null && this.connectorModel.getInterceptors().size() > 0) {
            this.addResponseInterceptors(configClassBuilder);
        }
        JavaFile.Builder javaFileBuilder = this.getJavaFileBuilderForClass(configClassBuilder.build(), this.getPackage());
        this.writeJavaFile(javaFileBuilder.build());
    }

    private CodeBlock.Builder generateInterceptorsBlocks(CodeBlock.Builder methodBody, List<ConnectorInterceptor> interceptors, String name, String matcher) {
        String listName = "httpResponseInterceptors" + name;
        methodBody.addStatement("$1T<$2T> " + listName + " = new $3T<>()", new Object[]{List.class, HttpResponseInterceptor.class, ArrayList.class});
        for (ConnectorInterceptor connectorInterceptor : interceptors) {
            methodBody.add(listName + ".add($1T.builder()\n", new Object[]{ExpressionHttpResponseInterceptor.class});
            if (connectorInterceptor.getExpression() != null) {
                methodBody.add(".matchExpression(\"" + connectorInterceptor.getExpression() + "\")\n", new Object[0]);
            }
            if (connectorInterceptor.getReasonPhrase() != null) {
                methodBody.add(".reasonPhraseExpression(\"" + connectorInterceptor.getReasonPhrase() + "\")\n", new Object[0]);
            }
            if (connectorInterceptor.getStatusCode() != null) {
                methodBody.add(".statusCodeExpression(\"" + connectorInterceptor.getStatusCode() + "\")\n", new Object[0]);
            }
            if (connectorInterceptor.getBody() != null) {
                methodBody.add(".bodyExpression(\"" + connectorInterceptor.getBody() + "\")\n", new Object[0]);
            }
            if (connectorInterceptor.getHeaders() != null) {
                methodBody.add(".headersExpression(\"" + connectorInterceptor.getHeaders() + "\")\n", new Object[0]);
            }
            methodBody.add(".defaultResponseMediaType(getDefaultResponseMediaType())\n", new Object[0]);
            methodBody.addStatement(".build())", new Object[0]);
        }
        methodBody.addStatement("$1T " + name + " = new $1T(" + matcher + ", new $2T(httpResponseInterceptors" + name + ",$3T.ONLY_FIRST))", new Object[]{PreconditionHttpResponseInterceptorDelegate.class, CompositeHttpResponseInterceptor.class, CompositeHttpResponseInterceptor.ExecutionStrategy.ONLY_FIRST.getClass()});
        return methodBody;
    }

    private CodeBlock generateInterceptors() {
        CodeBlock.Builder methodBody = CodeBlock.builder();
        methodBody.addStatement("$1T.Matcher isRestSdkErrorPrecondition = (httpRequest, httpResponse) -> $2T.getErrorByCode(httpResponse.getStatusCode()).isPresent()", new Object[]{PreconditionHttpResponseInterceptorDelegate.class, RestError.class});
        methodBody.addStatement("$1T.Matcher isRestSdkNotErrorPrecondition = (httpRequest, httpResponse) -> !$2T.getErrorByCode(httpResponse.getStatusCode()).isPresent()", new Object[]{PreconditionHttpResponseInterceptorDelegate.class, RestError.class});
        methodBody.addStatement("$1T<$2T> httpResponseInterceptorsFinal = new $3T<>()", new Object[]{List.class, HttpResponseInterceptor.class, ArrayList.class});
        List<ConnectorInterceptor> interceptorsOnError = this.connectorModel.getInterceptors().stream().filter(x -> x.isOnError()).collect(Collectors.toList());
        List<ConnectorInterceptor> interceptorsOnSuccess = this.connectorModel.getInterceptors().stream().filter(x -> !x.isOnError()).collect(Collectors.toList());
        if (interceptorsOnError != null && interceptorsOnError.size() > 0) {
            this.generateInterceptorsBlocks(methodBody, interceptorsOnError, "onErrorInterceptors", "isRestSdkErrorPrecondition");
            methodBody.addStatement("httpResponseInterceptorsFinal.add(onErrorInterceptors)", new Object[0]);
        }
        if (interceptorsOnSuccess != null && interceptorsOnSuccess.size() > 0) {
            this.generateInterceptorsBlocks(methodBody, interceptorsOnSuccess, "onSuccessInterceptors", "isRestSdkNotErrorPrecondition");
            methodBody.addStatement("httpResponseInterceptorsFinal.add(onSuccessInterceptors)", new Object[0]);
        }
        methodBody.addStatement("return new $1T(httpResponseInterceptorsFinal, $2T.ONLY_FIRST)", new Object[]{CompositeHttpResponseInterceptor.class, CompositeHttpResponseInterceptor.ExecutionStrategy.ONLY_FIRST.getClass()});
        return methodBody.build();
    }

    private void addResponseInterceptors(TypeSpec.Builder configClassBuilder) {
        MethodSpec getInterceptors = MethodSpec.methodBuilder((String)GET_RESPONSE_INTERCEPTORS).returns(TypeName.get(HttpResponseInterceptor.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(this.generateInterceptors()).build();
        configClassBuilder.addMethod(getInterceptors);
    }
}

