/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication;

import com.google.common.base.CaseFormat;
import com.mulesoft.connectivity.rest.commons.api.connection.BearerAuthenticationConnectionProvider;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.BearerAuthDefaultParameters;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.BearerAuthScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication.SdkAuthenticationStrategy;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.SdkTemplatingUtils;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.ObjectUtils;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.sdk.api.annotation.semantics.security.SecretToken;

public class SdkBearerAuthenticationStrategy
extends SdkAuthenticationStrategy {
    public static final String TOKEN_FIELD = "token";
    public static final String TOKEN_FIELD_DEFAULT_DISPLAY_NAME = "Token";
    public static final String TOKEN_FIELD_DEFAULT_SUMMARY = "The token used to authenticate the requests.";

    protected SdkBearerAuthenticationStrategy(ConnectorSecurityScheme securityScheme) {
        super(securityScheme);
    }

    @Override
    public Class<?> getCommonsBaseClass() {
        return BearerAuthenticationConnectionProvider.class;
    }

    @Override
    public void addClassAnnotations(TypeSpec.Builder connectionProviderClassBuilder) {
    }

    @Override
    public void addDefaultClassMembers(TypeSpec.Builder connectionProviderClassBuilder) {
        this.addTokenParameterField(connectionProviderClassBuilder);
    }

    protected void addTokenParameterField(TypeSpec.Builder classBuilder) {
        BearerAuthDefaultParameters bearerAuthDefaultParameters = ((BearerAuthScheme)this.securityScheme).getBearerAuthDefaultParameters();
        String displayName = TOKEN_FIELD_DEFAULT_DISPLAY_NAME;
        String summary = TOKEN_FIELD_DEFAULT_SUMMARY;
        if (bearerAuthDefaultParameters != null) {
            displayName = (String)ObjectUtils.defaultIfNull((Object)bearerAuthDefaultParameters.getToken().getDisplayName(), (Object)displayName);
            summary = (String)ObjectUtils.defaultIfNull((Object)bearerAuthDefaultParameters.getToken().getDescription(), (Object)summary);
        }
        FieldSpec fieldSpec = FieldSpec.builder(String.class, (String)TOKEN_FIELD, (Modifier[])new Modifier[]{Modifier.PROTECTED}).addAnnotation(Parameter.class).addAnnotation(SecretToken.class).addAnnotation(SdkTemplatingUtils.getDisplayNameAnnotation(displayName)).addAnnotation(SdkTemplatingUtils.getSummaryAnnotation(summary)).build();
        MethodSpec getter = SdkTemplatingUtils.generateGetter(fieldSpec, CaseFormat.LOWER_CAMEL, Modifier.PROTECTED).addAnnotation(Override.class).build();
        classBuilder.addField(fieldSpec).addMethod(getter);
    }
}

