/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.layers;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication.SdkAuthenticationStrategy;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.layers.AbstractSdkConnectionProviderLayer;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import javax.lang.model.element.Modifier;

public class SdkConnectionProviderRefinementLayer
extends AbstractSdkConnectionProviderLayer {
    public static final String REFINEMENT_LAYER_JAVADOC = "This Refinement class is the middle layer of the connection provider generation gap pattern. It can be overridden to add custom logic in the connection provider.";
    private final TypeName baseClass;

    public SdkConnectionProviderRefinementLayer(Path outputDir, ConnectorModel connectorModel, ConnectorSecurityScheme securityScheme, SdkAuthenticationStrategy authenticationStrategy, TypeName baseClass, RestSdkRunConfiguration runConfiguration) {
        super(outputDir, connectorModel, securityScheme, authenticationStrategy, runConfiguration);
        this.baseClass = baseClass;
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.generateConnectionProviderClass();
    }

    private void generateConnectionProviderClass() throws TemplatingException {
        TypeSpec.Builder connectionProviderClassBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(this.baseClass).addJavadoc(REFINEMENT_LAYER_JAVADOC, new Object[0]);
        this.writeClassToFile(connectionProviderClassBuilder.build(), this.getPackage(), true, this.securityScheme.isRefined());
    }

    @Override
    public String getJavaClassName() {
        return JavaUtils.getJavaUpperCamelNameFromXml((String)this.getConnectionProviderXmlName()) + "ConnectionProvider" + "Refinement";
    }

    @Override
    public String getPackage() {
        return this.getConnectionProviderBasePackage() + ".refinement";
    }
}

