/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.layers;

import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication.SdkAuthenticationStrategy;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.layers.AbstractSdkConnectionProviderLayer;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.SdkTemplatingUtils;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang.WordUtils;
import org.mule.runtime.extension.api.annotation.Alias;

public class SdkConnectorProviderImplementationLayer
extends AbstractSdkConnectionProviderLayer {
    public static final String IMPLEMENTATION_LAYER_JAVADOC = "This is the last layer of the connection provider generation gap pattern. It is what finally gets exposed as the connection provider, including all customizations made in the refinement layer.";
    private final TypeName baseClass;

    public SdkConnectorProviderImplementationLayer(Path outputDir, ConnectorModel connectorModel, ConnectorSecurityScheme securityScheme, SdkAuthenticationStrategy authenticationStrategy, TypeName baseClass, RestSdkRunConfiguration runConfiguration) {
        super(outputDir, connectorModel, securityScheme, authenticationStrategy, runConfiguration);
        this.baseClass = baseClass;
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.generateConnectionProviderClass();
    }

    private void generateConnectionProviderClass() throws TemplatingException {
        TypeSpec.Builder connectionProviderClassBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(this.baseClass).addAnnotation(this.generateAliasAnnotation()).addAnnotation(SdkTemplatingUtils.getDisplayNameAnnotation(this.getConnectionProviderDisplayName())).addJavadoc(IMPLEMENTATION_LAYER_JAVADOC, new Object[0]);
        this.authenticationStrategy.addClassAnnotations(connectionProviderClassBuilder);
        this.writeClassToFile(connectionProviderClassBuilder.build(), this.getPackage());
    }

    private AnnotationSpec generateAliasAnnotation() {
        return AnnotationSpec.builder(Alias.class).addMember("value", "$S", new Object[]{this.getSchemaAlias()}).build();
    }

    private String getSchemaAlias() {
        return !RestSdkUtils.isBlank((CharSequence)this.securityScheme.getAlias()) ? this.securityScheme.getAlias() : this.getConnectionProviderXmlName();
    }

    private String getConnectionProviderDisplayName() {
        return WordUtils.capitalize((String)this.getConnectionProviderXmlName().replace('-', ' ')) + " Connection Provider";
    }

    @Override
    public String getJavaClassName() {
        return JavaUtils.getJavaUpperCamelNameFromXml((String)this.getConnectionProviderXmlName()) + "ConnectionProvider";
    }

    @Override
    public String getPackage() {
        return this.getConnectionProviderBasePackage();
    }
}

