/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.model;

import com.google.common.base.CaseFormat;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.SdkTemplatingUtils;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import java.util.Objects;
import javax.lang.model.element.Modifier;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.sdk.api.annotation.semantics.connectivity.ConfiguresProxy;
import org.mule.sdk.api.annotation.semantics.connectivity.Host;
import org.mule.sdk.api.annotation.semantics.connectivity.Port;
import org.mule.sdk.api.annotation.semantics.security.Password;
import org.mule.sdk.api.annotation.semantics.security.Username;

public class SdkHttpProxyConfig
extends JavaTemplateEntity {
    public SdkHttpProxyConfig(Path outputDir, ConnectorModel connectorModel, RestSdkRunConfiguration runConfiguration) {
        super(outputDir, connectorModel, runConfiguration);
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        ClassName className = this.getClassName();
        TypeSpec.Builder typeSpecBuilder = TypeSpec.classBuilder((ClassName)className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(ProxyConfig.class).addAnnotation(AnnotationSpec.builder(Alias.class).addMember("value", "$S", new Object[]{"proxy"}).build()).addAnnotation(AnnotationSpec.builder(TypeDsl.class).addMember("allowTopLevelDefinition", "$L", new Object[]{true}).build()).addAnnotation(ConfiguresProxy.class);
        FieldSpec hostFieldSpec = FieldSpec.builder(String.class, (String)"host", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Parameter.class).addAnnotation(AnnotationSpec.builder(Expression.class).addMember("value", "$T.$L", new Object[]{ExpressionSupport.class, ExpressionSupport.NOT_SUPPORTED}).build()).addAnnotation(Host.class).addJavadoc("Host where the proxy requests will be sent.", new Object[0]).build();
        typeSpecBuilder.addField(hostFieldSpec);
        typeSpecBuilder.addMethod(SdkTemplatingUtils.generateGetter(hostFieldSpec, CaseFormat.LOWER_CAMEL).addAnnotation(Override.class).build());
        FieldSpec portFieldSpec = FieldSpec.builder((TypeName)TypeName.INT, (String)"port", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Parameter.class).addAnnotation(AnnotationSpec.builder(Expression.class).addMember("value", "$T.$L", new Object[]{ExpressionSupport.class, ExpressionSupport.NOT_SUPPORTED}).build()).addAnnotation(Port.class).addJavadoc("Port where the proxy requests will be sent.", new Object[0]).initializer("$T.MAX_VALUE", new Object[]{Integer.class}).build();
        typeSpecBuilder.addField(portFieldSpec);
        typeSpecBuilder.addMethod(SdkTemplatingUtils.generateGetter(portFieldSpec, CaseFormat.LOWER_CAMEL).addAnnotation(Override.class).build());
        FieldSpec usernameFieldSpec = FieldSpec.builder(String.class, (String)"username", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Parameter.class).addAnnotation(AnnotationSpec.builder(Expression.class).addMember("value", "$T.$L", new Object[]{ExpressionSupport.class, ExpressionSupport.NOT_SUPPORTED}).build()).addAnnotation(Username.class).addJavadoc("The username to authenticate against the proxy.", new Object[0]).build();
        typeSpecBuilder.addField(usernameFieldSpec);
        typeSpecBuilder.addMethod(SdkTemplatingUtils.generateGetter(usernameFieldSpec, CaseFormat.LOWER_CAMEL).addAnnotation(Override.class).build());
        FieldSpec passwordFieldSpec = FieldSpec.builder(String.class, (String)"password", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Parameter.class).addAnnotation(AnnotationSpec.builder(Expression.class).addMember("value", "$T.$L", new Object[]{ExpressionSupport.class, ExpressionSupport.NOT_SUPPORTED}).build()).addAnnotation(Password.class).addJavadoc("The password to authenticate against the proxy.", new Object[0]).build();
        typeSpecBuilder.addField(passwordFieldSpec);
        typeSpecBuilder.addMethod(SdkTemplatingUtils.generateGetter(passwordFieldSpec, CaseFormat.LOWER_CAMEL).addAnnotation(Override.class).build());
        FieldSpec nonProxyHostsFieldSpec = FieldSpec.builder(String.class, (String)"nonProxyHosts", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Parameter.class).addAnnotation(AnnotationSpec.builder(Expression.class).addMember("value", "$T.$L", new Object[]{ExpressionSupport.class, ExpressionSupport.NOT_SUPPORTED}).build()).addJavadoc("A list of comma separated hosts against which the proxy should not be used", new Object[0]).build();
        typeSpecBuilder.addField(nonProxyHostsFieldSpec);
        typeSpecBuilder.addMethod(SdkTemplatingUtils.generateGetter(nonProxyHostsFieldSpec, CaseFormat.LOWER_CAMEL).addAnnotation(Override.class).build());
        typeSpecBuilder.addMethod(MethodSpec.methodBuilder((String)"equals").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(TypeName.BOOLEAN).addParameter(Object.class, "o", new Modifier[0]).addCode(CodeBlock.builder().beginControlFlow("if (this == o)", new Object[0]).addStatement("return true", new Object[0]).endControlFlow().beginControlFlow("if (o == null || getClass() != o.getClass())", new Object[0]).addStatement("return false", new Object[0]).endControlFlow().addStatement("$L that = ($L) o", new Object[]{className.simpleName(), className.simpleName()}).addStatement("return port == that.port &&\n        $T.equals(host, that.host) &&\n        $T.equals(username, that.username) &&\n        $T.equals(password, that.password) &&\n        $T.equals(nonProxyHosts, that.nonProxyHosts)", new Object[]{Objects.class, Objects.class, Objects.class, Objects.class}).build()).build());
        typeSpecBuilder.addMethod(MethodSpec.methodBuilder((String)"hashCode").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(TypeName.INT).addCode(CodeBlock.builder().addStatement("return $T.hash(host, port, username, password, nonProxyHosts)", new Object[]{Objects.class}).build()).build());
        TypeSpec typeSpec = typeSpecBuilder.build();
        this.writeClassToFile(typeSpec, className.packageName());
    }

    public TypeName getTypeName() {
        return this.getClassName();
    }

    private ClassName getClassName() {
        return ClassName.get((String)(this.connectorModel.getBasePackage() + ".api.proxy"), (String)"HttpProxyConfig", (String[])new String[0]);
    }
}

