/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.configuration.layers;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;

import java.nio.file.Path;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;

public abstract class AbstractSdkConfigLayer extends JavaTemplateEntity {

  private final String javaClassName;
  private final String packageName;
  protected final SdkConnector sdkConnector;
  protected final RestSdkRunConfiguration runConfiguration;

  public AbstractSdkConfigLayer(Path outputDir,
                                ConnectorModel connectorModel, SdkConnector sdkConnector,
                                String javaClassName, String packageName, RestSdkRunConfiguration runConfiguration) {
    super(outputDir, connectorModel, runConfiguration);
    this.javaClassName = javaClassName;
    this.packageName = packageName;
    this.sdkConnector = sdkConnector;
    this.runConfiguration = runConfiguration;
  }

  public String getJavaClassName() {
    return javaClassName;
  }

  public String getPackage() {
    return packageName;
  }

  public TypeName getTypeName() {
    return ClassName.get(getPackage(), getJavaClassName());
  }
}
