/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.valueprovider;

import static java.lang.String.format;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.SdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverTemplate;

import java.nio.file.Path;

import org.apache.commons.lang3.StringUtils;

public class SdkValueProviderFactory {

  public static SdkResolverTemplate generateSdkValueProvider(ResolverExpression<ValueProviderDefinition> valueProvider,
                                                             SdkOperation sdkOperation,
                                                             String internalName,
                                                             Path outputDir,
                                                             ConnectorModel connectorModel,
                                                             SdkConnector connector,
                                                             RestSdkRunConfiguration runConfiguration,
                                                             boolean useExtensionsApi,
                                                             boolean isTrigger) {
    if (valueProvider == null) {
      return null;
    }

    SdkResolverTemplate sdkValueProvider;
    if (valueProvider instanceof ResolverDefinition) {
      ValueProviderDefinition valueProviderDefinition = (ValueProviderDefinition) valueProvider;
      if (StringUtils.isNotBlank(valueProviderDefinition.getFqn())) {
        sdkValueProvider = new SdkNativeValueProvider(outputDir, connectorModel, valueProviderDefinition, runConfiguration);
      } else {
        sdkValueProvider = new SdkValueProviderInline(outputDir,
                                                      connectorModel,
                                                      sdkOperation,
                                                      internalName,
                                                      new SdkValueProviderDefinition(valueProviderDefinition, isTrigger),
                                                      runConfiguration,
                                                      useExtensionsApi);
      }

      return sdkValueProvider;

    } else if (valueProvider instanceof ResolverReference) {
      sdkValueProvider = new SdkValueProviderReference(outputDir,
                                                       connectorModel,
                                                       connector,
                                                       sdkOperation,
                                                       internalName,
                                                       (ResolverReference<ValueProviderDefinition>) valueProvider,
                                                       new SdkValueProviderDefinition(valueProvider, isTrigger),
                                                       runConfiguration,
                                                       useExtensionsApi);

      return sdkValueProvider;
    }

    throw new IllegalArgumentException(format("Value Provider generation not supported for '%s'. This is a bug.", valueProvider));
  }
}
