/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating;

import com.google.common.base.CaseFormat;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.DataWeaveExpressionParser;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.TemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkField;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverTemplate;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverUtil;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.SdkBodyLevelUtils;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.mule.sdk.api.annotation.binding.Binding;
import org.mule.sdk.api.annotation.values.FieldValues;

public abstract class JavaTemplateEntity
extends TemplateEntity {
    protected static final String VALUE_MEMBER = "value";
    protected static final String NAME_MEMBER = "name";
    protected static final String BASE_PACKAGE_SUFFIX = ".base";
    protected static final String REFINEMENT_PACKAGE_SUFFIX = ".refinement";
    protected static final String BASE_CLASSNAME_SUFFIX = "Base";
    public static final String REFINEMENT_CLASSNAME_SUFFIX = "Refinement";
    protected static final String FIRST_GENERATION_TEMPLATE = "Generating: '%s' for the first time.";
    protected static final String IGNORED_OVERRIDE_TEMPLATE = "Ignoring: '%s.java' as it was overwritten.";
    protected static final String IGNORED_REFINEMENT_TEMPLATE = "Not writing '%s.java' as it is refined.";
    private static final String NULL = "null";
    protected final Path outputDir;
    protected final ConnectorModel connectorModel;
    protected final RestSdkRunConfiguration runConfiguration;

    public JavaTemplateEntity(Path outputDir, ConnectorModel connectorModel, RestSdkRunConfiguration runConfiguration) {
        this.outputDir = outputDir;
        this.connectorModel = connectorModel;
        this.runConfiguration = runConfiguration;
    }

    protected void writeClassToFile(TypeSpec clazz, String targetPackage) throws TemplatingException {
        this.writeClassToFile(clazz, targetPackage, false, false);
    }

    protected void writeClassToFile(TypeSpec clazz, String targetPackage, boolean classIsRefinable, boolean classIsRefined) throws TemplatingException {
        this.writeJavaFile(this.getJavaFileBuilderForClass(clazz, targetPackage).build(), classIsRefinable, classIsRefined);
    }

    protected JavaFile.Builder getJavaFileBuilderForClass(TypeSpec clazz, String targetPackage) {
        return JavaFile.builder((String)targetPackage, (TypeSpec)clazz).skipJavaLangImports(true);
    }

    protected void writeJavaFile(JavaFile javaFile) throws TemplatingException {
        this.writeJavaFile(javaFile, false, false);
    }

    protected void writeJavaFile(JavaFile javaFile, boolean classIsRefinable, boolean classIsRefined) throws TemplatingException {
        try {
            String packageDirectory = javaFile.packageName.replace('.', File.separatorChar);
            String fileName = packageDirectory + File.separatorChar + javaFile.typeSpec.name + ".java";
            if (this.runConfiguration.getProcessedFiles().contains(fileName)) {
                throw new TemplatingException(String.format("There are two elements being written in the same file [%s]", fileName));
            }
            this.runConfiguration.getProcessedFiles().add(fileName);
            if (this.shouldGenerateSource(javaFile)) {
                if (classIsRefined) {
                    Path refinementFilePath = javaFile.writeToPath(this.outputDir.resolve(this.runConfiguration.getRefinementDir()));
                    this.runConfiguration.getProcessedRefinements().add(refinementFilePath);
                    this.runConfiguration.messageCollector().addInfo(String.format(FIRST_GENERATION_TEMPLATE, fileName));
                } else {
                    javaFile.writeTo(this.outputDir.resolve(this.runConfiguration.getGeneratedSourcesDir()));
                }
            } else if (classIsRefinable) {
                this.runConfiguration.messageCollector().addInfo(String.format(IGNORED_REFINEMENT_TEMPLATE, fileName));
                if (classIsRefined) {
                    Path ignoredRefinement = this.outputDir.resolve(this.runConfiguration.getRefinementDir()).resolve(fileName);
                    this.runConfiguration.getProcessedRefinements().add(ignoredRefinement);
                }
            } else {
                this.runConfiguration.messageCollector().addInfo(String.format(IGNORED_OVERRIDE_TEMPLATE, fileName));
                Path ignoredDir = this.outputDir.resolve(this.runConfiguration.getIgnoredDir());
                javaFile.writeTo(ignoredDir);
                Path generatedIgnoredFile = this.resolveJavaFile(javaFile, this.runConfiguration.getIgnoredDir());
                if (generatedIgnoredFile.toFile().exists()) {
                    this.compareToOverrideOne(javaFile, generatedIgnoredFile, this.runConfiguration.getOverrideDir());
                    this.compareToOverrideOne(javaFile, generatedIgnoredFile, this.runConfiguration.getSourceDir());
                }
            }
        }
        catch (Exception e) {
            throw new TemplatingException(String.format("There was an error when writing '%s' class. This is a bug.", this.getClass().getName()), e);
        }
    }

    private void compareToOverrideOne(JavaFile javaFile, Path ignoredFile, String overrideDir) throws IOException {
        Path overwrittenFile = this.resolveJavaFile(javaFile, overrideDir);
        if (overwrittenFile.toFile().exists()) {
            String currentContent = new String(Files.readAllBytes(overwrittenFile), StandardCharsets.UTF_8);
            String newContent = new String(Files.readAllBytes(ignoredFile), StandardCharsets.UTF_8);
            boolean isIdentical = this.toCanonicalWay(currentContent).equals(this.toCanonicalWay(newContent));
            if (isIdentical) {
                this.runConfiguration.messageCollector().addWarning("Overwritten file `" + overwrittenFile + "` can be removed as is the same as the generated one.");
            }
        }
    }

    private String toCanonicalWay(String currentContent) {
        return currentContent.replaceAll("\\s+", " ");
    }

    private boolean shouldGenerateSource(JavaFile javaFile) {
        boolean isOldWay;
        boolean bl = isOldWay = !this.runConfiguration.regenerateMode();
        if (isOldWay) {
            return true;
        }
        Path inOverride = this.resolveJavaFile(javaFile, this.runConfiguration.getOverrideDir());
        Path inSourceDir = this.resolveJavaFile(javaFile, this.runConfiguration.getSourceDir());
        Path inRefinementDir = this.resolveJavaFile(javaFile, this.runConfiguration.getRefinementDir());
        return !inOverride.toFile().exists() && !inSourceDir.toFile().exists() && !inRefinementDir.toFile().exists();
    }

    private Path resolveJavaFile(JavaFile javaFile, String targetRelativeFolderPath) {
        String javaFileName = javaFile.typeSpec.name + ".java";
        String packageDirectory = javaFile.packageName.replace('.', File.separatorChar);
        Path resolve = this.outputDir.resolve(targetRelativeFolderPath).resolve(packageDirectory).resolve(javaFileName);
        return resolve;
    }

    public Path getResourcesPath() {
        return this.outputDir.resolve(this.runConfiguration.getGeneratedResourcesDir());
    }

    public Path getSourcesPath() {
        return this.outputDir.resolve("src");
    }

    protected MethodSpec.Builder generateOptionalGetter(FieldSpec fieldSpec, Class<?> type, CaseFormat fieldNameCaseFormat) {
        String name = "get" + fieldNameCaseFormat.to(CaseFormat.UPPER_CAMEL, fieldSpec.name);
        return MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get(Optional.class, (Type[])new Type[]{type})).addCode(CodeBlock.builder().addStatement("return $T.ofNullable(this.$N)", new Object[]{Optional.class, fieldSpec}).build());
    }

    public static FieldSpec getConstantStringField(String fieldName, String value) {
        return JavaTemplateEntity.getConstantStringField(fieldName, value, Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL);
    }

    public static FieldSpec getConstantStringField(String fieldName, String value, Modifier ... modifiers) {
        FieldSpec.Builder fieldSpecBuilder = FieldSpec.builder(String.class, (String)fieldName, (Modifier[])modifiers);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            fieldSpecBuilder.initializer("$S", new Object[]{value});
        } else {
            fieldSpecBuilder.initializer("$L", new Object[]{NULL});
        }
        return fieldSpecBuilder.build();
    }

    protected Class<?> getJavaType(ParameterDataType parameterDataType) {
        if (parameterDataType.equals((Object)ParameterDataType.LOCAL_DATE_TIME)) {
            return LocalDateTime.class;
        }
        if (parameterDataType.equals((Object)ParameterDataType.ZONED_DATE_TIME)) {
            return ZonedDateTime.class;
        }
        if (parameterDataType.equals((Object)ParameterDataType.STRING)) {
            return String.class;
        }
        if (parameterDataType.equals((Object)ParameterDataType.INTEGER)) {
            return Integer.class;
        }
        if (parameterDataType.equals((Object)ParameterDataType.LONG)) {
            return Long.class;
        }
        if (parameterDataType.equals((Object)ParameterDataType.NUMBER)) {
            return Double.class;
        }
        if (parameterDataType.equals((Object)ParameterDataType.BOOLEAN)) {
            return Boolean.TYPE;
        }
        throw new IllegalArgumentException(String.format("Parameter data type '%s' is not supported. This is a bug.", parameterDataType.getName()));
    }

    protected AnnotationSpec getValueProviderAnnotation(SdkField sdkField, String contentParameterName) {
        SdkResolverTemplate valueProvider = sdkField.getSdkValueProvider();
        AnnotationSpec.Builder annotationBuilder = AnnotationSpec.builder(FieldValues.class).addMember(VALUE_MEMBER, "$T.class", new Object[]{valueProvider.getTypeName()}).addMember("targetSelectors", "$S", new Object[]{sdkField.getExternalName()});
        List<Argument> arguments = this.getArgumentsFromValueProvider((ResolverExpression<ValueProviderDefinition>)sdkField.getField().getValueProvider());
        for (Argument argument : arguments) {
            annotationBuilder.addMember("bindings", "$L", new Object[]{AnnotationSpec.builder(Binding.class).addMember("actingParameter", "$S", new Object[]{SdkResolverUtil.getActingParameterJavaName(argument)}).addMember("extractionExpression", "$S", new Object[]{SdkBodyLevelUtils.transformBodyPrefix(argument.getValue().getValue(), contentParameterName)}).build()});
        }
        return annotationBuilder.build();
    }

    protected List<Argument> getArgumentsFromValueProvider(ResolverExpression<ValueProviderDefinition> valueProviderExpression) {
        if (valueProviderExpression instanceof ValueProviderDefinition) {
            ValueProviderDefinition valueProviderDefinition = (ValueProviderDefinition)valueProviderExpression;
            return this.getArgumentsFromValueProviderDefinition(valueProviderDefinition);
        }
        if (valueProviderExpression instanceof ResolverReference) {
            ResolverReference valueProviderReference = (ResolverReference)valueProviderExpression;
            return valueProviderReference.getArguments();
        }
        throw new IllegalArgumentException("Invalid valueProviderExpression. This is a bug.");
    }

    protected List<Argument> getArgumentsFromValueProviderDefinition(ValueProviderDefinition valueProviderDefinition) {
        if (valueProviderDefinition.getRequest() == null) {
            return Collections.emptyList();
        }
        HttpRequestBinding httpRequestBinding = valueProviderDefinition.getRequest().getHttpRequestBinding();
        ArrayList arguments = new ArrayList();
        if (httpRequestBinding != null) {
            arguments.addAll(httpRequestBinding.getQueryParameter());
            arguments.addAll(httpRequestBinding.getUriParameter());
            arguments.addAll(httpRequestBinding.getHeader());
        }
        return arguments.stream().filter(argument -> DataWeaveExpressionParser.isBodyBindingUsed((Argument)argument)).collect(Collectors.toList());
    }
}

