/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.templating.VelocityTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class SdkPom
extends VelocityTemplateEntity {
    private static final String POM_VM = "templates/sdk/pom.vm";
    private static final String PROPERTIES_FROM_POM_PROPERTIES = "properties-from-pom.properties";
    private static final String PROJECT_VERSION = "project_version";
    private final ConnectorModel model;
    private final String restSdkProjectVersion;

    public SdkPom(Path outputDir, ConnectorModel model) throws TemplatingException {
        super(outputDir);
        this.model = model;
        this.restSdkProjectVersion = this.buildProjectVersion();
    }

    public String getName() {
        return this.model.getConnectorName();
    }

    public String getDescription() {
        return this.model.getApiDescription();
    }

    public String getMvnGroupId() {
        return this.model.getMvnGroupId();
    }

    public String getMvnArtifactId() {
        return StringUtils.isNotBlank((CharSequence)this.model.getMvnArtifactId()) ? this.model.getMvnArtifactId() : this.model.getConnectorXmlName();
    }

    public String getMvnVersion() {
        return this.model.getMvnVersion();
    }

    public String getRestSdkProjectVersion() {
        return this.restSdkProjectVersion;
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.applyTemplate(POM_VM, this.outputDir.resolve("pom.xml"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String buildProjectVersion() throws TemplatingException {
        try (InputStream input = this.getClass().getClassLoader().getResourceAsStream(PROPERTIES_FROM_POM_PROPERTIES);){
            if (input == null) {
                throw new TemplatingException(String.format("property file '%s' not found in the classpath. This is a technical bug, to fix it try rebuilding 'rest-sdk-java-generator\u2019 module project", PROPERTIES_FROM_POM_PROPERTIES));
            }
            Properties prop = new Properties();
            prop.load(input);
            String project_version = prop.getProperty(PROJECT_VERSION);
            if (StringUtils.isBlank((CharSequence)project_version)) {
                throw new TemplatingException(String.format("the property 'PROJECT_VERSION' (under '%s') is either null or empty. This is a bug.", PROPERTIES_FROM_POM_PROPERTIES));
            }
            String string = project_version;
            return string;
        }
        catch (IOException e) {
            throw new TemplatingException(String.format("property file '%s' from the classpath could not be loaded. This is a bug.", PROPERTIES_FROM_POM_PROPERTIES), e);
        }
    }
}

