/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.operation;

import com.mulesoft.connectivity.rest.commons.api.binding.HttpRequestBinding;
import com.mulesoft.connectivity.rest.commons.api.binding.HttpResponseBinding;
import com.mulesoft.connectivity.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.error.RequestErrorTypeProvider;
import com.mulesoft.connectivity.rest.commons.api.error.RestError;
import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.rest.commons.api.operation.ConfigurationOverrides;
import com.mulesoft.connectivity.rest.commons.api.operation.RequestParameters;
import com.mulesoft.connectivity.rest.commons.internal.RestConstants;
import com.mulesoft.connectivity.rest.commons.internal.util.DwUtils;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.rest.commons.internal.util.StreamUtils;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Body;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Field;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.DataWeaveExpressionParser;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.Pagination;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.AuxiliarParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata.SampleDataDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata.SdkOutputMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata.SdkPagingMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.munit.SdkMtfOperationTest;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkAuxiliarParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkContent;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkField;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkPaginationParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverTemplate;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverUtil;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.sampledata.SdkSampleDataFactory;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.MuleAnnotationsUtils;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.SdkBodyLevelUtils;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.valueprovider.SdkValueProvidable;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Ignore;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.sdk.api.annotation.binding.Binding;
import org.mule.sdk.api.annotation.data.sample.SampleData;

public abstract class AbstractSdkOperation
extends JavaTemplateEntity
implements SdkValueProvidable {
    public static final String PARAM_DOC_NAME_DESCRIPTION = "@param $L $L\n";
    public static final String CONTENT_TYPE_HEADER_NAME = "content-type";
    public static final String ACCEPT_HEADER_NAME = "accept";
    public static final String ADD_URI_PARAM_METHOD_NAME = "addUriParam";
    public static final String ADD_QUERY_PARAM_METHOD_NAME = "addQueryParam";
    public static final String ADD_HEADER_METHOD_NAME = "addHeader";
    private static final String REQUEST_PARAMETERS_GROUP_NAME = "REQUEST_PARAMETERS_GROUP_NAME";
    private static final String CONNECTOR_OVERRIDES = "CONNECTOR_OVERRIDES";
    private static final String GET_REQUEST_BODY_DATA_TYPE_METHOD = "getRequestBodyMediaType";
    private static final String GET_RESPONSE_BODY_DATA_TYPE_METHOD = "getResponseBodyMediaType";
    private static final String QUERY_PARAM_FORMAT_FIELD = "QUERY_PARAM_FORMAT";
    public static final String OPERATION_PATH_FIELD = "OPERATION_PATH";
    private static final String BASE_MAIN_METHOD_NAME = "Main";
    protected static final String PARAMETER_BINDINGS_NAME = "parameterBindings";
    protected static final String CUSTOM_PARAMETER_BINDINGS_NAME = "customParameterBindings";
    public static final String OPERATION_CLASSNAME_SUFFIX = "Operation";
    protected final ConnectorOperation operation;
    private final SdkConnector sdkConnector;
    protected final List<SdkParameter> allUriParameters;
    protected final List<SdkParameter> allQueryParameters;
    protected final List<SdkParameter> allHeaders;
    protected final List<SdkParameter> auxParameters;
    protected final List<SdkField> allBodyFields;
    protected final SdkContent content;
    private final Optional<String> muleOutputResolver;
    protected final SdkOutputMetadataResolver outputMetadataResolver;
    protected final SdkResolverTemplate sampleDataProvider;
    private final SdkMtfOperationTest sdkMtfOperationTest;
    private static final String GET_REQUEST_BINDINGS_METHOD = "getRequestBindings";
    private static final String GET_RESPONSE_BINDINGS_METHOD = "getResponseBindings";
    private static final String PARAMETER_BINDING_LOCAL_VARIABLE = "bindings";
    private static final String ADD_URI_BINDING_METHOD = "addUriParamBinding";
    private static final String ADD_QUERY_BINDING_METHOD = "addQueryParamBinding";
    private static final String ADD_HEADER_BINDING_METHOD = "addHeaderBinding";
    private static final String ADD_BODY_BINDING_METHOD = "setBody";
    private static final String GET_REQUEST_BUILDER_WITH_BINDINGS_METHOD = "getRequestBuilderWithBindings";

    public abstract TypeName generateMethodReturn();

    public abstract CodeBlock generateOperationMethodBaseMainBody() throws TemplatingException;

    public AbstractSdkOperation(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, runConfiguration);
        this.operation = operation;
        this.sdkConnector = sdkConnector;
        this.allUriParameters = this.buildSdkParameters(outputDir, connectorModel, sdkConnector, operation.getUriParameters(), false);
        this.allQueryParameters = this.buildSdkParameters(outputDir, connectorModel, sdkConnector, operation.getQueryParameters(), true);
        this.allHeaders = this.buildSdkParameters(outputDir, connectorModel, sdkConnector, operation.getHeaders(), false);
        this.auxParameters = new ArrayList<SdkParameter>();
        List parameters = operation.getParameters().orElse(null);
        if (parameters != null) {
            this.auxParameters.addAll(this.buildSdkParameters(operation, parameters));
        }
        this.allBodyFields = this.buildSdkFields(outputDir, connectorModel, sdkConnector, operation.getBody());
        this.content = this.buildContent(outputDir, connectorModel, sdkConnector, operation);
        this.muleOutputResolver = Optional.ofNullable(StringUtils.trim((String)operation.getMuleOutputResolver()));
        this.outputMetadataResolver = this.muleOutputResolver.isPresent() ? null : this.buildOutputMetadataResolver(sdkConnector);
        this.sdkMtfOperationTest = new SdkMtfOperationTest(operation, outputDir);
        this.sampleDataProvider = this.buildSdkSampleDataProvider(operation);
    }

    private SdkResolverTemplate buildSdkSampleDataProvider(ConnectorOperation operation) {
        return SdkSampleDataFactory.getSdkSampleDataResolver(operation, this.connectorModel, this.sdkConnector, this.getJavaClassName(), this.getAllParameters(), this.outputDir, this.runConfiguration);
    }

    private List<SdkField> buildSdkFields(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, Body body) {
        ArrayList<SdkField> list = new ArrayList<SdkField>();
        if (body == null) {
            return list;
        }
        for (Field field : body.getFields()) {
            list.add(new SdkField(outputDir, connectorModel, sdkConnector, field, this, this.runConfiguration));
        }
        return list;
    }

    private List<SdkParameter> buildSdkParameters(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, List<Parameter> connectorParameters, boolean checkPaginationParameters) {
        ArrayList<SdkParameter> list = new ArrayList<SdkParameter>();
        for (Parameter parameter : connectorParameters) {
            if (checkPaginationParameters && this.isQueryParamDefinedInPagination(parameter.getExternalName())) {
                Pagination pagination = this.getPagination();
                list.add(new SdkPaginationParameter(outputDir, connectorModel, sdkConnector, this.getJavaClassName(), parameter, (JavaTemplateEntity)this, this.runConfiguration, pagination));
                continue;
            }
            list.add(new SdkParameter(outputDir, connectorModel, sdkConnector, this.getJavaClassName(), parameter, this, this.runConfiguration));
        }
        return list;
    }

    private List<SdkParameter> buildSdkParameters(ConnectorOperation operation, List<AuxiliarParameter> connectorAuxParameters) throws TemplatingException {
        ArrayList<SdkParameter> list = new ArrayList<SdkParameter>();
        if (connectorAuxParameters != null) {
            for (AuxiliarParameter parameter : connectorAuxParameters) {
                list.add(this.buildSdkParameter(parameter, operation));
            }
        }
        return list;
    }

    private SdkParameter buildSdkParameter(AuxiliarParameter auxiliarParameter, ConnectorOperation operation) throws TemplatingException {
        boolean generateContentAnnotation = Optional.ofNullable(auxiliarParameter.getMuleContent()).orElse(true);
        TypeDefinition typeDefinition = auxiliarParameter.getTypeDefinition();
        if (typeDefinition == null && auxiliarParameter.getMuleTypeResolver() == null) {
            typeDefinition = this.getTypeDefinition(auxiliarParameter.getType());
            generateContentAnnotation = Optional.ofNullable(auxiliarParameter.getMuleContent()).orElse(false);
        }
        Parameter parameter = new Parameter(auxiliarParameter.getDisplayName(), auxiliarParameter.getExternalName(), auxiliarParameter.getExternalName(), ParameterType.AUXILIAR, typeDefinition, auxiliarParameter.getMuleAlias(), auxiliarParameter.getDescription(), auxiliarParameter.isRequired() == null || auxiliarParameter.isRequired() != false, null, false, auxiliarParameter.getValueProvider(), auxiliarParameter.getMuleMetadataKeyId(), auxiliarParameter.getMuleTypeResolver(), auxiliarParameter.getMuleContent(), auxiliarParameter.getFields());
        return new SdkAuxiliarParameter(this.outputDir, this.connectorModel, this.sdkConnector, operation.getInternalName(), this.getJavaClassName(), parameter, this, this.runConfiguration, generateContentAnnotation);
    }

    private TypeDefinition getTypeDefinition(ParameterDataType parameterDataType) {
        PrimitiveTypeDefinition.PrimitiveType primitiveType;
        switch (parameterDataType) {
            case NUMBER: {
                primitiveType = PrimitiveTypeDefinition.PrimitiveType.NUMBER;
                break;
            }
            case INTEGER: {
                primitiveType = PrimitiveTypeDefinition.PrimitiveType.INTEGER;
                break;
            }
            case LONG: {
                primitiveType = PrimitiveTypeDefinition.PrimitiveType.LONG;
                break;
            }
            case STRING: {
                primitiveType = PrimitiveTypeDefinition.PrimitiveType.STRING;
                break;
            }
            case BOOLEAN: {
                primitiveType = PrimitiveTypeDefinition.PrimitiveType.BOOLEAN;
                break;
            }
            case LOCAL_DATE_TIME: {
                primitiveType = PrimitiveTypeDefinition.PrimitiveType.LOCAL_DATE_TIME;
                break;
            }
            case ZONED_DATE_TIME: {
                primitiveType = PrimitiveTypeDefinition.PrimitiveType.ZONED_DATE_TIME;
                break;
            }
            case BINARY: {
                primitiveType = PrimitiveTypeDefinition.PrimitiveType.BINARY;
                break;
            }
            default: {
                throw new IllegalArgumentException("Parameter type not supported. This is a bug.");
            }
        }
        return TypeDefinition.simplePrimitiveType((PrimitiveTypeDefinition.PrimitiveType)primitiveType);
    }

    public ConnectorOperation getOperation() {
        return this.operation;
    }

    private SdkOutputMetadataResolver buildOutputMetadataResolver(SdkConnector sdkConnector) throws TemplatingException {
        if (this.operation.getOutputMetadata() == null) {
            return null;
        }
        if (this.operation.hasPagination()) {
            return new SdkPagingMetadataResolver(this.outputDir, this.connectorModel, sdkConnector, this.operation.getInternalName(), this.operation.getOutputMetadata(), this.runConfiguration);
        }
        return new SdkOutputMetadataResolver(this.outputDir, this.connectorModel, sdkConnector, this.operation.getInternalName(), this.operation.getOutputMetadata(), "", this.runConfiguration);
    }

    protected CodeBlock toCursorProviderMapCodeBlock(String ... localVariables) {
        CodeBlock.Builder builder = CodeBlock.builder();
        for (String localVariable : localVariables) {
            builder.addStatement("$1L = $2T.resolveCursorProvider($1L)", new Object[]{localVariable, StreamUtils.class});
        }
        return builder.build();
    }

    protected SdkContent buildContent(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation) throws TemplatingException {
        if (operation.isRequestBodyBound()) {
            return null;
        }
        return operation.getInputMetadata() != null ? new SdkContent(outputDir, connectorModel, sdkConnector, operation, this, this.runConfiguration) : null;
    }

    @Override
    public String getJavaClassName() {
        return JavaUtils.getJavaUpperCamelNameFromXml((String)this.operation.getInternalName()) + OPERATION_CLASSNAME_SUFFIX;
    }

    public String getJavaBaseClassName() {
        return this.getJavaClassName() + "Base";
    }

    public String getJavaInterceptorClassName() {
        return this.getJavaClassName() + "Refinement";
    }

    protected String getJavaMethodName() {
        return JavaUtils.getJavaLowerCamelNameFromXml((String)this.operation.getInternalName());
    }

    public String getPackage() {
        return this.connectorModel.getBasePackage() + ".internal.operation";
    }

    public String getInterceptorPackage() {
        return this.getPackage() + ".refinement";
    }

    public String getBasePackage() {
        return this.getPackage() + ".base";
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        if (this.content != null) {
            this.content.applyTemplates();
        }
        if (this.hasOutput() && this.outputMetadataResolver != null) {
            this.outputMetadataResolver.applyTemplates();
        }
        for (SdkParameter sdkParameter : this.allUriParameters) {
            sdkParameter.applyTemplates();
        }
        for (SdkParameter sdkParameter : this.allQueryParameters) {
            sdkParameter.applyTemplates();
        }
        for (SdkParameter sdkParameter : this.allHeaders) {
            sdkParameter.applyTemplates();
        }
        for (SdkParameter sdkParameter : this.auxParameters) {
            sdkParameter.applyTemplates();
        }
        if (!this.runConfiguration.regenerateMode()) {
            this.sdkMtfOperationTest.applyTemplates();
        }
        if (this.sampleDataProvider != null) {
            this.sampleDataProvider.applyTemplates();
        }
        this.generateOperationImplementationLayer();
        this.generateOperationInterceptorLayer();
        this.generateOperationBaseLayer();
    }

    private MethodSpec generateGetRequestBodyDataTypeMethod() {
        return this.generateGetBodyDataTypeMethod(GET_REQUEST_BODY_DATA_TYPE_METHOD, this.getRequestBodyMediaType());
    }

    private String getRequestBodyMediaType() {
        return this.getBodyMediaType(this.getOperation().getInputMetadata());
    }

    private MethodSpec generateGetResponseBodyDataTypeMethod() {
        return this.generateGetBodyDataTypeMethod(GET_RESPONSE_BODY_DATA_TYPE_METHOD, this.getResponseBodyMediaType());
    }

    private String getResponseBodyMediaType() {
        return this.getBodyMediaType(this.getOperation().getOutputMetadata());
    }

    private String getBodyMediaType(TypeDefinition typeDefinition) {
        String result = typeDefinition != null && typeDefinition.getMediaType() != null ? typeDefinition.getMediaType().toString() : "application/json";
        return result;
    }

    private MethodSpec generateGetBodyDataTypeMethod(String name, String bodyMediaType) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(String.class).addAnnotation(Override.class);
        methodBuilder.addStatement("return \"$L\"", new Object[]{bodyMediaType});
        return methodBuilder.build();
    }

    protected void generateOperationImplementationLayer() throws TemplatingException {
        TypeSpec.Builder operationClassBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ClassName.get((String)this.getInterceptorPackage(), (String)this.getJavaInterceptorClassName(), (String[])new String[0])).addJavadoc("Lower part of the Operation. It has the operation declaration with its annotations.", new Object[0]).addMethod(this.generateOperationImplementationMethod());
        this.defineConstructors(operationClassBuilder);
        this.configureClassBuilder(operationClassBuilder);
        JavaFile.Builder javaFileBuilder = JavaFile.builder((String)this.getPackage(), (TypeSpec)operationClassBuilder.build()).skipJavaLangImports(true).addStaticImport(RestConstants.class, new String[]{REQUEST_PARAMETERS_GROUP_NAME, CONNECTOR_OVERRIDES});
        this.configureJavaFileBuilder(javaFileBuilder);
        this.writeJavaFile(javaFileBuilder.build());
    }

    protected void generateOperationInterceptorLayer() throws TemplatingException {
        TypeSpec.Builder operationClassBuilder = TypeSpec.classBuilder((String)this.getJavaInterceptorClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Middle part of the Operation. Can be used by the user to add custom code into the operation.", new Object[0]).superclass((TypeName)ClassName.get((String)this.getBasePackage(), (String)this.getJavaBaseClassName(), (String[])new String[0]));
        this.defineConstructors(operationClassBuilder);
        this.configureClassBuilder(operationClassBuilder);
        JavaFile.Builder javaFileBuilder = JavaFile.builder((String)this.getInterceptorPackage(), (TypeSpec)operationClassBuilder.build()).skipJavaLangImports(true);
        this.configureJavaFileBuilder(javaFileBuilder);
        this.writeJavaFile(javaFileBuilder.build(), true, this.operation.isRefined());
    }

    protected void generateOperationMethodsFlow(TypeSpec.Builder operationClassBuilder) throws TemplatingException {
        operationClassBuilder.addMethod(this.generateBaseMainMethod());
    }

    protected void generateOperationBaseLayer() throws TemplatingException {
        MethodSpec operationMethod = this.generateOperationBaseMethod();
        TypeSpec.Builder operationClassBuilder = TypeSpec.classBuilder((String)this.getJavaBaseClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.ABSTRACT}).superclass(this.getSuperclass()).addJavadoc("Higher part of the Operation. It has the implementation of the operation.", new Object[0]).addMethod(operationMethod);
        this.defineConstructors(operationClassBuilder);
        operationClassBuilder.addField(this.generateOperationPathField());
        operationClassBuilder.addField(this.generateQueryParamFormatField());
        this.generateOperationMethodsFlow(operationClassBuilder);
        operationClassBuilder.addMethod(this.generateGetRequestBodyDataTypeMethod());
        operationClassBuilder.addMethod(this.generateGetResponseBodyDataTypeMethod());
        operationClassBuilder.addMethod(this.generateRequestBindingsMethod());
        operationClassBuilder.addMethod(this.generateResponseBindingsMethod());
        this.configureClassBuilder(operationClassBuilder);
        JavaFile.Builder javaFileBuilder = JavaFile.builder((String)this.getBasePackage(), (TypeSpec)operationClassBuilder.build()).skipJavaLangImports(true);
        this.configureJavaFileBuilder(javaFileBuilder);
        this.writeJavaFile(javaFileBuilder.build());
    }

    private void defineConstructors(TypeSpec.Builder operationClassBuilder) {
        Arrays.stream(this.getSuperclass().getDeclaredConstructors()).forEach(constructor -> {
            MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
            StringBuilder methodStatement = new StringBuilder("super(");
            for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
                Class<?> parameterType = constructor.getParameterTypes()[i];
                String name = "arg" + i;
                constructorBuilder.addParameter(parameterType, name, new Modifier[0]);
                if (i > 0) {
                    methodStatement.append(", ");
                }
                methodStatement.append(name);
            }
            methodStatement.append(")");
            constructorBuilder.addStatement(methodStatement.toString(), new Object[0]);
            operationClassBuilder.addMethod(constructorBuilder.build());
        });
    }

    protected void configureJavaFileBuilder(JavaFile.Builder javaFileBuilder) {
    }

    protected void configureClassBuilder(TypeSpec.Builder operationClassBuilder) {
    }

    protected Class<? extends BaseRestOperation> getSuperclass() {
        return BaseRestOperation.class;
    }

    private FieldSpec generateQueryParamFormatField() {
        return FieldSpec.builder(RestRequestBuilder.ParameterArrayFormat.class, (String)QUERY_PARAM_FORMAT_FIELD, (Modifier[])new Modifier[]{Modifier.PROTECTED, Modifier.FINAL, Modifier.STATIC}).initializer("$T.$L", new Object[]{RestRequestBuilder.ParameterArrayFormat.class, this.operation.getQueryParamArrayFormat().name()}).build();
    }

    private FieldSpec generateOperationPathField() {
        return FieldSpec.builder(String.class, (String)OPERATION_PATH_FIELD, (Modifier[])new Modifier[]{Modifier.PROTECTED, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{this.operation.getPath()}).build();
    }

    private AnnotationSpec generateDescriptionAnnotation() {
        return AnnotationSpec.builder(Summary.class).addMember("value", "$S", new Object[]{JavaUtils.abbreviateText((String)this.operation.getDescription())}).build();
    }

    private CodeBlock.Builder generateJavadoc() {
        return CodeBlock.builder().add("\n$L\n", new Object[]{StringUtils.defaultIfEmpty((CharSequence)this.operation.getDescription(), (CharSequence)this.operation.getDisplayName())}).add("\nThis operation makes an HTTP $L request to the $L endpoint", new Object[]{this.operation.getHttpMethod().name().toUpperCase(), this.operation.getPath()}).add("\n", new Object[0]);
    }

    private void addAnnotations(MethodSpec.Builder methodBuilder) {
        methodBuilder.addAnnotation(this.generateThrowsAnnotation());
        methodBuilder.addAnnotation(this.generateDisplayNameAnnotation());
        if (this.operation.isSidecar()) {
            methodBuilder.addAnnotation(this.generateSidecarAnnotation());
        }
        if (StringUtils.isNotBlank((CharSequence)this.operation.getDescription())) {
            methodBuilder.addAnnotation(this.generateDescriptionAnnotation());
        }
        if (StringUtils.isNotBlank((CharSequence)this.operation.getAlias())) {
            methodBuilder.addAnnotation(this.generateAliasAnnotation());
        }
        if (this.sampleDataProvider != null) {
            methodBuilder.addAnnotation(this.generateSampleDataAnnotation());
        }
        if (this.requiresMediaTypeAnnotation()) {
            if (this.operation.getOutputMetadata() != null) {
                methodBuilder.addAnnotation(this.generateMediaTypeAnnotation());
            } else {
                methodBuilder.addAnnotation(this.generateDefaultMediaTypeAnnotation());
            }
        }
        if (this.hasOutput()) {
            methodBuilder.addAnnotation(this.getOutputResolverAnnotation());
        }
    }

    protected Pair<List<ParameterSpec>, CodeBlock.Builder> generateOperationImplementationMethodParameters() {
        return AbstractSdkOperation.builder().withAnnotations().configurationParameter().connectionParameter().uriParameters(this.allUriParameters).queryParameters(this.generateQueryParameters()).headerParameters(this.allHeaders).auxParameters(this.auxParameters).contentParameter(this.generateContentParameters(true)).requestParameter().configurationOverridesParameter().callbackParameter(this.getMessageOutputType()).parametersSpecList();
    }

    public MethodSpec generateOperationImplementationMethod() throws TemplatingException {
        CodeBlock.Builder javaDoc = this.generateJavadoc();
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)this.getJavaMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        Pair<List<ParameterSpec>, CodeBlock.Builder> parameters = this.generateOperationImplementationMethodParameters();
        methodBuilder.addParameters((Iterable)parameters.getLeft());
        javaDoc.add(((CodeBlock.Builder)parameters.getRight()).build());
        this.addAnnotations(methodBuilder);
        TypeName returnType = this.generateMethodReturn();
        methodBuilder.addCode(this.generateOperationImplementationMethodBody(methodBuilder.parameters, returnType));
        methodBuilder.addJavadoc(javaDoc.build());
        if (returnType != null) {
            methodBuilder.returns(returnType);
        }
        return methodBuilder.build();
    }

    protected List<String> generateOperationMainCallParameters() {
        return ((List)AbstractSdkOperation.builder().configurationParameter().connectionParameter().uriParameters(this.allUriParameters).queryParameters(this.generateQueryParameters()).headerParameters(this.allHeaders).auxParameters(this.auxParameters).customParameterBinding().contentParameter(this.generateContentParameters(false)).requestParameter().configurationOverridesParameter().callbackParameter(this.getMessageOutputType()).parametersSpecList().getLeft()).stream().map(x -> x.name).collect(Collectors.toList());
    }

    public CodeBlock generateOperationMainCall(TypeName returnType) {
        CodeBlock.Builder builder = CodeBlock.builder();
        String returnSentence = "";
        if (returnType != null) {
            returnSentence = "return";
        }
        List<String> params = this.generateOperationMainCallParameters();
        builder.addStatement("$L $L($L)", new Object[]{returnSentence, this.getBaseMainMethodName(), params.stream().collect(Collectors.joining(", "))});
        return builder.build();
    }

    protected MethodSpec generateOperationBaseMethod() throws TemplatingException {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)this.getJavaMethodName()).addModifiers(new Modifier[]{Modifier.PROTECTED});
        ParametersBuilder parameters = AbstractSdkOperation.builder().configurationParameter().connectionParameter().uriParameters(this.allUriParameters).queryParameters(this.generateQueryParameters()).headerParameters(this.allHeaders).auxParameters(this.auxParameters).contentParameter(this.generateContentParameters(false)).requestParameter().configurationOverridesParameter().callbackParameter(this.getMessageOutputType());
        methodBuilder.addParameters((Iterable)parameters.parametersSpecList().getLeft());
        TypeName returnType = this.generateMethodReturn();
        this.generateTryStatement(methodBuilder, true);
        methodBuilder.addStatement("$1T<$2T,$3T> $4L = new $5T<>()", new Object[]{Map.class, String.class, Object.class, CUSTOM_PARAMETER_BINDINGS_NAME, HashMap.class});
        methodBuilder.addCode(this.generateOperationMainCall(returnType));
        this.generateTryStatement(methodBuilder, false);
        this.generateCatchStatement(ModuleException.class, "callback.error(e);", methodBuilder, new Object[0]);
        this.generateCatchStatement(Throwable.class, "callback.error(new $1T(\"Unknown error\", $2T.CONNECTIVITY, e));", methodBuilder, ModuleException.class, RestError.CONNECTIVITY.getClass());
        if (returnType != null) {
            methodBuilder.returns(returnType);
        }
        return methodBuilder.build();
    }

    protected Pair<List<ParameterSpec>, CodeBlock.Builder> generateContentParameters(boolean withAnnotations) {
        if (this.content != null) {
            final ParameterSpec parameterSpec = this.content.generateContentParameter(withAnnotations);
            return new ImmutablePair((Object)new ArrayList<ParameterSpec>(){
                {
                    this.add(parameterSpec);
                }
            }, (Object)CodeBlock.builder().add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameterSpec.name, "the content to use"}));
        }
        return null;
    }

    private AnnotationSpec getOutputResolverAnnotation() {
        AnnotationSpec.Builder builder = AnnotationSpec.builder(OutputResolver.class);
        if (this.outputMetadataResolver != null && this.outputMetadataResolver.getRequiresMetadataResolver()) {
            builder.addMember("output", "$T.class", new Object[]{ClassName.get((String)this.outputMetadataResolver.getPackage(), (String)this.outputMetadataResolver.getClassName(), (String[])new String[0])});
        } else if (this.muleOutputResolver.isPresent()) {
            ClassName className = MuleAnnotationsUtils.getClassName(this.muleOutputResolver.get());
            builder.addMember("output", "$T.class", new Object[]{className});
        }
        this.addOutputAttributesMetadataResolver(builder);
        return builder.build();
    }

    private void addOutputAttributesMetadataResolver(AnnotationSpec.Builder builder) {
        builder.addMember("attributes", "$T.class", new Object[]{this.sdkConnector.getOutputAttributesResolver()});
    }

    private Pagination getPagination() {
        return this.operation.getPagination();
    }

    protected boolean isQueryParamDefinedInPagination(String paramName) {
        Pagination pagination = this.getPagination();
        if (pagination != null && pagination.getPaginationParameter() != null) {
            return pagination.getPaginationParameter().equalsIgnoreCase(paramName);
        }
        return false;
    }

    private AnnotationSpec generateDisplayNameAnnotation() {
        return AnnotationSpec.builder(DisplayName.class).addMember("value", "$S", new Object[]{this.operation.getDisplayName()}).build();
    }

    private AnnotationSpec generateAliasAnnotation() {
        return AnnotationSpec.builder(Alias.class).addMember("value", "$S", new Object[]{this.operation.getAlias()}).build();
    }

    private AnnotationSpec generateSidecarAnnotation() {
        return AnnotationSpec.builder(Ignore.class).build();
    }

    public CodeBlock generateOperationImplementationMethodBody(List<ParameterSpec> parameters, TypeName typeName) throws TemplatingException {
        CodeBlock.Builder builder = CodeBlock.builder();
        String returnSentence = "";
        if (typeName != null) {
            returnSentence = "return";
        }
        builder.addStatement("$L super.$L($L)", new Object[]{returnSentence, this.getJavaMethodName(), parameters.stream().map(param -> param.name).collect(Collectors.joining(", "))});
        return builder.build();
    }

    protected void generateTryStatement(MethodSpec.Builder methodBody, boolean start) {
        if (start) {
            methodBody.addCode("try {", new Object[0]);
        } else {
            methodBody.addCode("}", new Object[0]);
        }
    }

    protected void generateCatchStatement(Class exception, String codeBlock, MethodSpec.Builder methodBody, Object ... args) {
        methodBody.addCode("$1L ($2T e) {", new Object[]{"catch", exception});
        methodBody.addCode(codeBlock, args);
        methodBody.addCode("}", new Object[0]);
    }

    private String getBaseUriString() {
        String baseUriString = "connection.getBaseUri()";
        if (StringUtils.isNotBlank((CharSequence)this.operation.getAlternativeBaseUri()) && this.connectorModel.getBaseUri().isMultipleBaseUri()) {
            String multipleBaseUri = this.connectorModel.getBaseUri().getMultipleBaseUriOrDefault(this.operation.getAlternativeBaseUri());
            baseUriString = "\"" + multipleBaseUri + "\"";
        }
        return baseUriString;
    }

    public CodeBlock generateRestRequestBuilder() {
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.add(this.generateRestRequestBuilderInitialization(this.getBaseUriString()));
        builder.add(".setQueryParamFormat($L)", new Object[]{QUERY_PARAM_FORMAT_FIELD});
        if (this.connectorModel.getInterceptors() != null && this.connectorModel.getInterceptors().size() > 0) {
            builder.add(".$L($L($L))", new Object[]{"responseInterceptorDescriptor", "getResponseInterceptorDescriptor", "config"});
        }
        if (this.operation.getInputMetadata() != null && this.operation.getInputMetadata().getMediaType() != null) {
            this.addContentTypeHeader(builder);
        }
        if (this.operation.getOutputMetadata() != null && this.operation.getOutputMetadata().getMediaType() != null) {
            builder.add(".$L($S, $S)", new Object[]{ADD_HEADER_METHOD_NAME, ACCEPT_HEADER_NAME, this.operation.getOutputMetadata().getMediaType().toString()});
        }
        for (SdkParameter uriParameter : this.allUriParameters) {
            builder.add(this.generateRequestBuilderParameterCodeBlock(uriParameter, ADD_URI_PARAM_METHOD_NAME));
        }
        for (SdkParameter queryParam : this.allQueryParameters) {
            if (this.isQueryParamDefinedInPagination(queryParam.getExternalName())) continue;
            builder.add(this.generateRequestBuilderParameterCodeBlock(queryParam, ADD_QUERY_PARAM_METHOD_NAME));
        }
        for (SdkParameter header : this.allHeaders) {
            builder.add(this.generateRequestBuilderParameterCodeBlock(header, ADD_HEADER_METHOD_NAME));
        }
        this.addSetBodyMethod(builder);
        builder.add(";", new Object[0]);
        return builder.build();
    }

    private void addContentTypeHeader(CodeBlock.Builder methodBody) {
        javax.ws.rs.core.MediaType contentType = this.operation.getInputMetadata().getMediaType();
        if (this.operation.getInputMetadata().getMediaType().equals((Object)javax.ws.rs.core.MediaType.MULTIPART_FORM_DATA_TYPE)) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("boundary", "__rc2_34b212");
            Optional optionalBodyExpression = this.operation.getRequestBindings().flatMap(requestBindings -> requestBindings.stream().filter(bindings -> bindings.getParameterType().equals((Object)ParameterType.BODY)).filter(bindings -> DwUtils.isExpression((String)bindings.getExpression().trim())).map(bindings -> bindings.getExpression()).findFirst());
            if (optionalBodyExpression.isPresent()) {
                String bodyExpression = (String)optionalBodyExpression.get();
                javax.ws.rs.core.MediaType outputMediaType = (javax.ws.rs.core.MediaType)DataWeaveExpressionParser.getOutputMediaType((String)bodyExpression).orElseThrow(() -> new IllegalStateException(String.format("There should be an output directive declaring the mimeType multipart for the body expression for operation ['%s']. This is a bug. Expression: %s", this.operation.getInternalName(), bodyExpression)));
                if (!this.operation.getInputMetadata().getMediaType().isCompatible(outputMediaType)) {
                    throw new IllegalStateException(String.format("Operation ['%s'] defines a body expression with an output mimeType '%s' which is not compatible with the input operation mimeType '%s'. This is a bug", this.operation.getInternalName(), outputMediaType, this.operation.getInputMetadata().getMediaType()));
                }
                if (!outputMediaType.getParameters().containsKey("boundary")) {
                    throw new IllegalStateException(String.format("Operation ['%s'] defines a body expression with an output mimeType '%s' without the boundary parameter. This is a bug", this.operation.getInternalName(), outputMediaType));
                }
                parameters.putAll(outputMediaType.getParameters());
            }
            contentType = new javax.ws.rs.core.MediaType(contentType.getType(), contentType.getSubtype(), parameters);
        }
        methodBody.add(".$L($S, $S)", new Object[]{ADD_HEADER_METHOD_NAME, CONTENT_TYPE_HEADER_NAME, org.mule.runtime.api.metadata.MediaType.parse((String)contentType.toString()).toRfcString()});
    }

    private CodeBlock generateRestRequestBuilderInitialization(String baseUriString) {
        CodeBlock.Builder builder = CodeBlock.builder();
        ParametersBuilder parameters = AbstractSdkOperation.builder();
        parameters.requestParameter();
        parameters.configurationOverridesParameter();
        parameters.connectionParameter();
        parameters.configurationParameter();
        parameters.parameterBinding();
        parameters.customParameterBinding();
        builder.add("$T builder = $L($L, $L, $T.$L, " + ((List)parameters.parametersSpecList().getLeft()).stream().map(x -> x.name).collect(Collectors.joining(", ")) + ")", new Object[]{RestRequestBuilder.class, GET_REQUEST_BUILDER_WITH_BINDINGS_METHOD, baseUriString, OPERATION_PATH_FIELD, HttpConstants.Method.class, this.operation.getHttpMethod().name().toUpperCase()});
        return builder.build();
    }

    protected void addSetBodyMethod(CodeBlock.Builder methodBody) {
        if (this.content != null) {
            methodBody.add(".setBody($L, overrides.getStreamingType())", new Object[]{this.content.getContentParameterJavaName()});
        }
    }

    private CodeBlock generateRequestBuilderParameterCodeBlock(SdkParameter parameter, String addSingleValueMethodName) {
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.add(".$L($S, $L)", new Object[]{addSingleValueMethodName, parameter.getExternalName(), this.getParameterValueStatement(parameter)});
        return builder.build();
    }

    protected CodeBlock getParameterValueStatement(SdkParameter parameter) {
        CodeBlock.Builder builder = CodeBlock.builder();
        if (parameter.isArrayType()) {
            CodeBlock getter = parameter.getInnerTypeStringValueGetter("v");
            if (getter.toString().equalsIgnoreCase("v")) {
                builder.add("$L.stream().filter($T::nonNull).collect($T.toList())", new Object[]{parameter.getJavaName(), Objects.class, Collectors.class});
            } else {
                builder.add("$L.stream().filter($T::nonNull).map(v -> $L).collect($T.toList())", new Object[]{parameter.getJavaName(), Objects.class, getter, Collectors.class});
            }
        } else {
            builder.add("$L", new Object[]{parameter.getStringValueGetter()});
        }
        return builder.build();
    }

    private AnnotationSpec generateThrowsAnnotation() {
        return AnnotationSpec.builder(Throws.class).addMember("value", "$T.class", new Object[]{RequestErrorTypeProvider.class}).build();
    }

    private AnnotationSpec generateMediaTypeAnnotation() {
        return AnnotationSpec.builder(MediaType.class).addMember("value", "$S", new Object[]{this.operation.getOutputMetadata().getMediaType()}).build();
    }

    private AnnotationSpec generateSampleDataAnnotation() {
        SampleDataDefinition sampleDataDefinition;
        HttpRequestDataExpression result;
        AnnotationSpec.Builder annotationBuilder = AnnotationSpec.builder(SampleData.class).addMember("value", "$T.class", new Object[]{this.sampleDataProvider.getTypeName()});
        if (this.operation.getSampleData() instanceof ResolverReference) {
            ResolverReference sampleDataDefinitionReferenceResolver = (ResolverReference)this.operation.getSampleData();
            this.addBindingAnnotation(annotationBuilder, sampleDataDefinitionReferenceResolver.getArguments());
        } else if (this.operation.getSampleData() instanceof SampleDataDefinition && (result = (sampleDataDefinition = (SampleDataDefinition)this.operation.getSampleData()).getResult()) != null && result.getHttpRequestBinding() != null) {
            List<Argument> arguments = Stream.of(result.getHttpRequestBinding().getHeader(), result.getHttpRequestBinding().getQueryParameter(), result.getHttpRequestBinding().getUriParameter()).flatMap(argumentList -> argumentList.stream()).collect(Collectors.toList());
            this.addBindingAnnotation(annotationBuilder, arguments);
        }
        return annotationBuilder.build();
    }

    private void addBindingAnnotation(AnnotationSpec.Builder annotationBuilder, List<Argument> arguments) {
        for (Argument argument : arguments) {
            if (!DataWeaveExpressionParser.isBodyBindingUsed((Argument)argument)) continue;
            annotationBuilder.addMember(PARAMETER_BINDING_LOCAL_VARIABLE, "$L", new Object[]{AnnotationSpec.builder(Binding.class).addMember("actingParameter", "$S", new Object[]{SdkResolverUtil.getActingParameterJavaName(argument)}).addMember("extractionExpression", "$S", new Object[]{SdkBodyLevelUtils.transformBodyPrefix(argument.getValue().getValue(), this.content.getContentParameterJavaName())}).build()});
        }
    }

    private AnnotationSpec generateDefaultMediaTypeAnnotation() {
        return AnnotationSpec.builder(MediaType.class).addMember("value", "$S", new Object[]{this.operationMethodRequiresBody() ? "application/json" : "text/plain"}).build();
    }

    protected MessageOutputType getMessageOutputType() {
        if (this.hasOutput()) {
            return new MessageOutputType(InputStream.class, Object.class);
        }
        return new MessageOutputType(Void.class, Void.class);
    }

    protected boolean operationMethodRequiresBody() {
        return this.operation.getHttpMethod().equals((Object)HTTPMethod.GET) || this.operation.getHttpMethod().equals((Object)HTTPMethod.POST) || this.operation.getHttpMethod().equals((Object)HTTPMethod.PATCH) || this.operation.getHttpMethod().equals((Object)HTTPMethod.OPTIONS);
    }

    protected boolean isVoidOperation() {
        return this.operation.getVoidOperation() != null && this.operation.getVoidOperation() != false;
    }

    protected boolean requiresMediaTypeAnnotation() {
        return this.hasOutput();
    }

    protected boolean hasOutput() {
        return !this.isVoidOperation() && (this.outputMetadataResolver != null || this.operationMethodRequiresBody());
    }

    @Override
    public List<SdkParameter> getAllParameters() {
        ArrayList<SdkParameter> allParameters = new ArrayList<SdkParameter>();
        allParameters.addAll(this.allUriParameters);
        allParameters.addAll(this.allQueryParameters);
        allParameters.addAll(this.allHeaders);
        allParameters.addAll(this.auxParameters);
        return allParameters;
    }

    public List<SdkField> getAllBodyFields() {
        return this.allBodyFields;
    }

    public ConnectorOperation getConnectorOperation() {
        return this.operation;
    }

    protected List<SdkParameter> generateQueryParameters() {
        return this.allQueryParameters;
    }

    protected CodeBlock generateAuxParameterBindings() {
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.addStatement("$1T<$2T,$3T> $4L = new $5T<>()", new Object[]{Map.class, String.class, Object.class, PARAMETER_BINDINGS_NAME, HashMap.class});
        for (SdkParameter parameter : this.auxParameters) {
            builder.addStatement("$L.$L($S, $L)", new Object[]{PARAMETER_BINDINGS_NAME, "put", parameter.getExternalName(), parameter.getJavaName()});
        }
        return builder.build();
    }

    private String getBaseMainMethodName() {
        return this.getJavaMethodName() + BASE_MAIN_METHOD_NAME;
    }

    protected ParametersBuilder generateBaseMainMethodParameters() {
        return AbstractSdkOperation.builder().configurationParameter().connectionParameter().uriParameters(this.allUriParameters).queryParameters(this.generateQueryParameters()).headerParameters(this.allHeaders).auxParameters(this.auxParameters).customParameterBinding().contentParameter(this.generateContentParameters(false)).requestParameter().configurationOverridesParameter().callbackParameter(this.getMessageOutputType());
    }

    protected MethodSpec generateBaseMainMethod() throws TemplatingException {
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)this.getBaseMainMethodName()).addModifiers(new Modifier[]{Modifier.PROTECTED});
        methodSpecBuilder.addParameters((Iterable)this.generateBaseMainMethodParameters().parametersSpecList().getLeft());
        methodSpecBuilder.addCode(this.generateOperationMethodBaseMainBody());
        TypeName returnType = this.generateMethodReturn();
        if (returnType != null) {
            methodSpecBuilder.returns(returnType);
        }
        return methodSpecBuilder.build();
    }

    private MethodSpec generateRequestBindingsMethod() {
        return this.generateRequestBindingMethod(GET_REQUEST_BINDINGS_METHOD, HttpRequestBinding.class, this.operation.getRequestBindings().orElse(null));
    }

    private MethodSpec generateResponseBindingsMethod() {
        return this.generateRequestBindingMethod(GET_RESPONSE_BINDINGS_METHOD, HttpResponseBinding.class, this.operation.getResponseBindings().orElse(null));
    }

    private MethodSpec generateRequestBindingMethod(String methodName, Class<?> builderClass, List<ParameterBinding> parameterBindings) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(builderClass).addAnnotation(Override.class);
        methodBuilder.addStatement("$1T $2L = new $1T()", new Object[]{builderClass, PARAMETER_BINDING_LOCAL_VARIABLE});
        if (parameterBindings != null) {
            for (ParameterBinding binding : parameterBindings) {
                if (binding.isIgnored() || binding.getExpression() == null) continue;
                if (binding.getParameterType().equals((Object)ParameterType.BODY)) {
                    methodBuilder.addStatement("$L.$L($S)", new Object[]{PARAMETER_BINDING_LOCAL_VARIABLE, ADD_BODY_BINDING_METHOD, binding.getExpression().trim()});
                    continue;
                }
                methodBuilder.addStatement("$L.$L($S, $S)", new Object[]{PARAMETER_BINDING_LOCAL_VARIABLE, this.getParameterBindingAddMethodName(binding), binding.getName(), binding.getExpression().trim()});
            }
        }
        methodBuilder.addStatement("return $1L", new Object[]{PARAMETER_BINDING_LOCAL_VARIABLE});
        return methodBuilder.build();
    }

    private String getParameterBindingAddMethodName(ParameterBinding binding) {
        switch (binding.getParameterType()) {
            case QUERY: {
                return ADD_QUERY_BINDING_METHOD;
            }
            case HEADER: {
                return ADD_HEADER_BINDING_METHOD;
            }
            case URI: {
                return ADD_URI_BINDING_METHOD;
            }
        }
        throw new IllegalArgumentException(String.format("Parameter type not supported: '%s'. This is a bug.", binding.getParameterType()));
    }

    protected static ParametersBuilder builder() {
        return new ParametersBuilder();
    }

    public static class ParametersBuilder {
        private boolean withAnnotations = false;
        private Pair<ParameterSpec, CodeBlock.Builder> configuration;
        private Pair<ParameterSpec, CodeBlock.Builder> connection;
        private Pair<List<ParameterSpec>, CodeBlock.Builder> uriParameters;
        private Pair<List<ParameterSpec>, CodeBlock.Builder> queryParameters;
        private Pair<List<ParameterSpec>, CodeBlock.Builder> headerParameters;
        private Pair<List<ParameterSpec>, CodeBlock.Builder> auxParameters;
        private Pair<ParameterSpec, CodeBlock.Builder> parameterBinding;
        private Pair<List<ParameterSpec>, CodeBlock.Builder> contentParameter;
        private Pair<ParameterSpec, CodeBlock.Builder> requestParameter;
        private Pair<ParameterSpec, CodeBlock.Builder> configurationOverridesParameter;
        private Pair<ParameterSpec, CodeBlock.Builder> callbackParameter;
        private List<ParameterSpec> finalParameters = new ArrayList<ParameterSpec>();
        private CodeBlock.Builder javaDoc = CodeBlock.builder();
        private Pair<ParameterSpec, CodeBlock.Builder> customParameterBinding;

        public ParametersBuilder withAnnotations() {
            this.withAnnotations = true;
            return this;
        }

        public ParametersBuilder configurationParameter() {
            ParameterSpec.Builder parameterSpecBuilder = ParameterSpec.builder(RestConfiguration.class, (String)"config", (Modifier[])new Modifier[0]);
            if (this.withAnnotations) {
                parameterSpecBuilder.addAnnotation(Config.class);
            }
            ParameterSpec configParameter = parameterSpecBuilder.build();
            this.configuration = new ImmutablePair((Object)configParameter, (Object)CodeBlock.builder().add(AbstractSdkOperation.PARAM_DOC_NAME_DESCRIPTION, new Object[]{configParameter.name, "the configuration to use"}));
            this.finalParameters.add(configParameter);
            this.javaDoc.add(((CodeBlock.Builder)this.configuration.getRight()).build());
            return this;
        }

        public ParametersBuilder connectionParameter() {
            ParameterSpec.Builder parameterSpecBuilder = ParameterSpec.builder(RestConnection.class, (String)"connection", (Modifier[])new Modifier[0]);
            if (this.withAnnotations) {
                parameterSpecBuilder.addAnnotation(Connection.class);
            }
            ParameterSpec connectionParameter = parameterSpecBuilder.build();
            this.connection = new ImmutablePair((Object)connectionParameter, (Object)CodeBlock.builder().add(AbstractSdkOperation.PARAM_DOC_NAME_DESCRIPTION, new Object[]{connectionParameter.name, "the connection to use"}));
            this.finalParameters.add(connectionParameter);
            this.javaDoc.add(((CodeBlock.Builder)this.connection.getRight()).build());
            return this;
        }

        public ParametersBuilder uriParameters(List<SdkParameter> allUriParameters) {
            CodeBlock.Builder javaDoc = CodeBlock.builder();
            ArrayList<ParameterSpec> parameterSpecs = new ArrayList<ParameterSpec>();
            for (SdkParameter sdkParam : allUriParameters) {
                ParameterSpec parameterSpec = sdkParam.generateParameterParameter(this.withAnnotations).build();
                javaDoc.add(AbstractSdkOperation.PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameterSpec.name, StringUtils.defaultIfEmpty((CharSequence)sdkParam.getDescription(), (CharSequence)sdkParam.getDisplayName())});
                parameterSpecs.add(parameterSpec);
            }
            this.uriParameters = new ImmutablePair(parameterSpecs, (Object)javaDoc);
            this.finalParameters.addAll(parameterSpecs);
            this.javaDoc.add(((CodeBlock.Builder)this.uriParameters.getRight()).build());
            return this;
        }

        public ParametersBuilder queryParameters(List<SdkParameter> allQueryParameters) {
            CodeBlock.Builder javaDoc = CodeBlock.builder();
            ArrayList<ParameterSpec> parameterSpecs = new ArrayList<ParameterSpec>();
            for (SdkParameter sdkParam : allQueryParameters) {
                ParameterSpec parameterSpec = sdkParam.generateParameterParameter(this.withAnnotations).build();
                javaDoc.add(AbstractSdkOperation.PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameterSpec.name, StringUtils.defaultIfEmpty((CharSequence)sdkParam.getDescription(), (CharSequence)sdkParam.getDisplayName())});
                parameterSpecs.add(parameterSpec);
            }
            this.queryParameters = new ImmutablePair(parameterSpecs, (Object)javaDoc);
            this.finalParameters.addAll(parameterSpecs);
            this.javaDoc.add(((CodeBlock.Builder)this.queryParameters.getRight()).build());
            return this;
        }

        public ParametersBuilder headerParameters(List<SdkParameter> allHeaders) {
            CodeBlock.Builder javaDoc = CodeBlock.builder();
            ArrayList<ParameterSpec> parameterSpecs = new ArrayList<ParameterSpec>();
            for (SdkParameter sdkParam : allHeaders) {
                ParameterSpec parameterSpec = sdkParam.generateParameterParameter(this.withAnnotations).build();
                javaDoc.add(AbstractSdkOperation.PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameterSpec.name, StringUtils.defaultIfEmpty((CharSequence)sdkParam.getDescription(), (CharSequence)sdkParam.getDisplayName())});
                parameterSpecs.add(parameterSpec);
            }
            this.headerParameters = new ImmutablePair(parameterSpecs, (Object)javaDoc);
            this.finalParameters.addAll(parameterSpecs);
            this.javaDoc.add(((CodeBlock.Builder)this.headerParameters.getRight()).build());
            return this;
        }

        public ParametersBuilder auxParameters(List<SdkParameter> auxParameters) {
            CodeBlock.Builder javaDoc = CodeBlock.builder();
            ArrayList<ParameterSpec> parameterSpecs = new ArrayList<ParameterSpec>();
            for (SdkParameter sdkParam : auxParameters) {
                ParameterSpec parameterSpec = sdkParam.generateParameterParameter(this.withAnnotations).build();
                javaDoc.add(AbstractSdkOperation.PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameterSpec.name, StringUtils.defaultIfEmpty((CharSequence)sdkParam.getDescription(), (CharSequence)sdkParam.getDisplayName())});
                parameterSpecs.add(parameterSpec);
            }
            this.auxParameters = new ImmutablePair(parameterSpecs, (Object)javaDoc);
            this.finalParameters.addAll(parameterSpecs);
            this.javaDoc.add(((CodeBlock.Builder)this.auxParameters.getRight()).build());
            return this;
        }

        public ParametersBuilder parameterBinding() {
            ParameterSpec.Builder parameterBindingsSpec = ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{TypeName.get(String.class), TypeName.get(Object.class)}), (String)AbstractSdkOperation.PARAMETER_BINDINGS_NAME, (Modifier[])new Modifier[0]);
            ParameterSpec parameterSpec = parameterBindingsSpec.build();
            this.parameterBinding = new ImmutablePair((Object)parameterSpec, (Object)CodeBlock.builder().add(AbstractSdkOperation.PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameterSpec.name, "Map that contains auxiliary parameters defined in operation"}));
            this.finalParameters.add(parameterSpec);
            this.javaDoc.add(((CodeBlock.Builder)this.parameterBinding.getRight()).build());
            return this;
        }

        public ParametersBuilder customParameterBinding() {
            ParameterSpec.Builder parameterBindingsSpec = ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{TypeName.get(String.class), TypeName.get(Object.class)}), (String)AbstractSdkOperation.CUSTOM_PARAMETER_BINDINGS_NAME, (Modifier[])new Modifier[0]);
            ParameterSpec parameterSpec = parameterBindingsSpec.build();
            this.customParameterBinding = new ImmutablePair((Object)parameterSpec, (Object)CodeBlock.builder().add(AbstractSdkOperation.PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameterSpec.name, "Map that contains custom parameters defined in operation customization"}));
            this.finalParameters.add(parameterSpec);
            this.javaDoc.add(((CodeBlock.Builder)this.customParameterBinding.getRight()).build());
            return this;
        }

        public ParametersBuilder contentParameter(Pair<List<ParameterSpec>, CodeBlock.Builder> parameters) {
            if (parameters != null) {
                this.contentParameter = new ImmutablePair(parameters.getLeft(), (Object)CodeBlock.builder().add(((CodeBlock.Builder)parameters.getRight()).build()));
                this.finalParameters.addAll((Collection)parameters.getLeft());
                this.javaDoc.add(((CodeBlock.Builder)this.contentParameter.getRight()).build());
            }
            return this;
        }

        public ParametersBuilder requestParameter() {
            ParameterSpec.Builder parameterSpecBuilder = ParameterSpec.builder(RequestParameters.class, (String)"parameters", (Modifier[])new Modifier[0]);
            if (this.withAnnotations) {
                AnnotationSpec parameterGroupAnnotation = AnnotationSpec.builder(ParameterGroup.class).addMember("name", AbstractSdkOperation.REQUEST_PARAMETERS_GROUP_NAME, new Object[0]).build();
                parameterSpecBuilder.addAnnotation(parameterGroupAnnotation);
            }
            ParameterSpec requestParameter = parameterSpecBuilder.build();
            this.requestParameter = new ImmutablePair((Object)requestParameter, (Object)CodeBlock.builder().add(AbstractSdkOperation.PARAM_DOC_NAME_DESCRIPTION, new Object[]{requestParameter.name, "the {@link " + ((ClassName)requestParameter.type).simpleName() + "}"}));
            this.finalParameters.add(requestParameter);
            this.javaDoc.add(((CodeBlock.Builder)this.requestParameter.getRight()).build());
            return this;
        }

        public ParametersBuilder configurationOverridesParameter() {
            ParameterSpec.Builder parameterSpecBuilder = ParameterSpec.builder(ConfigurationOverrides.class, (String)"overrides", (Modifier[])new Modifier[0]);
            if (this.withAnnotations) {
                AnnotationSpec parameterGroupAnnotation = AnnotationSpec.builder(ParameterGroup.class).addMember("name", AbstractSdkOperation.CONNECTOR_OVERRIDES, new Object[0]).build();
                parameterSpecBuilder.addAnnotation(parameterGroupAnnotation);
            }
            ParameterSpec configurationOverride = parameterSpecBuilder.build();
            this.configurationOverridesParameter = new ImmutablePair((Object)configurationOverride, (Object)CodeBlock.builder().add(AbstractSdkOperation.PARAM_DOC_NAME_DESCRIPTION, new Object[]{configurationOverride.name, "the {@link ConfigurationOverrides}"}));
            this.finalParameters.add(configurationOverride);
            this.javaDoc.add(((CodeBlock.Builder)this.configurationOverridesParameter.getRight()).build());
            return this;
        }

        public ParametersBuilder callbackParameter(MessageOutputType messageOutputType) {
            ParameterSpec completionCallbackParameter = ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(CompletionCallback.class), (TypeName[])new TypeName[]{messageOutputType.getOutputType(), messageOutputType.getAttributeOutputType()}), (String)"callback", (Modifier[])new Modifier[0]).build();
            this.callbackParameter = new ImmutablePair((Object)completionCallbackParameter, (Object)CodeBlock.builder().add(AbstractSdkOperation.PARAM_DOC_NAME_DESCRIPTION, new Object[]{completionCallbackParameter.name, "the operation's {@link CompletionCallback}"}));
            this.finalParameters.add(completionCallbackParameter);
            this.javaDoc.add(((CodeBlock.Builder)this.callbackParameter.getRight()).build());
            return this;
        }

        public Pair<List<ParameterSpec>, CodeBlock.Builder> parametersSpecList() {
            return new ImmutablePair(this.finalParameters, (Object)this.javaDoc);
        }
    }

    public static class MessageOutputType {
        private final TypeName outputType;
        private final TypeName attributeOutputType;

        public MessageOutputType(TypeName outputType, TypeName attributeOutputType) {
            this.outputType = outputType;
            this.attributeOutputType = attributeOutputType;
        }

        public MessageOutputType(Class<?> outputType, Class<?> attributeOutputType) {
            this((TypeName)ClassName.get(outputType), (TypeName)ClassName.get(attributeOutputType));
        }

        public TypeName getOutputType() {
            return this.outputType;
        }

        public TypeName getAttributeOutputType() {
            return this.attributeOutputType;
        }
    }
}

