/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.api;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class RestSdkRunConfiguration {

  private final boolean skipValidations;
  private final boolean useDynamicTypeResolvers;
  private final String generatedSourcesDir;
  private final String sourceDir;
  private final String generatedResourcesDir;
  private final String overrideDir;
  private final String refinementDir;
  private final String ignoredDir;
  private final boolean regenerateMode;
  private final RestSdkMessageCollector messageCollector;
  private final String generatedSchemasDir;
  private final List<Path> processedRefinements;
  private final List<String> processedFiles;

  private RestSdkRunConfiguration(boolean skipValidations,
                                  boolean useDynamicTypeResolvers,
                                  String generatedSourcesDir,
                                  String sourceDir,
                                  String generatedResourcesDir,
                                  String overrideDir,
                                  String refinementSourceDir,
                                  String ignoredDir,
                                  boolean regenerateMode,
                                  String generatedSchemasDir) {
    this.skipValidations = skipValidations;
    this.useDynamicTypeResolvers = useDynamicTypeResolvers;
    this.generatedSourcesDir = generatedSourcesDir;
    this.sourceDir = sourceDir;
    this.overrideDir = overrideDir;
    this.ignoredDir = ignoredDir;
    this.regenerateMode = regenerateMode;
    this.generatedResourcesDir = generatedResourcesDir;
    this.messageCollector = new RestSdkMessageCollector();
    this.generatedSchemasDir = generatedSchemasDir;
    this.refinementDir = refinementSourceDir;
    this.processedRefinements = new ArrayList<>();
    this.processedFiles = new ArrayList<>();
  }

  public static Builder builder() {
    return new Builder();
  }

  public boolean regenerateMode() {
    return regenerateMode;
  }

  public boolean skipValidations() {
    return skipValidations;
  }

  public boolean useDynamicTypeResolvers() {
    return useDynamicTypeResolvers;
  }

  public String getGeneratedSourcesDir() {
    return generatedSourcesDir;
  }

  public String getGeneratedResourcesDir() {
    return generatedResourcesDir;
  }

  public String getSourceDir() {
    return sourceDir;
  }

  public String getIgnoredDir() {
    return ignoredDir;
  }

  public String getOverrideDir() {
    return overrideDir;
  }

  public String getRefinementDir() {
    return refinementDir;
  }

  public RestSdkMessageCollector messageCollector() {
    return messageCollector;
  }

  public String getGeneratedSchemasDir() {
    return generatedSchemasDir;
  }

  public List<Path> getProcessedRefinements() {
    return processedRefinements;
  }

  public List<String> getProcessedFiles() {
    return processedFiles;
  }

  public static class Builder {

    private boolean skipValidations = false;
    private boolean useDynamicTypeResolvers = false;
    private String generatedSourceDir = "src/main/java";
    private String sourcesDir = "src/main/java";
    private String generatedResourcesDir = "src/main/resources";
    private String overrideSourceDir = "src/main/override";
    private String refinementSourceDir = "src/main/refinement";
    private String ignoreDir = "target/ignored";
    private boolean regenerateMode = false;
    private String generatedSchemasDir = "rest_sdk_generated_schemas";

    public RestSdkRunConfiguration build() {
      return new RestSdkRunConfiguration(skipValidations,
                                         useDynamicTypeResolvers,
                                         generatedSourceDir,
                                         sourcesDir,
                                         generatedResourcesDir,
                                         overrideSourceDir,
                                         refinementSourceDir,
                                         ignoreDir,
                                         regenerateMode,
                                         generatedSchemasDir);
    }

    public Builder skipValidations(boolean skipValidations) {
      this.skipValidations = skipValidations;
      return this;
    }

    public Builder generatedResourcesDir(String generatedResourcesDir) {
      this.generatedResourcesDir = generatedResourcesDir;
      return this;
    }

    public Builder generatedSourceDir(String generatedSourceDir) {
      this.generatedSourceDir = generatedSourceDir;
      return this;
    }

    public Builder sourcesDir(String sourcesDir) {
      this.sourcesDir = sourcesDir;
      return this;
    }

    public Builder regenerateMode(boolean regenerateMode) {
      this.regenerateMode = regenerateMode;
      return this;
    }

    public Builder ignoredDir(String ignoredDir) {
      this.ignoreDir = ignoredDir;
      return this;
    }

    public Builder overrideSourceDir(String relativeOverridePath) {
      this.overrideSourceDir = relativeOverridePath;
      return this;
    }

    public Builder refinementSourceDir(String relativeRefinementPath) {
      this.refinementSourceDir = relativeRefinementPath;
      return this;
    }

    public Builder useDynamicTypeResolvers(boolean useDynamicTypeResolvers) {
      this.useDynamicTypeResolvers = useDynamicTypeResolvers;
      return this;
    }

    public Builder generatedSchemasDir(String generatedSchemasDir) {
      this.generatedSchemasDir = generatedSchemasDir;
      return this;
    }
  }
}
