/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.layers;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils.getJavaUpperCamelNameFromXml;
import static javax.lang.model.element.Modifier.PUBLIC;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication.SdkAuthenticationStrategy;

import java.nio.file.Path;

import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;

public class SdkConnectionProviderRefinementLayer extends AbstractSdkConnectionProviderLayer {

  public static final String REFINEMENT_LAYER_JAVADOC =
      "This Refinement class is the middle layer of the connection provider generation gap pattern. "
          + "It can be overridden to add custom logic in the connection provider.";

  private final TypeName baseClass;

  public SdkConnectionProviderRefinementLayer(Path outputDir,
                                              ConnectorModel connectorModel,
                                              ConnectorSecurityScheme securityScheme,
                                              SdkAuthenticationStrategy authenticationStrategy,
                                              TypeName baseClass,
                                              RestSdkRunConfiguration runConfiguration) {
    super(outputDir, connectorModel, securityScheme, authenticationStrategy, runConfiguration);

    this.baseClass = baseClass;
  }

  @Override
  public void applyTemplates() throws TemplatingException {
    generateConnectionProviderClass();
  }

  private void generateConnectionProviderClass() throws TemplatingException {
    TypeSpec.Builder connectionProviderClassBuilder =
        TypeSpec
            .classBuilder(getJavaClassName())
            .addModifiers(PUBLIC)
            .superclass(baseClass)
            .addJavadoc(REFINEMENT_LAYER_JAVADOC);

    writeClassToFile(connectionProviderClassBuilder.build(), getPackage(), true, securityScheme.isRefined());
  }

  public String getJavaClassName() {
    return getJavaUpperCamelNameFromXml(getConnectionProviderXmlName()) + CONNECTION_PROVIDER_CLASSNAME_SUFFIX
        + REFINEMENT_CLASSNAME_SUFFIX;
  }

  public String getPackage() {
    return getConnectionProviderBasePackage() + REFINEMENT_PACKAGE_SUFFIX;
  }
}
