/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.operation;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.rest.commons.internal.util.StreamUtils;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.Pagination;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.AbstractSdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.SdkPaginationStrategy;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.tuple.Pair;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;

public abstract class AbstractSdkPaginationOperation
extends AbstractSdkOperation
implements SdkPaginationStrategy {
    private final Pagination pagination;
    private static final String BASE_REQUEST_BUILDER_MAIN_METHOD_NAME = "RequestBuilderMain";
    private static final String BASE_PAGING_PROVIDER_MAIN_METHOD_NAME = "PagingProviderMain";
    private static final String PARAMETER_REQUEST_FACTORY = "requestFactory";
    private static final String PARAMETERS_BINDINGS_REF_NAME = "parameterBindingsRef";
    private static final String CUSTOM_PARAMETERS_BINDINGS_REF_NAME = "customParameterBindingsRef";

    public AbstractSdkPaginationOperation(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, sdkConnector, operation, runConfiguration);
        this.pagination = operation.getPagination();
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    protected abstract List<ParameterSpec> getPagingParametersAsParameterSpecs() throws TemplatingException;

    @Override
    protected void generateOperationMethodsFlow(TypeSpec.Builder operationClassBuilder) throws TemplatingException {
        operationClassBuilder.addMethod(this.generateBaseMainMethod());
        operationClassBuilder.addMethod(this.generateRequestBuilderMainMethod());
        operationClassBuilder.addMethod(this.generatePagingProviderMainMethod());
    }

    protected void addResponseBindings(CodeBlock.Builder block) {
        if (this.operation.getResponseBindings() != null && !((List)this.operation.getResponseBindings().get()).isEmpty()) {
            block.add(".withResponseBinding(getResponseBindings())", new Object[0]);
        }
        block.add(";", new Object[0]);
    }

    @Override
    public CodeBlock getPagingMethodOperation() throws TemplatingException {
        CodeBlock.Builder block = CodeBlock.builder();
        block.add("return new $T($S, $L, $L, getExpressionLanguage(), $S,  resolveDefaultResponseMediaType(config), $L, $L, overrides.getResponseTimeoutAsMillis())", new Object[]{this.getPagingProviderClass(), this.pagination.getPaginationParameter(), this.getPagingParameter().getJavaName(), PARAMETER_REQUEST_FACTORY, this.getPayloadExpression(), "parameterBindings", "customParameterBindings"});
        this.addResponseBindings(block);
        return block.build();
    }

    protected SdkParameter getPagingParameter() throws TemplatingException {
        return this.allQueryParameters.stream().filter(x -> x.getExternalName().equalsIgnoreCase(this.pagination.getPaginationParameter())).findFirst().orElseThrow(() -> new TemplatingException("Could not get paging parameter, this is a bug."));
    }

    @Override
    public TypeName generateMethodReturn() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(PagingProvider.class), (TypeName[])new TypeName[]{TypeName.get(RestConnection.class), ParameterizedTypeName.get(TypedValue.class, (Type[])new Type[]{String.class})});
    }

    @Override
    protected AbstractSdkOperation.MessageOutputType getMessageOutputType() {
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class});
        TypeName attribute = TypeName.get(Void.class);
        return new AbstractSdkOperation.MessageOutputType((TypeName)parameterizedTypeName, attribute);
    }

    @Override
    protected AbstractSdkOperation.ParametersBuilder generateBaseMainMethodParameters() {
        return AbstractSdkOperation.builder().configurationParameter().uriParameters(this.allUriParameters).queryParameters(this.generateQueryParameters()).headerParameters(this.allHeaders).auxParameters(this.auxParameters).customParameterBinding().contentParameter(this.generateContentParameters(false)).requestParameter().configurationOverridesParameter();
    }

    @Override
    protected Pair<List<ParameterSpec>, CodeBlock.Builder> generateOperationImplementationMethodParameters() {
        return AbstractSdkOperation.builder().withAnnotations().configurationParameter().uriParameters(this.allUriParameters).queryParameters(this.generateQueryParameters()).headerParameters(this.allHeaders).auxParameters(this.auxParameters).contentParameter(this.generateContentParameters(true)).requestParameter().configurationOverridesParameter().parametersSpecList();
    }

    @Override
    public CodeBlock generateOperationMethodBaseMainBody() throws TemplatingException {
        CodeBlock.Builder paginationBody = CodeBlock.builder();
        paginationBody.add(this.generateAuxParameterBindings());
        paginationBody.add(this.toCursorProviderVariables());
        paginationBody.addStatement("$T<$T,$T> $L = connection -> $L", new Object[]{Function.class, RestConnection.class, RestRequestBuilder.class, PARAMETER_REQUEST_FACTORY, this.generateRequestBuilderMainCall()});
        paginationBody.add(this.generatePagingProviderCall());
        return paginationBody.build();
    }

    private CodeBlock toCursorProviderVariables() {
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.addStatement("$1T<$2T> $3L = new $1T<>($4T.resolveCursorProvider($5L))", new Object[]{Reference.class, Map.class, PARAMETERS_BINDINGS_REF_NAME, StreamUtils.class, "parameterBindings"});
        builder.addStatement("$1T<$2T> $3L = new $1T<>($4T.resolveCursorProvider($5L))", new Object[]{Reference.class, Map.class, CUSTOM_PARAMETERS_BINDINGS_REF_NAME, StreamUtils.class, "customParameterBindings"});
        return builder.build();
    }

    @Override
    protected List<String> generateOperationMainCallParameters() {
        return ((List)AbstractSdkOperation.builder().configurationParameter().uriParameters(this.allUriParameters).queryParameters(this.generateQueryParameters()).headerParameters(this.allHeaders).auxParameters(this.auxParameters).customParameterBinding().contentParameter(this.generateContentParameters(false)).requestParameter().configurationOverridesParameter().parametersSpecList().getLeft()).stream().map(x -> x.name).collect(Collectors.toList());
    }

    @Override
    protected MethodSpec generateOperationBaseMethod() throws TemplatingException {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)this.getJavaMethodName()).addModifiers(new Modifier[]{Modifier.PROTECTED});
        Pair<List<ParameterSpec>, CodeBlock.Builder> parameters = AbstractSdkOperation.builder().configurationParameter().uriParameters(this.allUriParameters).queryParameters(this.generateQueryParameters()).headerParameters(this.allHeaders).auxParameters(this.auxParameters).contentParameter(this.generateContentParameters(false)).requestParameter().configurationOverridesParameter().parametersSpecList();
        methodBuilder.addParameters((Iterable)parameters.getLeft());
        TypeName returnType = this.generateMethodReturn();
        methodBuilder.addStatement("$1T<$2T,$3T> $4L = new $5T<>()", new Object[]{Map.class, String.class, Object.class, "customParameterBindings", HashMap.class});
        methodBuilder.addCode(this.generateOperationMainCall(returnType));
        if (returnType != null) {
            methodBuilder.returns(returnType);
        }
        return methodBuilder.build();
    }

    private String getRequestBuilderMainName() {
        return this.getJavaMethodName() + BASE_REQUEST_BUILDER_MAIN_METHOD_NAME;
    }

    private String getPagingProviderMainName() {
        return this.getJavaMethodName() + BASE_PAGING_PROVIDER_MAIN_METHOD_NAME;
    }

    private List<ParameterSpec> getHttpParamsParameterSpecs() {
        Pair<List<ParameterSpec>, CodeBlock.Builder> parameters = AbstractSdkOperation.builder().uriParameters(this.allUriParameters).queryParameters(this.generateQueryParametersNoPaginated()).headerParameters(this.allHeaders).parametersSpecList();
        return (List)parameters.getLeft();
    }

    private CodeBlock generateRequestBuilderMainCall() {
        CodeBlock.Builder requestBuilderCall = CodeBlock.builder();
        AbstractSdkOperation.ParametersBuilder parameters = AbstractSdkOperation.builder();
        parameters.requestParameter();
        parameters.configurationOverridesParameter();
        parameters.connectionParameter();
        parameters.configurationParameter();
        parameters.parameterBinding();
        parameters.customParameterBinding();
        List parametersParsed = ((List)parameters.parametersSpecList().getLeft()).stream().map(x -> x.name).map(name -> {
            if (name.equals("parameterBindings")) {
                return "parameterBindingsRef.get()";
            }
            if (name.equals("customParameterBindings")) {
                return "customParameterBindingsRef.get()";
            }
            return name;
        }).collect(Collectors.toList());
        parametersParsed.addAll(this.getHttpParamsParameterSpecs().stream().map(param -> param.name).collect(Collectors.toList()));
        String parametersSpec = "$1L(" + parametersParsed.stream().collect(Collectors.joining(", ")) + ")";
        requestBuilderCall.add(parametersSpec, new Object[]{this.getRequestBuilderMainName()});
        return requestBuilderCall.build();
    }

    private CodeBlock generatePagingProviderCall() throws TemplatingException {
        CodeBlock.Builder requestBuilderCall = CodeBlock.builder();
        ArrayList parameters = new ArrayList(){
            {
                this.add(AbstractSdkPaginationOperation.PARAMETER_REQUEST_FACTORY);
                this.add("config");
                this.add("overrides");
                this.add("parameterBindings");
                this.add("customParameterBindings");
            }
        };
        parameters.addAll(this.getPagingParametersAsParameterSpecs().stream().map(param -> param.name).collect(Collectors.toList()));
        String parametersSpec = "return $L(" + parameters.stream().collect(Collectors.joining(", ")) + ")";
        requestBuilderCall.addStatement(parametersSpec, new Object[]{this.getPagingProviderMainName()});
        return requestBuilderCall.build();
    }

    private void generateRequestBuilderMainMethodSignature(MethodSpec.Builder methodSpec) {
        AbstractSdkOperation.ParametersBuilder parameters = AbstractSdkOperation.builder();
        parameters.requestParameter();
        parameters.configurationOverridesParameter();
        parameters.connectionParameter();
        parameters.configurationParameter();
        parameters.parameterBinding();
        parameters.customParameterBinding();
        parameters.uriParameters(this.allUriParameters);
        parameters.queryParameters(this.generateQueryParametersNoPaginated());
        parameters.headerParameters(this.allHeaders);
        methodSpec.addParameters((Iterable)parameters.parametersSpecList().getLeft());
    }

    public MethodSpec generateRequestBuilderMainMethod() {
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)this.getRequestBuilderMainName()).addModifiers(new Modifier[]{Modifier.PROTECTED});
        methodSpecBuilder.returns(RestRequestBuilder.class);
        this.generateRequestBuilderMainMethodSignature(methodSpecBuilder);
        methodSpecBuilder.addCode(this.generateRestRequestBuilder());
        methodSpecBuilder.addStatement("return builder", new Object[0]);
        return methodSpecBuilder.build();
    }

    private void generatePagingProviderMainMethodSignature(MethodSpec.Builder methodSpec) throws TemplatingException {
        ParameterSpec.Builder parameterBindingsSpec = ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{TypeName.get(RestConnection.class), TypeName.get(RestRequestBuilder.class)}), (String)PARAMETER_REQUEST_FACTORY, (Modifier[])new Modifier[0]);
        ArrayList<ParameterSpec> parameterSpecs = new ArrayList<ParameterSpec>();
        parameterSpecs.add(parameterBindingsSpec.build());
        AbstractSdkOperation.ParametersBuilder parameters = AbstractSdkOperation.builder().configurationParameter().configurationOverridesParameter().parameterBinding().customParameterBinding();
        parameterSpecs.addAll((Collection)parameters.parametersSpecList().getLeft());
        parameterSpecs.addAll(this.getPagingParametersAsParameterSpecs());
        methodSpec.addParameters(parameterSpecs);
    }

    public MethodSpec generatePagingProviderMainMethod() throws TemplatingException {
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)this.getPagingProviderMainName()).addModifiers(new Modifier[]{Modifier.PROTECTED});
        this.generatePagingProviderMainMethodSignature(methodSpecBuilder);
        methodSpecBuilder.addCode(this.getPagingMethodOperation());
        TypeName returnType = this.generateMethodReturn();
        if (returnType != null) {
            methodSpecBuilder.returns(returnType);
        }
        return methodSpecBuilder.build();
    }

    protected List<SdkParameter> generateQueryParametersNoPaginated() {
        if (this.pagination.getPaginationParameter() != null) {
            return this.allQueryParameters.stream().filter(x -> !this.pagination.getPaginationParameter().equals(x.getExternalName())).collect(Collectors.toList());
        }
        return this.allQueryParameters.stream().collect(Collectors.toList());
    }

    @Override
    public String getPayloadExpression() {
        return this.pagination.getPaginationResponseExpression();
    }

    @Override
    protected boolean requiresMediaTypeAnnotation() {
        return false;
    }
}

