/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverDeclaration;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProvider;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProviderReferenceParent;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverDefinition;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import java.util.Map;

public abstract class AbstractSdkResolverProviderReference
extends AbstractSdkResolverProvider {
    public static final String RESOLVER_NAME_FIELD = "RESOLVER_NAME";
    private final ResolverReference<?> reference;
    private final SdkResolverDefinition<?> sdkResolverDefinition;
    private final ResolverDeclaration<?> declaration;
    private TypeName superclass;
    private final boolean useExtensionsApi;

    public AbstractSdkResolverProviderReference(Path outputDir, ConnectorModel connectorModel, ResolverReference<?> reference, SdkResolverDefinition<?> sdkResolverDefinition, RestSdkRunConfiguration runConfiguration, boolean useExtensionsApi) {
        super(outputDir, connectorModel, runConfiguration);
        this.reference = reference;
        this.sdkResolverDefinition = sdkResolverDefinition;
        this.declaration = reference.getDeclaration();
        this.useExtensionsApi = useExtensionsApi;
    }

    protected void addBuildMethod(TypeSpec.Builder classBuilder) {
        this.sdkResolverDefinition.addBuildMethod(classBuilder, this.generateBuildMethodBody());
    }

    private CodeBlock generateBuildMethodBody() {
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.add("builder.reference(referenceBuilder -> referenceBuilder.declaration($1L)", new Object[]{RESOLVER_NAME_FIELD});
        for (Argument arg : this.reference.getArguments()) {
            builder.add(".argument($1S, argumentBuilder -> argumentBuilder.value(valueBuilder -> valueBuilder.expression($2S)))", new Object[]{arg.getName(), arg.getValue().getValue()});
        }
        builder.add(")", new Object[0]);
        return builder.build();
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        String declarationKey = this.declaration.getName() + (this.useExtensionsApi ? "extensions-api" : "");
        if (this.getAllParents().containsKey(declarationKey)) {
            this.superclass = this.getAllParents().get(declarationKey);
        } else {
            AbstractSdkResolverProviderReferenceParent parent = this.getNewParent(this.useExtensionsApi);
            parent.applyTemplates();
            this.superclass = parent.getTypeName();
            this.getAllParents().put(declarationKey, this.superclass);
        }
        super.applyTemplates();
    }

    protected abstract Map<String, TypeName> getAllParents();

    protected abstract AbstractSdkResolverProviderReferenceParent getNewParent(boolean var1);

    @Override
    protected TypeName getSuperClass() {
        return this.superclass;
    }

    @Override
    protected boolean isBoundParameter(SdkParameter sdkParameter) {
        String searchParam = sdkParameter.getParameterType().getAccessorName() + "." + sdkParameter.getExternalName();
        return this.reference.getArguments().stream().anyMatch(x -> x.getValue().getValue().contains(searchParam));
    }

    @Override
    protected void buildClass(TypeSpec.Builder classBuilder) {
        this.addParameterFieldsIfNeeded(classBuilder);
        this.addBuildMethod(classBuilder);
        this.addConfigureEvaluationContextMethod(classBuilder);
    }
}

