/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver;

import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.BindingField;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class SdkResolverUtil {
    public static String getBindingMethod(ParameterType parameterType) {
        switch (parameterType) {
            case URI: {
                return "uriParameter";
            }
            case QUERY: {
                return "queryParameter";
            }
            case HEADER: {
                return "header";
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean isBoundParameterForHttpBinding(SdkParameter sdkParameter, HttpRequestBinding httpBinding) {
        List parameterBindings;
        if (httpBinding == null) {
            return false;
        }
        if (sdkParameter.getParameterType().equals((Object)ParameterType.AUXILIAR)) {
            return true;
        }
        switch (sdkParameter.getParameterType()) {
            case URI: {
                parameterBindings = httpBinding.getUriParameter();
                break;
            }
            case QUERY: {
                parameterBindings = httpBinding.getQueryParameter();
                break;
            }
            case HEADER: {
                parameterBindings = httpBinding.getHeader();
                break;
            }
            default: {
                throw new IllegalArgumentException("Parameter type not supported. This is a bug.");
            }
        }
        return parameterBindings.stream().anyMatch(x -> x.getValue().getValue().contains(SdkResolverUtil.getBindingMethod(sdkParameter.getParameterType()) + "." + sdkParameter.getExternalName()));
    }

    public static List<BindingField> getBodyFieldsFromHttpBinding(HttpRequestBinding httpBinding) {
        if (httpBinding == null) {
            return Collections.emptyList();
        }
        String searchParam = ParameterType.BODY.getAccessorName() + ".";
        ArrayList parameterBindings = new ArrayList();
        parameterBindings.addAll(httpBinding.getUriParameter());
        parameterBindings.addAll(httpBinding.getQueryParameter());
        parameterBindings.addAll(httpBinding.getHeader());
        return parameterBindings.stream().filter(x -> x.getValue().getValue().contains(searchParam)).map(argument -> new BindingField(argument.getName(), argument.getValue().getValue().replace(searchParam, ""))).collect(Collectors.toList());
    }

    public static String getActingParameterJavaName(Argument argument) {
        return JavaUtils.getParameterJavaName((String)XmlUtils.getXmlName((String)argument.getName()), (boolean)false);
    }
}

