/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.EmptyTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.FileGenerationUtil;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.MetadataFormat;

public abstract class SdkAbstractStaticMetadataResolver
extends JavaTemplateEntity {
    private final TypeDefinition typeDefinition;
    private static final String GET_SCHEMA_PATH_METHOD_NAME = "getSchemaPath";
    private static final String GET_CATEGORY_NAME_METHOD_NAME = "getCategoryName";
    private static final String GET_QNAME_METHOD_NAME = "getQName";
    private static final String GET_FORMAT_METHOD_NAME = "getFormat";
    private final boolean requiresMetadataResolver;
    private final boolean requiresToWriteSchema;
    private String schemaName;
    private String schemaPath;
    private String className;
    private String javaPackage;
    private String categoryName;
    protected Class<?> superclass;

    public SdkAbstractStaticMetadataResolver(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, String internalName, TypeDefinition typeDefinition, FileGenerationUtil.SchemaNameType schemaNameType, String partName, String classNameOverride, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, runConfiguration);
        this.typeDefinition = typeDefinition;
        this.superclass = this.buildSuperclass(typeDefinition);
        this.requiresMetadataResolver = this.buildRequiresMetadataResolver();
        this.requiresToWriteSchema = this.requiresToWriteSchema();
        if (FileGenerationUtil.supportsSchemaGeneration(typeDefinition.getTypeSchema())) {
            this.schemaName = this.processSchemaName(sdkConnector, internalName, typeDefinition, schemaNameType, partName);
            if (this.requiresMetadataResolver) {
                this.className = this.buildClassName(internalName, partName, classNameOverride);
                this.javaPackage = this.buildPackage(connectorModel);
                this.categoryName = SdkAbstractStaticMetadataResolver.buildCategoryName(internalName);
                if (this.requiresToWriteSchema) {
                    Path schemaOutputDir = sdkConnector.getResourcesPath().resolve(runConfiguration.generatedSchemasDir());
                    FileGenerationUtil.writeSchema(typeDefinition.getTypeSchema(), schemaOutputDir, this.schemaName);
                    this.schemaPath = "/" + runConfiguration.generatedSchemasDir() + "/" + this.schemaName;
                }
            }
        }
    }

    private String processSchemaName(SdkConnector sdkConnector, String internalName, TypeDefinition typeDefinition, FileGenerationUtil.SchemaNameType schemaNameType, String partName) {
        Map<TypeSchema, String> typeSchemaNames = sdkConnector.getTypeSchemaNames();
        TypeSchema source = typeDefinition.getTypeSchema();
        return typeSchemaNames.computeIfAbsent(source, typeSchema -> this.getSchemaName(internalName, schemaNameType, source, partName));
    }

    protected String getSchemaName(String internalName, FileGenerationUtil.SchemaNameType schemaNameType, TypeSchema source, String partName) {
        return FileGenerationUtil.generateSchemaName(source, internalName, schemaNameType, partName);
    }

    protected abstract Class<?> buildSuperclass(TypeDefinition var1) throws TemplatingException;

    protected abstract String getClassNameSuffix();

    private String buildClassName(String internalName, String partName, String classNameOverride) {
        if (StringUtils.isBlank((CharSequence)classNameOverride)) {
            return JavaUtils.getJavaUpperCamelNameFromXml((String)internalName) + (StringUtils.isNotBlank((CharSequence)partName) ? JavaUtils.getJavaUpperCamelNameFromXml((String)XmlUtils.getXmlName((String)partName)) : "") + this.getClassNameSuffix();
        }
        return JavaUtils.getJavaUpperCamelNameFromXml((String)XmlUtils.getXmlName((String)classNameOverride)) + this.getClassNameSuffix();
    }

    private static String buildCategoryName(String internalName) {
        return internalName + "-type-resolver";
    }

    private String buildPackage(ConnectorModel connectorModel) {
        return connectorModel.getBasePackage() + ".internal.metadata";
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackage() {
        return this.javaPackage;
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        if (this.requiresMetadataResolver) {
            this.generateMetadataResolverClass();
        }
    }

    private void generateMetadataResolverClass() throws TemplatingException {
        TypeSpec.Builder typeResolverClassBuilder = TypeSpec.classBuilder((String)this.className).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(this.superclass);
        if (this.requiresToWriteSchema) {
            this.addGetSchemaPathMethod(typeResolverClassBuilder);
        }
        if (this.requiresCategoryNameMethod()) {
            this.addGetCategoryNameMethod(typeResolverClassBuilder);
        }
        if (this.requiresQNameMethod()) {
            this.addGetQNameMethod(typeResolverClassBuilder);
        }
        if (this.requiresFormatMethod()) {
            this.addFormatMethod(typeResolverClassBuilder);
        }
        this.writeClassToFile(typeResolverClassBuilder.build(), this.javaPackage);
    }

    private void addFormatMethod(TypeSpec.Builder typeResolverClassBuilder) {
        CodeBlock methodBody = CodeBlock.builder().addStatement("return new $1T($2S, $2S, $2S)", new Object[]{MetadataFormat.class, this.typeDefinition.getMediaType().getType() + "/" + this.typeDefinition.getMediaType().getSubtype()}).build();
        MethodSpec formatMethod = MethodSpec.methodBuilder((String)GET_FORMAT_METHOD_NAME).returns(TypeName.get(MetadataFormat.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(methodBody).build();
        typeResolverClassBuilder.addMethod(formatMethod);
    }

    private void addGetSchemaPathMethod(TypeSpec.Builder typeResolverClassBuilder) {
        CodeBlock methodBody = CodeBlock.builder().addStatement("return $S", new Object[]{this.schemaPath}).build();
        MethodSpec createConnectionMethod = MethodSpec.methodBuilder((String)GET_SCHEMA_PATH_METHOD_NAME).returns(TypeName.get(String.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(methodBody).build();
        typeResolverClassBuilder.addMethod(createConnectionMethod);
    }

    private void addGetCategoryNameMethod(TypeSpec.Builder typeResolverClassBuilder) {
        CodeBlock methodBody = CodeBlock.builder().addStatement("return $S", new Object[]{this.categoryName}).build();
        MethodSpec getCategoryNameMethod = MethodSpec.methodBuilder((String)GET_CATEGORY_NAME_METHOD_NAME).returns(TypeName.get(String.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(methodBody).build();
        typeResolverClassBuilder.addMethod(getCategoryNameMethod);
    }

    private void addGetQNameMethod(TypeSpec.Builder typeResolverClassBuilder) {
        CodeBlock methodBody = CodeBlock.builder().addStatement("return $S", new Object[]{this.getQName()}).build();
        MethodSpec getCategoryNameMethod = MethodSpec.methodBuilder((String)GET_QNAME_METHOD_NAME).returns(TypeName.get(String.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(methodBody).build();
        typeResolverClassBuilder.addMethod(getCategoryNameMethod);
    }

    protected boolean requiresCategoryNameMethod() {
        return true;
    }

    protected abstract boolean requiresQNameMethod();

    protected abstract boolean requiresFormatMethod();

    protected abstract String getQName();

    protected boolean buildRequiresMetadataResolver() {
        return !(this.typeDefinition instanceof EmptyTypeDefinition);
    }

    public boolean getRequiresMetadataResolver() {
        return this.requiresMetadataResolver;
    }

    protected abstract boolean requiresToWriteSchema();

    public String getSchemaName() {
        return this.schemaName;
    }

    public TypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }
}

