/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.sampledata;

import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.BindingField;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata.SampleDataDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProviderReference;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProviderReferenceParent;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.sampledata.SdkSampleDataDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.sampledata.SdkSampleDataReferenceParent;
import com.squareup.javapoet.TypeName;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SdkSampleDataReference
extends AbstractSdkResolverProviderReference {
    private final SdkConnector sdkConnector;
    private final ResolverReference<SampleDataDefinition> reference;
    private final SdkSampleDataDefinition sdkResolverDefinition;
    private final List<SdkParameter> sdkParameters;
    private final String parentClassName;

    public SdkSampleDataReference(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, String parentClassName, List<SdkParameter> sdkParameters, ResolverReference<SampleDataDefinition> reference, SdkSampleDataDefinition sdkResolverDefinition, RestSdkRunConfiguration runConfiguration) {
        super(outputDir, connectorModel, reference, sdkResolverDefinition, runConfiguration, false);
        this.sdkConnector = sdkConnector;
        this.reference = reference;
        this.sdkResolverDefinition = sdkResolverDefinition;
        this.sdkParameters = sdkParameters;
        this.parentClassName = parentClassName;
    }

    @Override
    public String getPackage() {
        return this.connectorModel.getBasePackage() + ".internal.metadata.sample";
    }

    @Override
    public String getJavaClassName() {
        return this.parentClassName + "SampleDataProvider";
    }

    @Override
    protected List<SdkParameter> getAllParameters() {
        return this.sdkParameters;
    }

    @Override
    protected List<BindingField> getBindingFields() {
        String searchParam = ParameterType.BODY.getAccessorName() + ".";
        return this.reference.getArguments().stream().filter(x -> x.getValue().getValue().contains(searchParam)).map(argument -> new BindingField(argument.getName(), argument.getValue().getValue().replace(searchParam, ""))).collect(Collectors.toList());
    }

    @Override
    protected String getEvaluationContextKind() {
        return this.sdkResolverDefinition.getEvaluationContextKind();
    }

    @Override
    protected Map<String, TypeName> getAllParents() {
        return this.sdkConnector.getParentSampleDataProviders();
    }

    @Override
    protected boolean isBoundParameter(SdkParameter sdkParameter) {
        if (sdkParameter.getParameterType().equals((Object)ParameterType.TRIGGER)) {
            return true;
        }
        return super.isBoundParameter(sdkParameter);
    }

    @Override
    protected AbstractSdkResolverProviderReferenceParent getNewParent(boolean useExtensionsApi) {
        return new SdkSampleDataReferenceParent(this.outputDir, this.connectorModel, this.reference, this.sdkResolverDefinition, this.sdkParameters, this.runConfiguration);
    }
}

