/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;

import java.io.File;
import java.nio.file.Path;
import java.util.List;

public abstract class TemplateEntity {

  public static TemplateEntity getTemplateEngine(ConnectorModel model,
                                                 List<File> descriptors,
                                                 RestSdkRunConfiguration runConfiguration,
                                                 Path outputDir)
      throws TemplatingException {

    return new SdkConnectorTemplateEntity(model, descriptors, runConfiguration, outputDir);
  }

  public abstract void applyTemplates() throws TemplatingException;
}
