/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.api;

public class RestSdkRunConfiguration {

  private final boolean skipValidations;
  private final boolean useDynamicTypeResolvers;
  private final String generatedSourceDir;
  private final String sourceDir;
  private final String generatedResourcesDir;
  private final String overrideDir;
  private final String ignoredDir;
  private final boolean regenerateMode;
  private RestSdkMessageCollector messageCollector;
  private final String generatedSchemasDir;

  private RestSdkRunConfiguration(boolean skipValidations,
                                  boolean useDynamicTypeResolvers,
                                  String generatedSourceDir,
                                  String sourceDir,
                                  String generatedResourcesDir,
                                  String overrideDir,
                                  String ignoredDir,
                                  boolean regenerateMode,
                                  String generatedSchemasDir) {
    this.skipValidations = skipValidations;
    this.useDynamicTypeResolvers = useDynamicTypeResolvers;
    this.generatedSourceDir = generatedSourceDir;
    this.sourceDir = sourceDir;
    this.overrideDir = overrideDir;
    this.ignoredDir = ignoredDir;
    this.regenerateMode = regenerateMode;
    this.generatedResourcesDir = generatedResourcesDir;
    this.messageCollector = new RestSdkMessageCollector();
    this.generatedSchemasDir = generatedSchemasDir;
  }

  public static Builder builder() {
    return new Builder();
  }

  public String generatedResourcesDir() {
    return generatedResourcesDir;
  }

  public boolean regenerateMode() {
    return regenerateMode;
  }

  public boolean skipValidations() {
    return skipValidations;
  }

  public String generatedSourceDir() {
    return generatedSourceDir;
  }

  public String sourceDir() {
    return sourceDir;
  }

  public String ignoredDir() {
    return ignoredDir;
  }

  public String overrideDir() {
    return overrideDir;
  }

  public RestSdkMessageCollector messageCollector() {
    return messageCollector;
  }

  public boolean useDynamicTypeResolvers() {
    return useDynamicTypeResolvers;
  }

  public String generatedSchemasDir() {
    return generatedSchemasDir;
  }

  public static class Builder {

    private boolean skipValidations = false;
    private boolean useDynamicTypeResolvers = false;
    private String generatedSourceDir = "src/main/java";
    private String sourceDir = "src/main/java";
    private String generatedResourcesDir = "src/main/resources";
    private String overrideSourceDir = "src/main/override";
    private String ignoreDir = "target/ignored";
    private boolean regenerateMode = false;
    private String generatedSchemasDir = "rest_sdk_generated_schemas";

    public RestSdkRunConfiguration build() {
      return new RestSdkRunConfiguration(skipValidations,
                                         useDynamicTypeResolvers,
                                         generatedSourceDir,
                                         sourceDir,
                                         generatedResourcesDir,
                                         overrideSourceDir,
                                         ignoreDir,
                                         regenerateMode,
                                         generatedSchemasDir);
    }

    public Builder skipValidations(boolean skipValidations) {
      this.skipValidations = skipValidations;
      return this;
    }

    public Builder generatedResourcesDir(String generatedResourcesDir) {
      this.generatedResourcesDir = generatedResourcesDir;
      return this;
    }

    public Builder generatedSourceDir(String generatedSourceDir) {
      this.generatedSourceDir = generatedSourceDir;
      return this;
    }

    public Builder sourcesDir(String sourceDir) {
      this.sourceDir = sourceDir;
      return this;
    }

    public Builder regenerateMode(boolean regenerateMode) {
      this.regenerateMode = regenerateMode;
      return this;
    }

    public Builder ignoredDir(String ignoredDir) {
      this.ignoreDir = ignoredDir;
      return this;
    }

    public Builder overrideSourceDir(String relativeOverridePath) {
      this.overrideSourceDir = relativeOverridePath;
      return this;
    }

    public Builder useDynamicTypeResolvers(boolean useDynamicTypeResolvers) {
      this.useDynamicTypeResolvers = useDynamicTypeResolvers;
      return this;
    }

    public Builder generatedSchemasDir(String generatedSchemasDir) {
      this.generatedSchemasDir = generatedSchemasDir;
      return this;
    }
  }
}
