/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverDefinition;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeSpec;

public interface SdkResolverDefinition<T extends ResolverDefinition<T>> {

  String EVALUATION_CONTEXT_KIND_OPERATION = "operation";
  String EVALUATION_CONTEXT_KIND_TRIGGER = "trigger";

  CodeBlock.Builder getResolverExpressionBuilder();

  void addBuildMethod(TypeSpec.Builder classBuilder, CodeBlock methodBody);

  void addClassConstants(TypeSpec.Builder classBuilder);

  T getDefinition();

  Class<?> getSdkResolverDefinitionClass();

  Class<?> getSdkResolverDeclarationBuilderClass();

  String getEvaluationContextKind();

}
