/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.sampledata;

import static java.lang.String.format;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata.SampleDataDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.Trigger;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProvider;

import java.nio.file.Path;
import java.util.List;

public class SdkSampleDataFactory {

  public static AbstractSdkResolverProvider getSdkSampleDataResolver(ConnectorOperation operation, ConnectorModel connectorModel,
                                                                     SdkConnector sdkConnector, String javaClassName,
                                                                     List<SdkParameter> allParameters, Path outputDir,
                                                                     RestSdkRunConfiguration runConfiguration) {
    final ResolverExpression<SampleDataDefinition> sampleData = operation.getSampleData();

    if (sampleData == null) {
      return null;
    }

    return getSdkSampleDataResolver(connectorModel, sdkConnector, javaClassName, allParameters, outputDir,
                                    runConfiguration, sampleData, operation.hasPagination(), false);
  }

  public static AbstractSdkResolverProvider getSdkSampleDataResolver(Trigger trigger, ConnectorModel connectorModel,
                                                                     SdkConnector sdkConnector, String javaClassName,
                                                                     List<SdkParameter> allParameters, Path outputDir,
                                                                     RestSdkRunConfiguration runConfiguration) {
    final ResolverExpression<SampleDataDefinition> sampleData = trigger.getSampleData();

    if (sampleData == null) {
      return null;
    }

    return getSdkSampleDataResolver(connectorModel, sdkConnector, javaClassName, allParameters, outputDir,
                                    runConfiguration, sampleData, false, true);
  }

  private static AbstractSdkResolverProvider getSdkSampleDataResolver(ConnectorModel connectorModel,
                                                                      SdkConnector sdkConnector, String javaClassName,
                                                                      List<SdkParameter> allParameters, Path outputDir,
                                                                      RestSdkRunConfiguration runConfiguration,
                                                                      ResolverExpression<SampleDataDefinition> sampleData,
                                                                      boolean isPaginated,
                                                                      boolean isTrigger) {
    if (sampleData instanceof SampleDataDefinition) {
      return new SdkSampleDataInline(outputDir,
                                     connectorModel,
                                     javaClassName,
                                     allParameters,
                                     new SdkSampleDataDefinition(sampleData, isTrigger, isPaginated),
                                     runConfiguration);
    } else if (sampleData instanceof ResolverReference) {
      return new SdkSampleDataReference(outputDir,
                                        connectorModel,
                                        sdkConnector,
                                        javaClassName,
                                        allParameters,
                                        (ResolverReference<SampleDataDefinition>) sampleData,
                                        new SdkSampleDataDefinition(sampleData, isTrigger, isPaginated),
                                        runConfiguration);
    }

    throw new IllegalArgumentException(format("Type not supported for Sdk Sample Data generation [%s]", sampleData.getClass()));
  }
}
