/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorCategory.PREMIUM;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorCategory.SELECT;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorCategory;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.templating.VelocityTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;

import java.nio.file.Path;
import java.util.Map;

import com.google.common.collect.ImmutableMap;

public class SdkLicense extends VelocityTemplateEntity {


  private static final Map<ConnectorCategory, String> LICENSED_CONNECTOR_CATEGORIES =
      ImmutableMap.<ConnectorCategory, String>builder()
          .put(SELECT, "templates/sdk/licenseSelect.vm")
          .put(PREMIUM, "templates/sdk/licensePremium.vm")
          .build();

  private final ConnectorModel model;

  public SdkLicense(Path outputDir, ConnectorModel connectorModel) {
    super(outputDir);
    this.model = connectorModel;
  }

  @Override
  public void applyTemplates() throws TemplatingException {
    if (LICENSED_CONNECTOR_CATEGORIES.containsKey(model.getCategory())) {
      applyTemplate(LICENSED_CONNECTOR_CATEGORIES.get(model.getCategory()), outputDir.resolve("LICENSE.md"));

    }
  }
}
