/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Field;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.SdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProvider;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.valueprovider.SdkValueProviderDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.valueprovider.SdkValueProviderInline;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.valueprovider.SdkValueProviderReference;

import java.nio.file.Path;

public class SdkField extends JavaTemplateEntity {

  private final Field field;
  private final SdkConnector connector;
  private final JavaTemplateEntity parentElement;
  private final AbstractSdkResolverProvider sdkValueProvider;

  public SdkField(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector,
                  Field field, JavaTemplateEntity parentElement, RestSdkRunConfiguration runConfiguration) {
    super(outputDir, connectorModel, runConfiguration);
    this.field = field;
    this.connector = sdkConnector;
    this.parentElement = parentElement;
    sdkValueProvider = generateSdkValueProvider();
  }

  @Override
  public void applyTemplates() throws TemplatingException {
    sdkValueProvider.applyTemplates();
  }

  protected AbstractSdkResolverProvider generateSdkValueProvider() {
    AbstractSdkResolverProvider valueProvider = null;
    if (field.getValueProvider() != null) {
      if (field.getValueProvider() instanceof ResolverDefinition) {
        valueProvider = new SdkValueProviderInline(outputDir,
                                                   connectorModel,
                                                   (SdkOperation) parentElement,
                                                   field.getPath(),
                                                   new SdkValueProviderDefinition(field.getValueProvider()),
                                                   runConfiguration,
                                                   false);


      } else if (field.getValueProvider() instanceof ResolverReference) {
        valueProvider = new SdkValueProviderReference(outputDir,
                                                      connectorModel,
                                                      connector,
                                                      (SdkOperation) parentElement,
                                                      field.getPath(),
                                                      (ResolverReference<ValueProviderDefinition>) field
                                                          .getValueProvider(),
                                                      new SdkValueProviderDefinition(field.getValueProvider()),
                                                      runConfiguration,
                                                      false);

      } else {
        throw new IllegalArgumentException("Value Provider generation not supported: " + field.getValueProvider());
      }

    }

    return valueProvider;
  }

  public Field getField() {
    return field;
  }

  public String getExternalName() {
    return field.getPath();
  }

  public AbstractSdkResolverProvider getSdkValueProvider() {
    return sdkValueProvider;
  }

}
