/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk;

import com.google.common.base.CaseFormat;
import com.mulesoft.connectivity.rest.commons.api.connection.BaseConnectionProvider;
import com.mulesoft.connectivity.rest.commons.api.connection.BasicAuthenticationConnectionProvider;
import com.mulesoft.connectivity.rest.commons.api.connection.BearerAuthenticationConnectionProvider;
import com.mulesoft.connectivity.rest.commons.api.connection.DigestConnectionProvider;
import com.mulesoft.connectivity.rest.commons.api.connection.MandatoryTlsParameterGroup;
import com.mulesoft.connectivity.rest.commons.api.connection.OptionalTlsParameterGroup;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.connection.TlsParameterGroup;
import com.mulesoft.connectivity.rest.commons.api.connection.oauth.BaseAuthorizationCodeConnectionProvider;
import com.mulesoft.connectivity.rest.commons.api.connection.oauth.BaseClientCredentialsConnectionProvider;
import com.mulesoft.connectivity.rest.commons.api.connection.validation.ConnectionValidationSettings;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.OAuth2AuthorizationCodeScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.OAuth2ClientCredentialsScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.OAuth2Scheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.TestConnectionConfig;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.TestConnectionValidationConfig;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.uri.BaseUri;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.model.SdkHttpProxyConfig;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.ClientCredentials;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.connectivity.NoConnectivityTest;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;

public class SdkConnectionProvider
extends JavaTemplateEntity {
    private static final String JAVA_DOC_BASE_URI = "@return the base uri of the REST API being consumed";
    private static final String CREATE_CONNECTION_METHOD_NAME = "createConnection";
    private static final String CREATE_CONNECTION_HTTP_CLIENT_PARAMETER_NAME = "httpClient";
    private static final String CREATE_CONNECTION_AUTHENTICATION_PARAMETER_NAME = "authentication";
    private static final String CREATE_CONNECTION_QUERY_PARAMS_PARAMETER_NAME = "defaultQueryParams";
    private static final String CREATE_CONNECTION_HEADERS_PARAMETER_NAME = "defaultHeaders";
    private static final String GET_PROXY_CONFIG_METHOD_NAME = "getProxyConfig";
    private static final String VALIDATE_CONNECTION_METHOD_NAME = "validate";
    private static final String VALIDATE_CONNECTION_CONNECTION_PARAMETER_NAME = "restConnection";
    private static final String VALIDATE_CONNECTION_SETTINGS_VAR_NAME = "settings";
    private static final String EXPRESSION_LANGUAGE_FIELD_NAME = "expressionLanguage";
    public static final String ACCESS_TOKEN_URL = "accessTokenUrl";
    public static final String AUTHORIZATION_URL = "authorizationUrl";
    public static final String DEFAULT_SCOPES = "defaultScopes";
    public static final String TOKEN_URL = "tokenUrl";
    private final ConnectorSecurityScheme securityScheme;
    private final List<SdkParameter> headers;
    private final List<SdkParameter> queryParameters;
    private final SdkHttpProxyConfig httpProxyConfig;

    public SdkConnectionProvider(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorSecurityScheme securityScheme, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, runConfiguration);
        this.securityScheme = securityScheme;
        this.headers = this.buildSdkParameters(securityScheme.getHeaders(), outputDir, connectorModel, sdkConnector);
        this.queryParameters = this.buildSdkParameters(securityScheme.getQueryParameters(), outputDir, connectorModel, sdkConnector);
        this.httpProxyConfig = new SdkHttpProxyConfig(outputDir, connectorModel, runConfiguration);
    }

    private List<SdkParameter> buildSdkParameters(List<Parameter> parameters, Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector) {
        ArrayList<SdkParameter> list = new ArrayList<SdkParameter>();
        for (Parameter param : parameters) {
            list.add(new SdkParameter(outputDir, connectorModel, sdkConnector, this.getJavaClassName(), param, this, this.runConfiguration));
        }
        return list;
    }

    public String getPackage() {
        return this.connectorModel.getBasePackage() + ".internal.connection.provider";
    }

    private String getConnectionProviderXmlName() {
        return XmlUtils.getXmlName((String)this.securityScheme.getName());
    }

    private String getConnectionProviderDisplayName() {
        return WordUtils.capitalize((String)this.getConnectionProviderXmlName().replace('-', ' ')) + " Connection Provider";
    }

    public String getJavaClassName() {
        return JavaUtils.getJavaUpperCamelNameFromXml((String)this.getConnectionProviderXmlName()) + "ConnectionProvider";
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.httpProxyConfig.applyTemplates();
        this.generateConnectionProviderClass();
    }

    private void generateConnectionProviderClass() throws TemplatingException {
        FieldSpec baseUriField = this.generateBaseUriField();
        TypeSpec.Builder connectionProviderClassBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(this.getConnectionProviderClass()).addAnnotation(this.generateAliasAnnotation()).addAnnotation(this.generateDisplayNameAnnotation()).addField(baseUriField).addMethod(this.generateGetter(baseUriField, CaseFormat.LOWER_CAMEL).addAnnotation(Override.class).addJavadoc(CodeBlock.builder().add(JAVA_DOC_BASE_URI, new Object[0]).add("\n", new Object[0]).build()).build());
        this.addOAuth(connectionProviderClassBuilder);
        this.addTls(connectionProviderClassBuilder);
        this.addCreateConnectionOverrideMethod(connectionProviderClassBuilder);
        this.addHttpProxyConfig(connectionProviderClassBuilder, this.httpProxyConfig.getTypeName());
        for (SdkParameter header : this.headers) {
            this.addParameterField(connectionProviderClassBuilder, header);
        }
        for (SdkParameter queryParam : this.queryParameters) {
            this.addParameterField(connectionProviderClassBuilder, queryParam);
        }
        if (this.shouldTestConnectivity()) {
            this.addValidateConnectionMethod(connectionProviderClassBuilder);
        } else {
            connectionProviderClassBuilder.addSuperinterface(NoConnectivityTest.class);
        }
        this.writeClassToFile(connectionProviderClassBuilder.build(), this.getPackage());
    }

    private void addHttpProxyConfig(TypeSpec.Builder connectionProviderClassBuilder, TypeName proxyConfigTypeName) {
        FieldSpec fieldSpec = this.generateHttpProxyConfigField(proxyConfigTypeName);
        connectionProviderClassBuilder.addField(fieldSpec);
        MethodSpec getProxyConfigMethod = MethodSpec.methodBuilder((String)GET_PROXY_CONFIG_METHOD_NAME).returns(TypeName.get(ProxyConfig.class)).addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).addCode(CodeBlock.builder().addStatement("return this.$N", new Object[]{fieldSpec}).build()).build();
        connectionProviderClassBuilder.addMethod(getProxyConfigMethod);
    }

    private boolean shouldTestConnectivity() {
        boolean hasTestConnectionDefinition = this.securityScheme.getTestConnectionConfig() != null;
        boolean isOauth = this.securityScheme instanceof OAuth2Scheme;
        boolean isAuthorizationCode = isOauth && ((OAuth2Scheme)this.securityScheme).getGrantType().equals((Object)OAuth2Scheme.GrantType.AUTHORIZATION_CODE);
        return hasTestConnectionDefinition && !isAuthorizationCode;
    }

    private void addParameterField(TypeSpec.Builder connectionProviderClassBuilder, SdkParameter parameter) {
        FieldSpec.Builder fieldBuilder = this.securityScheme.getSchemeType().equals((Object)ConnectorSecurityScheme.SecuritySchemeType.OAUTH2) ? parameter.generateOAuthParameterField() : parameter.generateParameterField();
        fieldBuilder.addModifiers(new Modifier[]{Modifier.PRIVATE}).addJavadoc(this.generateSdkParameterJavaDoc(parameter));
        connectionProviderClassBuilder.addField(fieldBuilder.build());
    }

    private void addCreateConnectionOverrideMethod(TypeSpec.Builder connectionProviderClassBuilder) {
        if (!(this.headers.isEmpty() && this.queryParameters.isEmpty() || this.securityScheme.getSchemeType().equals((Object)ConnectorSecurityScheme.SecuritySchemeType.OAUTH2))) {
            MethodSpec createConnectionMethod = MethodSpec.methodBuilder((String)CREATE_CONNECTION_METHOD_NAME).returns(TypeName.get(RestConnection.class)).addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).addParameter(HttpClient.class, CREATE_CONNECTION_HTTP_CLIENT_PARAMETER_NAME, new Modifier[0]).addParameter(HttpAuthentication.class, CREATE_CONNECTION_AUTHENTICATION_PARAMETER_NAME, new Modifier[0]).addParameter(this.getStringMultiMapTypeName(), CREATE_CONNECTION_QUERY_PARAMS_PARAMETER_NAME, new Modifier[0]).addParameter(this.getStringMultiMapTypeName(), CREATE_CONNECTION_HEADERS_PARAMETER_NAME, new Modifier[0]).addCode(this.generateCreateConnectionMethodBody()).build();
            connectionProviderClassBuilder.addMethod(createConnectionMethod);
        }
    }

    private CodeBlock generateCreateConnectionMethodBody() {
        CodeBlock.Builder methodBody = CodeBlock.builder();
        this.addCustomParameters(methodBody, this.queryParameters, CREATE_CONNECTION_QUERY_PARAMS_PARAMETER_NAME);
        this.addCustomParameters(methodBody, this.headers, CREATE_CONNECTION_HEADERS_PARAMETER_NAME);
        methodBody.addStatement("return super.createConnection($L, $L, $L, $L)", new Object[]{CREATE_CONNECTION_HTTP_CLIENT_PARAMETER_NAME, CREATE_CONNECTION_AUTHENTICATION_PARAMETER_NAME, CREATE_CONNECTION_QUERY_PARAMS_PARAMETER_NAME, CREATE_CONNECTION_HEADERS_PARAMETER_NAME});
        return methodBody.build();
    }

    private void addCustomParameters(CodeBlock.Builder methodBody, List<SdkParameter> parameters, String parametersParameterName) {
        if (!parameters.isEmpty()) {
            methodBody.beginControlFlow("if($L == null)", new Object[]{parametersParameterName}).addStatement("$L = new $T.StringMultiMap()", new Object[]{parametersParameterName, MultiMap.class}).endControlFlow();
            for (SdkParameter header : parameters) {
                methodBody.beginControlFlow("if($T.isNotBlank($L))", new Object[]{RestSdkUtils.class, header.getJavaName()}).addStatement("$L.put($S, $L)", new Object[]{parametersParameterName, header.getExternalName(), header.getJavaName()}).endControlFlow();
            }
        }
    }

    private void addValidateConnectionMethod(TypeSpec.Builder connectionProviderClassBuilder) {
        FieldSpec expressionLanguageField = FieldSpec.builder(ExpressionLanguage.class, (String)EXPRESSION_LANGUAGE_FIELD_NAME, (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(AnnotationSpec.builder(Inject.class).build()).build();
        connectionProviderClassBuilder.addField(expressionLanguageField);
        MethodSpec validateConnectionMethod = MethodSpec.methodBuilder((String)VALIDATE_CONNECTION_METHOD_NAME).returns(TypeName.get(ConnectionValidationResult.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(RestConnection.class, VALIDATE_CONNECTION_CONNECTION_PARAMETER_NAME, new Modifier[0]).addCode(this.generateValidateConnectionMethodBody()).build();
        connectionProviderClassBuilder.addMethod(validateConnectionMethod);
    }

    private CodeBlock generateValidateConnectionMethodBody() {
        CodeBlock.Builder methodBody = CodeBlock.builder();
        TestConnectionConfig testConnectionConfig = this.securityScheme.getTestConnectionConfig();
        String path = testConnectionConfig.getPath();
        String method = testConnectionConfig.getMethod() != null ? testConnectionConfig.getMethod().name() : null;
        Set validStatusCodes = testConnectionConfig.getValidStatusCodes();
        methodBody.add("$1T $2L = $1T.builder($3S, $4L)", new Object[]{ConnectionValidationSettings.class, VALIDATE_CONNECTION_SETTINGS_VAR_NAME, path, EXPRESSION_LANGUAGE_FIELD_NAME});
        if (StringUtils.isNotBlank((CharSequence)method)) {
            methodBody.add(".httpMethod($T.$L)", new Object[]{HttpConstants.Method.class, method});
        }
        if (!validStatusCodes.isEmpty()) {
            StringJoiner validStatusCodesJoiner = new StringJoiner(", ");
            validStatusCodes.forEach(validStatusCodesJoiner::add);
            methodBody.add(".validStatusCodes($L)", new Object[]{validStatusCodesJoiner});
        }
        for (TestConnectionValidationConfig validationConfig : testConnectionConfig.getValidations()) {
            if (!StringUtils.isNotBlank((CharSequence)validationConfig.getValidationExpression())) continue;
            if (StringUtils.isNotBlank((CharSequence)validationConfig.getErrorTemplateExpression())) {
                methodBody.add(".addValidation($S, $S)", new Object[]{validationConfig.getValidationExpression(), validationConfig.getErrorTemplateExpression()});
                continue;
            }
            methodBody.add(".addValidation($S)", new Object[]{validationConfig.getValidationExpression()});
        }
        if (testConnectionConfig.getMediaType() != null) {
            methodBody.add(".responseMediaType($T.parse($S))", new Object[]{MediaType.class, testConnectionConfig.getMediaType().toString()});
        }
        methodBody.add(".build();", new Object[0]);
        methodBody.addStatement("return $L($L, $L)", new Object[]{VALIDATE_CONNECTION_METHOD_NAME, VALIDATE_CONNECTION_CONNECTION_PARAMETER_NAME, VALIDATE_CONNECTION_SETTINGS_VAR_NAME});
        return methodBody.build();
    }

    private TypeName getStringMultiMapTypeName() {
        return ParameterizedTypeName.get(MultiMap.class, (Type[])new Type[]{String.class, String.class});
    }

    private void addTls(TypeSpec.Builder connectionProviderClassBuilder) {
        if (this.connectorModel.supportsHTTPS()) {
            FieldSpec tlsField = this.generateTlsField();
            CodeBlock.Builder tlsJavaDocBuilder = CodeBlock.builder();
            if (this.connectorModel.supportsHTTP()) {
                tlsJavaDocBuilder.add("\n{@link $L} that configures TLS and allows to switch between HTTP and HTTPS protocols.\n\n", new Object[]{TlsParameterGroup.class.getSimpleName()});
            } else {
                tlsJavaDocBuilder.add("\n{@link $L} that configures TLS for this connection.\n\n", new Object[]{TlsParameterGroup.class.getSimpleName()});
            }
            tlsJavaDocBuilder.add("@return an optional {@link $L}", new Object[]{TlsParameterGroup.class.getSimpleName()}).build();
            connectionProviderClassBuilder.addField(tlsField).addMethod(this.generateOptionalGetter(tlsField, TlsParameterGroup.class, CaseFormat.LOWER_CAMEL).addAnnotation(Override.class).addJavadoc(tlsJavaDocBuilder.build()).build());
        }
    }

    private void addOAuth(TypeSpec.Builder connectionProviderClassBuilder) throws TemplatingException {
        if (this.securityScheme.getSchemeType().equals((Object)ConnectorSecurityScheme.SecuritySchemeType.OAUTH2)) {
            AnnotationSpec oAuthAnnotation = null;
            if (this.getConnectionProviderClass().equals(BaseClientCredentialsConnectionProvider.class)) {
                OAuth2ClientCredentialsScheme clientCredentials = (OAuth2ClientCredentialsScheme)this.securityScheme;
                oAuthAnnotation = AnnotationSpec.builder(ClientCredentials.class).addMember(TOKEN_URL, "$S", new Object[]{clientCredentials.getAccessTokenUri()}).addMember(DEFAULT_SCOPES, "$S", new Object[]{clientCredentials.getScopes()}).build();
                clientCredentials.getRefreshTokenConditionExpression().ifPresent(expression -> this.addGetRefreshTokenConditionExpressionConfigMethod((String)expression, connectionProviderClassBuilder));
            } else if (this.getConnectionProviderClass().equals(BaseAuthorizationCodeConnectionProvider.class)) {
                OAuth2AuthorizationCodeScheme authorizationCode = (OAuth2AuthorizationCodeScheme)this.securityScheme;
                oAuthAnnotation = AnnotationSpec.builder(AuthorizationCode.class).addMember(ACCESS_TOKEN_URL, "$S", new Object[]{authorizationCode.getAccessTokenUri()}).addMember(AUTHORIZATION_URL, "$S", new Object[]{authorizationCode.getAuthorizationUri()}).addMember(DEFAULT_SCOPES, "$S", new Object[]{authorizationCode.getScopes()}).build();
                authorizationCode.getRefreshTokenConditionExpression().ifPresent(expression -> this.addGetRefreshTokenConditionExpressionConfigMethod((String)expression, connectionProviderClassBuilder));
            }
            if (oAuthAnnotation != null) {
                connectionProviderClassBuilder.addAnnotation(oAuthAnnotation);
            }
        }
    }

    private void addGetRefreshTokenConditionExpressionConfigMethod(String expression, TypeSpec.Builder connectionProviderClassBuilder) {
        CodeBlock methodBody = CodeBlock.builder().addStatement("return $S", new Object[]{expression}).build();
        MethodSpec getCategoryNameMethod = MethodSpec.methodBuilder((String)"getRefreshTokenCondition").returns(TypeName.get(String.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(methodBody).build();
        connectionProviderClassBuilder.addMethod(getCategoryNameMethod);
    }

    private CodeBlock generateSdkParameterJavaDoc(SdkParameter sdkParameter) {
        return CodeBlock.builder().add("$L\n", new Object[]{StringUtils.defaultIfEmpty((CharSequence)sdkParameter.getDescription(), (CharSequence)sdkParameter.getDisplayName())}).build();
    }

    private Class<? extends BaseConnectionProvider> getConnectionProviderClass() throws TemplatingException {
        ConnectorSecurityScheme.SecuritySchemeType securitySchemeType = this.securityScheme.getSchemeType();
        if (securitySchemeType.equals((Object)ConnectorSecurityScheme.SecuritySchemeType.BASIC)) {
            return BasicAuthenticationConnectionProvider.class;
        }
        if (securitySchemeType.equals((Object)ConnectorSecurityScheme.SecuritySchemeType.DIGEST_AUTHENTICATION)) {
            return DigestConnectionProvider.class;
        }
        if (securitySchemeType.equals((Object)ConnectorSecurityScheme.SecuritySchemeType.PASS_THROUGH)) {
            return BaseConnectionProvider.class;
        }
        if (securitySchemeType.equals((Object)ConnectorSecurityScheme.SecuritySchemeType.UNSECURED)) {
            return BaseConnectionProvider.class;
        }
        if (securitySchemeType.equals((Object)ConnectorSecurityScheme.SecuritySchemeType.OAUTH2)) {
            if (((OAuth2Scheme)this.securityScheme).getGrantType().equals((Object)OAuth2Scheme.GrantType.AUTHORIZATION_CODE)) {
                return BaseAuthorizationCodeConnectionProvider.class;
            }
            if (((OAuth2Scheme)this.securityScheme).getGrantType().equals((Object)OAuth2Scheme.GrantType.CLIENT_CREDENTIALS)) {
                return BaseClientCredentialsConnectionProvider.class;
            }
        } else if (securitySchemeType.equals((Object)ConnectorSecurityScheme.SecuritySchemeType.BEARER)) {
            return BearerAuthenticationConnectionProvider.class;
        }
        throw new TemplatingException("Connection Provider not available for " + securitySchemeType);
    }

    private AnnotationSpec generateDisplayNameAnnotation() {
        return AnnotationSpec.builder(DisplayName.class).addMember("value", "$S", new Object[]{this.getConnectionProviderDisplayName()}).build();
    }

    private AnnotationSpec generateAliasAnnotation() {
        return AnnotationSpec.builder(Alias.class).addMember("value", "$S", new Object[]{this.getConnectionProviderXmlName()}).build();
    }

    private FieldSpec generateBaseUriField() {
        FieldSpec.Builder baseUriFieldSpec = FieldSpec.builder(String.class, (String)"baseUri", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(AnnotationSpec.builder(DisplayName.class).addMember("value", "$S", new Object[]{"Base Uri"}).build()).addAnnotation(AnnotationSpec.builder(Summary.class).addMember("value", "$S", new Object[]{this.connectorModel.getBaseUri().getType().getDescription()}).build()).addJavadoc(CodeBlock.builder().add(JAVA_DOC_BASE_URI, new Object[0]).build());
        if (this.connectorModel.getBaseUri().isParameterizedBaseUri()) {
            baseUriFieldSpec.addAnnotation(org.mule.runtime.extension.api.annotation.param.Parameter.class).addAnnotation(this.buildBaseUriOptionalAnnotation(this.connectorModel.getBaseUri()));
        } else {
            baseUriFieldSpec.initializer("\"" + this.connectorModel.getBaseUri().getUri() + "\"", new Object[0]);
        }
        return baseUriFieldSpec.build();
    }

    private FieldSpec generateHttpProxyConfigField(TypeName proxyConfigTypeName) {
        FieldSpec.Builder proxyConfigSpec = FieldSpec.builder((TypeName)proxyConfigTypeName, (String)"proxyConfig", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(org.mule.runtime.extension.api.annotation.param.Parameter.class).addAnnotation(Optional.class).addAnnotation(AnnotationSpec.builder(Expression.class).addMember("value", "$T.$L", new Object[]{ExpressionSupport.class, ExpressionSupport.NOT_SUPPORTED}).build()).addAnnotation(AnnotationSpec.builder(Summary.class).addMember("value", "$S", new Object[]{"Reusable configuration element for outbound connections through a proxy"}).build()).addAnnotation(AnnotationSpec.builder(Placement.class).addMember("tab", "$S", new Object[]{"Proxy"}).build()).addJavadoc(CodeBlock.builder().add("Reusable configuration element for outbound connections through a proxy. \nA proxy element must define a host name and a port attributes, and optionally can define a username and a password.", new Object[0]).build());
        return proxyConfigSpec.build();
    }

    private AnnotationSpec buildBaseUriOptionalAnnotation(BaseUri baseUri) {
        AnnotationSpec.Builder optionalAnnotationBuilder = AnnotationSpec.builder(Optional.class);
        if (StringUtils.isNotBlank((CharSequence)baseUri.getUri())) {
            optionalAnnotationBuilder.addMember("defaultValue", "$S", new Object[]{this.connectorModel.getBaseUri().getUri()});
        }
        return optionalAnnotationBuilder.build();
    }

    private FieldSpec generateTlsField() {
        Class tlsClass = this.connectorModel.supportsHTTP() ? OptionalTlsParameterGroup.class : MandatoryTlsParameterGroup.class;
        return FieldSpec.builder(tlsClass, (String)"tlsConfig", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addJavadoc(CodeBlock.builder().add("{@link $L} references to a TLS config element. This will enable HTTPS for this config.\n", new Object[]{tlsClass.getSimpleName()}).build()).addAnnotation(AnnotationSpec.builder(ParameterGroup.class).addMember("name", "$S", new Object[]{"tls"}).build()).build();
    }
}

